/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ceph;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ceph.CephFS;

public class CephOutputStream
extends OutputStream {
    private static final Log LOG = LogFactory.getLog(CephOutputStream.class);
    private boolean closed;
    private CephFS ceph;
    private int fileHandle;
    private byte[] buffer;
    private int bufUsed = 0;

    public CephOutputStream(Configuration conf, CephFS cephfs, int fh, int bufferSize) {
        this.ceph = cephfs;
        this.fileHandle = fh;
        this.closed = false;
        this.buffer = new byte[bufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public long getPos() throws IOException {
        return this.ceph.lseek(this.fileHandle, 0L, 2);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        LOG.trace((Object)("CephOutputStream.write: writing a single byte to fd " + this.fileHandle));
        if (this.closed) {
            throw new IOException("CephOutputStream.write: cannot write a byte to fd " + this.fileHandle + ": stream closed");
        }
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        LOG.trace((Object)("CephOutputStream.write: writing " + len + " bytes to fd " + this.fileHandle));
        if (this.closed) {
            throw new IOException("CephOutputStream.write: cannot write " + len + "bytes to fd " + this.fileHandle + ": stream closed");
        }
        while (len > 0) {
            int write = Math.min(len, this.buffer.length - this.bufUsed);
            try {
                System.arraycopy(buf, off, this.buffer, this.bufUsed, write);
            }
            catch (IndexOutOfBoundsException ie) {
                throw new IOException("CephOutputStream.write: Indices out of bounds: write length is " + len + ", buffer offset is " + off + ", and buffer size is " + buf.length);
            }
            catch (ArrayStoreException ae) {
                throw new IOException("Uh-oh, CephOutputStream failed to do an array copy due to type mismatch...");
            }
            catch (NullPointerException ne) {
                throw new IOException("CephOutputStream.write: cannot write " + len + "bytes to fd " + this.fileHandle + ": buffer is null");
            }
            this.bufUsed += write;
            len -= write;
            off += write;
            if (this.bufUsed != this.buffer.length) continue;
            int result = this.ceph.write(this.fileHandle, this.buffer, this.bufUsed, -1L);
            if (result < 0) {
                throw new IOException("CephOutputStream.write: Buffered write of " + this.bufUsed + " bytes failed!");
            }
            if (result != this.bufUsed) {
                throw new IOException("CephOutputStream.write: Wrote only " + result + " bytes of " + this.bufUsed + " in buffer! Data may be lost or written" + " twice to Ceph!");
            }
            this.bufUsed = 0;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.closed) {
            if (this.bufUsed == 0) {
                return;
            }
            int result = this.ceph.write(this.fileHandle, this.buffer, this.bufUsed, -1L);
            if (result < 0) {
                throw new IOException("CephOutputStream.write: Write of " + this.bufUsed + "bytes to fd " + this.fileHandle + " failed");
            }
            if (result != this.bufUsed) {
                throw new IOException("CephOutputStream.write: Write of " + this.bufUsed + "bytes to fd " + this.fileHandle + "was incomplete:  only " + result + " of " + this.bufUsed + " bytes were written.");
            }
            this.bufUsed = 0;
            return;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        LOG.trace((Object)"CephOutputStream.close:enter");
        if (!this.closed) {
            this.flush();
            this.ceph.close(this.fileHandle);
            this.closed = true;
            LOG.trace((Object)"CephOutputStream.close:exit");
        }
    }
}

