/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;

public class DefaultMultipleCandidateResult<T>
implements MultipleCandidatesResult<T> {
    private final Set<T> candidateValues;
    private final T consumerValue;
    private Set<T> matches;

    public DefaultMultipleCandidateResult(@Nullable T consumerValue, Set<T> candidateValues) {
        assert (candidateValues.size() > 1);
        for (T candidateValue : candidateValues) {
            assert (candidateValue != null);
        }
        this.candidateValues = candidateValues;
        this.consumerValue = consumerValue;
    }

    @Override
    public boolean hasResult() {
        return this.matches != null;
    }

    @Override
    public Set<T> getMatches() {
        assert (this.matches != null);
        return this.matches;
    }

    @Nullable
    public T getConsumerValue() {
        return this.consumerValue;
    }

    public Set<T> getCandidateValues() {
        return this.candidateValues;
    }

    public void closestMatch(T candidate) {
        if (this.matches == null) {
            this.matches = new HashSet<T>(4);
        }
        this.matches.add(candidate);
    }
}

