/*
 * This source file is part of Daimonin (http://daimonin.sourceforge.net)
 * Copyright (c) 2007 The Daimonin Team
 * Also see acknowledgements in Readme.html
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * In addition, as a special exception, the copyright holders of client3d give
 * you permission to combine the client3d program with lgpl libraries of your
 * choice and/or with the fmod libraries.
 * You may copy and distribute such a system following the terms of the GNU GPL
 * for client3d and the licenses of the other code concerned.
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA, or go to
 * http://www.gnu.org/licenses/licenses.html
 */

package net.daimonin.client3d.editor.ui;

import net.daimonin.client3d.editor.main.Editor3D;

/**
 * Panel to set and save the preferences.
 * 
 * @author Rumbuff
 */
public class PreferencesPanel extends javax.swing.JPanel {

	/** Creates new form PreferencesPanel */
	public PreferencesPanel() {
		initComponents();
		jTextFieldFilenamePNG.setText(Editor3D.imageset);
		jTextFieldFilenameXML.setText(Editor3D.imagesetxml);
		jCheckBoxRestrictPNGSize.setSelected(Editor3D.restrictImageSize);
		jTextFieldRestrictedWidth.setText(String.valueOf(Editor3D.maxWidth));
		jTextFieldRestrictedHeight.setText(String.valueOf(Editor3D.maxHeight));
		if (!Editor3D.restrictImageSize) {
			jTextFieldRestrictedWidth.setEnabled(false);
			jTextFieldRestrictedHeight.setEnabled(false);
		}
	}

	/**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code ">
	private void initComponents() {
		jLabel1 = new javax.swing.JLabel();
		jTextFieldFilenamePNG = new javax.swing.JTextField();
		jLabel2 = new javax.swing.JLabel();
		jLabelRestrictedWidth = new javax.swing.JLabel();
		jLabelRestrictedHeight = new javax.swing.JLabel();
		jTextFieldFilenameXML = new javax.swing.JTextField();
		jCheckBoxRestrictPNGSize = new javax.swing.JCheckBox();
		jTextFieldRestrictedWidth = new javax.swing.JTextField();
		jTextFieldRestrictedHeight = new javax.swing.JTextField();
		jButtonSave = new javax.swing.JButton();
		jButtonSave.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonSaveActionPerformed(evt);
			}
		});
		jButtonCancel = new javax.swing.JButton();
		jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButtonCancelActionPerformed(evt);
			}
		});

		setMinimumSize(new java.awt.Dimension(550, 270));
		jLabel1.setText("PNG filename");

		jLabel2.setText("XML filename");

		jLabelRestrictedWidth.setText("restricted width");

		jLabelRestrictedHeight.setText("restricted height");

		jCheckBoxRestrictPNGSize.setSelected(true);
		jCheckBoxRestrictPNGSize.setText("restrict PNG size");
		jCheckBoxRestrictPNGSize.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
		jCheckBoxRestrictPNGSize.setMargin(new java.awt.Insets(0, 0, 0, 0));
		jCheckBoxRestrictPNGSize.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jCheckBoxRestrictPNGSizeActionPerformed(evt);
			}
		});

		jButtonSave.setText("Save");

		jButtonCancel.setText("Cancel");

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
		this.setLayout(layout);
		layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
				javax.swing.GroupLayout.Alignment.TRAILING,
				layout.createSequentialGroup().addGroup(
						layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING).addGroup(
								javax.swing.GroupLayout.Alignment.LEADING,
								layout.createSequentialGroup().addGap(89, 89, 89).addComponent(jButtonSave).addPreferredGap(
										javax.swing.LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE)
										.addComponent(jButtonCancel)).addGroup(
								layout.createSequentialGroup().addContainerGap().addGroup(
										layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(
												jLabelRestrictedHeight).addComponent(jLabel2).addComponent(jLabel1).addComponent(
												jLabelRestrictedWidth)).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addGroup(
												layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(
														jTextFieldFilenameXML, javax.swing.GroupLayout.DEFAULT_SIZE, 155, Short.MAX_VALUE)
														.addComponent(jCheckBoxRestrictPNGSize).addComponent(jTextFieldRestrictedWidth,
																javax.swing.GroupLayout.DEFAULT_SIZE, 155, Short.MAX_VALUE).addComponent(
																jTextFieldRestrictedHeight, javax.swing.GroupLayout.DEFAULT_SIZE, 155, Short.MAX_VALUE)
														.addComponent(jTextFieldFilenamePNG, javax.swing.GroupLayout.DEFAULT_SIZE, 155,
																Short.MAX_VALUE)))).addGap(268, 268, 268)));
		layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
				layout.createSequentialGroup().addContainerGap().addGroup(
						layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(
								jTextFieldFilenamePNG, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE,
								javax.swing.GroupLayout.PREFERRED_SIZE)).addPreferredGap(
						javax.swing.LayoutStyle.ComponentPlacement.RELATED).addGroup(
						layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(
								jTextFieldFilenameXML, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE,
								javax.swing.GroupLayout.PREFERRED_SIZE)).addGap(47, 47, 47).addComponent(jCheckBoxRestrictPNGSize)
						.addGap(20, 20, 20).addGroup(
								layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(
										jTextFieldRestrictedWidth, javax.swing.GroupLayout.PREFERRED_SIZE,
										javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE).addComponent(
										jLabelRestrictedWidth)).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
						.addGroup(
								layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(
										jLabelRestrictedHeight).addComponent(jTextFieldRestrictedHeight,
										javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE,
										javax.swing.GroupLayout.PREFERRED_SIZE)).addGap(36, 36, 36).addGroup(
								layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(jButtonSave)
										.addComponent(jButtonCancel)).addContainerGap(34, Short.MAX_VALUE)));
	}

	private void jCheckBoxRestrictPNGSizeActionPerformed(java.awt.event.ActionEvent evt) {
		if (jCheckBoxRestrictPNGSize.isSelected()) {
			jTextFieldRestrictedWidth.setEnabled(true);
			jTextFieldRestrictedHeight.setEnabled(true);
		} else {
			jTextFieldRestrictedWidth.setEnabled(false);
			jTextFieldRestrictedHeight.setEnabled(false);
		}
	}

	private void jButtonSaveActionPerformed(java.awt.event.ActionEvent evt) {
		Editor3D.savePreferences(this);
	}

	private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {
		Editor3D.cancelPreferences();
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButtonCancel;

	private javax.swing.JButton jButtonSave;

	public javax.swing.JCheckBox jCheckBoxRestrictPNGSize;

	private javax.swing.JLabel jLabel1;

	private javax.swing.JLabel jLabel2;

	private javax.swing.JLabel jLabelRestrictedHeight;

	private javax.swing.JLabel jLabelRestrictedWidth;

	public javax.swing.JTextField jTextFieldFilenamePNG;

	public javax.swing.JTextField jTextFieldFilenameXML;

	public javax.swing.JTextField jTextFieldRestrictedHeight;

	public javax.swing.JTextField jTextFieldRestrictedWidth;
	// End of variables declaration//GEN-END:variables

}
