/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.charabia.jsmoothgen.application.ExeCompiler;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.EditorPool;
import net.charabia.jsmoothgen.application.gui.Main;
import net.charabia.jsmoothgen.application.gui.editors.ApplicationArguments;
import net.charabia.jsmoothgen.application.gui.editors.ClassPath;
import net.charabia.jsmoothgen.application.gui.editors.CurrentDirectory;
import net.charabia.jsmoothgen.application.gui.editors.EmbeddedJar;
import net.charabia.jsmoothgen.application.gui.editors.ExecutableIcon;
import net.charabia.jsmoothgen.application.gui.editors.ExecutableName;
import net.charabia.jsmoothgen.application.gui.editors.InitialMemoryHeap;
import net.charabia.jsmoothgen.application.gui.editors.JSmoothInfo;
import net.charabia.jsmoothgen.application.gui.editors.JVMBundle;
import net.charabia.jsmoothgen.application.gui.editors.JVMSearchSequence;
import net.charabia.jsmoothgen.application.gui.editors.JavaProperties;
import net.charabia.jsmoothgen.application.gui.editors.MainClass;
import net.charabia.jsmoothgen.application.gui.editors.MaxMemoryHeap;
import net.charabia.jsmoothgen.application.gui.editors.MaxVersion;
import net.charabia.jsmoothgen.application.gui.editors.MinVersion;
import net.charabia.jsmoothgen.application.gui.editors.SkeletonChooser;
import net.charabia.jsmoothgen.application.gui.editors.SkeletonPropertiesEditor;
import net.charabia.jsmoothgen.application.gui.util.CommandRunner;
import net.charabia.jsmoothgen.application.gui.util.HelpButton;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import se.datadosen.component.RiverLayout;

public class MasterPanel
extends JPanel {
    private JButtonBar m_leftBar = new JButtonBar(1);
    private ButtonGroup m_leftGroup = new ButtonGroup();
    private JPanel m_mainpanel = new JPanel();
    private JScrollBar m_mainpanelVBar;
    private JScrollPane m_scrollpane;
    private Vector m_displayedElements = new Vector();
    private JSmoothModelBean m_model = new JSmoothModelBean();
    private File m_modelLocation = null;
    private EditorPool m_edPool = new EditorPool();
    private String m_currentPanelName = "";
    private Object[] m_skelElements = new Object[]{new SkeletonChooser(), new SkeletonPropertiesEditor()};
    private Object[] m_execElements = new Object[]{"GUI_LABEL_EXECUTABLE_SETTINGS", new ExecutableName(), new ExecutableIcon(), new CurrentDirectory()};
    private Object[] m_appElements = new Object[]{"GUI_LABEL_APPLICATION_SETTINGS", new MainClass(), new ApplicationArguments(), "GUI_LABEL_EMBEDDEDJAR_SETTINGS", new EmbeddedJar(), new ClassPath()};
    private Object[] m_jvmSelElements = new Object[]{"GUI_LABEL_JAVA_VERSION", new MinVersion(), new MaxVersion(), "GUI_LABEL_BUNDLEDJRE", new JVMBundle(), new JVMSearchSequence()};
    private Object[] m_jvmCfgElements = new Object[]{"GUI_LABEL_MEMORYSETTINGS", new MaxMemoryHeap(), new InitialMemoryHeap(), new JavaProperties()};
    private Object[] m_jsInfo = new Object[]{new JSmoothInfo()};
    private Vector m_lastErrors = new Vector();

    public MasterPanel() {
        this.setLayout(new BorderLayout());
        this.m_scrollpane = new JScrollPane((Component)this.m_leftBar);
        this.add("West", this.m_scrollpane);
        JScrollPane scp = new JScrollPane(this.m_mainpanel);
        this.m_mainpanelVBar = scp.getVerticalScrollBar();
        this.add("Center", scp);
        scp.setHorizontalScrollBarPolicy(31);
        this.m_mainpanel.setLayout((LayoutManager)new RiverLayout());
        this.addAction("Welcome", "/icons/stock_form-properties.png", this.m_jsInfo);
        this.addAction("Skeleton", "/icons/stock_new-template.png", this.m_skelElements);
        this.addAction("Executable", "/icons/stock_autopilot-24.png", this.m_execElements);
        this.addAction("Application", "/icons/stock_form-image-control.png", this.m_appElements);
        this.addAction("JVM Selection", "/icons/stock_search.png", this.m_jvmSelElements);
        this.addAction("JVM Configuration", "/icons/stock_form-properties.png", this.m_jvmCfgElements);
        this.setupPanel(this.m_jsInfo);
    }

    private String getLocaleText(String key) {
        try {
            String value = Main.TEXTS.getString(key);
            return value;
        }
        catch (Exception exception) {
            return key;
        }
    }

    private void addAction(final String name, String iconloc, final Object[] els) {
        AbstractAction a = new AbstractAction(name, new ImageIcon(this.getClass().getResource(iconloc))){

            public void actionPerformed(ActionEvent e) {
                if (MasterPanel.this.m_currentPanelName.equals(name)) {
                    return;
                }
                MasterPanel.this.setupPanel(els);
                MasterPanel.this.m_currentPanelName = name;
            }
        };
        JToggleButton jtb = new JToggleButton(a);
        this.m_leftGroup.add(jtb);
        this.m_leftBar.add((Component)jtb);
    }

    public void setupPanel(Object[] els) {
        this.fireUpdateModel();
        this.detachAll();
        this.m_mainpanel.removeAll();
        this.m_displayedElements.removeAllElements();
        if (els == null) {
            return;
        }
        JPanel pgroup = null;
        for (int i = 0; i < els.length; ++i) {
            if (els[i] instanceof Editor) {
                TitledBorder title;
                Editor ed = (Editor)els[i];
                if (ed.needsBigSpace() && pgroup != null) {
                    this.m_mainpanel.add("br hfill", pgroup);
                    pgroup = null;
                }
                if (pgroup == null) {
                    pgroup = new JPanel();
                    pgroup.setLayout((LayoutManager)new RiverLayout());
                    title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "");
                }
                if (ed.needsFullSpace()) {
                    pgroup.add("left hfill vfill", ed);
                    String gc = "br hfill vfill";
                    this.m_mainpanel.add(gc, ed);
                    ed.setMaximumSize(new Dimension(300, 300));
                    this.m_mainpanel.add("tab", new JLabel("..."));
                    pgroup = null;
                } else if (ed.needsBigSpace()) {
                    title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.getLocaleText(ed.getLabel()));
                    pgroup.setBorder(title);
                    pgroup.add("left vtop", new HelpButton(this.getLocaleText(ed.getDescription())));
                    pgroup.add("tab left hfill", ed);
                    String gc = "br hfill";
                    if (i + 1 >= els.length) {
                        gc = "p hfill vfill";
                    }
                    this.m_mainpanel.add(gc, pgroup);
                    pgroup = null;
                } else if (ed.useDescription()) {
                    pgroup.add("br left", new JLabel(this.getLocaleText(ed.getLabel())));
                    pgroup.add("tab", new HelpButton(this.getLocaleText(ed.getDescription())));
                    pgroup.add("tab hfill", ed);
                } else {
                    pgroup.add("left hfill", ed);
                }
                this.m_displayedElements.add(ed);
                continue;
            }
            if (!(els[i] instanceof String)) continue;
            if (pgroup != null) {
                this.m_mainpanel.add("br hfill", pgroup);
                pgroup = null;
            }
            pgroup = new JPanel();
            pgroup.setLayout((LayoutManager)new RiverLayout());
            TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.getLocaleText((String)els[i]));
            pgroup.setBorder(title);
        }
        if (pgroup != null) {
            this.m_mainpanel.add("p hfill", pgroup);
        }
        this.m_mainpanelVBar.setValue(0);
        this.attachAll();
        this.validate();
        this.repaint();
    }

    public void fireUpdateModel() {
        Iterator i = this.m_displayedElements.iterator();
        while (i.hasNext()) {
            Editor ed = (Editor)i.next();
            ed.updateModel();
        }
    }

    public void fireModelChanged() {
        Iterator i = this.m_displayedElements.iterator();
        while (i.hasNext()) {
            Editor ed = (Editor)i.next();
            ed.dataChanged();
        }
    }

    private void detachAll() {
        Iterator i = this.m_displayedElements.iterator();
        while (i.hasNext()) {
            Editor ed = (Editor)i.next();
            if (ed instanceof JSmoothModelBean.Listener) {
                this.m_model.removeListener((JSmoothModelBean.Listener)((Object)ed));
            }
            if (ed instanceof JSmoothModelBean.SkeletonChangedListener) {
                this.m_model.removeSkeletonChangedListener((JSmoothModelBean.SkeletonChangedListener)((Object)ed));
            }
            ed.detach();
        }
    }

    private void attachAll() {
        Iterator i = this.m_displayedElements.iterator();
        while (i.hasNext()) {
            Editor ed = (Editor)i.next();
            File basedir = null;
            if (this.m_modelLocation != null) {
                basedir = this.m_modelLocation.getParentFile();
            }
            ed.attach(this.m_model, basedir);
            if (ed instanceof JSmoothModelBean.Listener) {
                this.m_model.addListener((JSmoothModelBean.Listener)((Object)ed));
            }
            if (ed instanceof JSmoothModelBean.SkeletonChangedListener) {
                this.m_model.addSkeletonChangedListener((JSmoothModelBean.SkeletonChangedListener)((Object)ed));
            }
            ed.dataChanged();
        }
    }

    public void newModel() {
        JSmoothModelBean bean = new JSmoothModelBean();
        this.newModel(bean, null);
    }

    public void newModel(JSmoothModelBean bean, File location) {
        this.detachAll();
        this.m_model = bean;
        this.m_modelLocation = location;
        this.attachAll();
    }

    public boolean openFile(File f) {
        this.m_modelLocation = f;
        try {
            JSmoothModelBean model = JSmoothModelPersistency.load(this.m_modelLocation);
            this.newModel(model, f);
            return true;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return false;
        }
    }

    public boolean save() {
        if (this.m_modelLocation == null) {
            return false;
        }
        try {
            this.fireUpdateModel();
            this.m_model.normalizePaths(this.m_modelLocation.getParentFile(), true);
            JSmoothModelPersistency.save(this.m_modelLocation, this.m_model);
            return true;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return false;
        }
    }

    public Vector getLastErrors() {
        return this.m_lastErrors;
    }

    public ExeCompiler.CompilerRunner getCompiler() {
        File basedir;
        this.fireUpdateModel();
        this.m_model.normalizePaths(this.m_modelLocation.getParentFile());
        this.m_lastErrors.removeAllElements();
        SkeletonBean skel = Main.SKELETONS.getSkeleton(this.m_model.getSkeletonName());
        if (skel == null) {
            this.m_lastErrors.add(Main.local("UNKNOWN_SKEL"));
            return null;
        }
        File skelroot = Main.SKELETONS.getDirectory(skel);
        File exedir = basedir = this.m_modelLocation.getParentFile();
        try {
            File out = null;
            out = !new File(this.m_model.getExecutableName()).isAbsolute() ? new File(exedir, this.m_model.getExecutableName()) : new File(this.m_model.getExecutableName());
            ExeCompiler compiler = new ExeCompiler();
            ExeCompiler.CompilerRunner runner = compiler.getRunnable(skelroot, skel, basedir, this.m_model, out);
            return runner;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.m_lastErrors.add(exc.getMessage());
            return null;
        }
    }

    public void runexe() {
        this.fireUpdateModel();
        try {
            File basedir = this.m_modelLocation.getParentFile();
            File f = new File(basedir, this.m_model.getExecutableName());
            String[] cmd = new String[]{f.getAbsolutePath()};
            CommandRunner.run(cmd, f.getParentFile());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public File getProjectFile() {
        return this.m_modelLocation;
    }

    public void setProjectFile(File prjfile) {
        this.m_modelLocation = prjfile;
    }

    public JSmoothModelBean getModel() {
        return this.m_model;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame test = new JFrame("test");
        test.getContentPane().add(new MasterPanel());
        test.pack();
        test.setVisible(true);
    }
}

