/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Messages;
import megamek.common.verifier.TestEntity;

public class Engine
implements Serializable {
    private static final long serialVersionUID = -246032529363109609L;
    public static final float[] ENGINE_RATINGS = new float[]{0.0f, 0.25f, 0.5f, 0.5f, 0.5f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 1.5f, 1.5f, 1.5f, 2.0f, 2.0f, 2.0f, 2.5f, 2.5f, 3.0f, 3.0f, 3.0f, 3.5f, 3.5f, 4.0f, 4.0f, 4.0f, 4.5f, 4.5f, 5.0f, 5.0f, 5.5f, 5.5f, 6.0f, 6.0f, 6.0f, 7.0f, 7.0f, 7.5f, 7.5f, 8.0f, 8.5f, 8.5f, 9.0f, 9.5f, 10.0f, 10.0f, 10.5f, 11.0f, 11.5f, 12.0f, 12.5f, 13.0f, 13.5f, 14.0f, 14.5f, 15.5f, 16.0f, 16.5f, 17.5f, 18.0f, 19.0f, 19.5f, 10.5f, 21.5f, 22.5f, 23.5f, 24.5f, 25.5f, 27.0f, 28.5f, 29.5f, 31.5f, 33.0f, 34.5f, 36.5f, 38.5f, 41.0f, 43.5f, 46.0f, 49.0f, 52.5f, 56.5f, 61.0f, 66.5f, 72.5f, 79.5f, 87.5f, 97.0f, 107.5f, 119.5f, 133.5f, 150.0f, 168.5f, 190.0f, 214.5f, 243.0f, 275.5f, 313.0f, 356.0f, 405.5f, 462.5f};
    public static final int CLAN_ENGINE = 1;
    public static final int TANK_ENGINE = 2;
    public static final int LARGE_ENGINE = 4;
    public static final int COMBUSTION_ENGINE = 0;
    public static final int NORMAL_ENGINE = 1;
    public static final int XL_ENGINE = 2;
    public static final int XXL_ENGINE = 3;
    public static final int FUEL_CELL = 4;
    public static final int LIGHT_ENGINE = 5;
    public static final int COMPACT_ENGINE = 6;
    public static final int FISSION = 7;
    public boolean engineValid = true;
    private int engineRating;
    private int engineType;
    private int engineFlags;
    private int baseChassisHeatSinks = -1;
    public StringBuffer problem = new StringBuffer("Illegal engine: ");

    public Engine(int n, int n2, int n3) {
        this.engineRating = n;
        this.engineType = n2;
        this.engineFlags = n3;
        if (!this.isValidEngine()) {
            this.engineValid = false;
            this.engineRating = 0;
            this.engineType = -1;
            this.engineFlags = -1;
        }
    }

    public boolean hasFlag(int n) {
        return (this.engineFlags & n) != 0;
    }

    private boolean isValidEngine() {
        if (this.hasFlag(-8)) {
            this.problem.append("Flags:" + this.engineFlags);
            return false;
        }
        if ((int)Math.ceil(this.engineRating / 5) > ENGINE_RATINGS.length || this.engineRating < 0) {
            this.problem.append("Rating:" + this.engineRating);
            return false;
        }
        if (this.engineRating > 400) {
            this.engineFlags |= 4;
        }
        switch (this.engineType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 6: {
                if (this.hasFlag(2)) {
                    this.problem.append(Messages.getString("Engine.invalidMechOnly"));
                    return false;
                }
                if (!this.hasFlag(4)) break;
                this.problem.append(Messages.getString("Engine.invalidCompactLarge"));
                return false;
            }
            case 5: 
            case 7: {
                if (!this.hasFlag(1)) break;
                this.problem.append(Messages.getString("Engine.invalidSphereOnly"));
                return false;
            }
            default: {
                this.problem.append("Type:" + this.engineType);
                return false;
            }
        }
        return true;
    }

    public static int getEngineTypeByString(String string) {
        if (string.toLowerCase().indexOf("xxl") != -1) {
            return 3;
        }
        if (string.toLowerCase().indexOf("xl") != -1) {
            return 2;
        }
        if (string.toLowerCase().indexOf("light") != -1) {
            return 5;
        }
        if (string.toLowerCase().indexOf("compact") != -1) {
            return 6;
        }
        if (string.toLowerCase().indexOf("ice") != -1) {
            return 0;
        }
        if (string.toLowerCase().indexOf("i.c.e.") != -1) {
            return 0;
        }
        if (string.toLowerCase().indexOf("fission") != -1) {
            return 7;
        }
        if (string.toLowerCase().indexOf("fuel cell") != -1) {
            return 4;
        }
        return 1;
    }

    public boolean isFusion() {
        return this.engineType != 0 && this.engineType != 7 && this.engineType != 4;
    }

    public float getWeightEngine() {
        return this.getWeightEngine(2.0f);
    }

    public float getWeightEngine(float f) {
        float f2 = ENGINE_RATINGS[(int)Math.ceil(this.engineRating / 5)];
        switch (this.engineType) {
            case 0: {
                f2 *= 2.0f;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                f2 *= 0.5f;
                break;
            }
            case 5: {
                f2 *= 0.75f;
                break;
            }
            case 3: {
                f2 *= 0.33f;
                break;
            }
            case 6: {
                f2 *= 1.5f;
                break;
            }
            case 7: {
                f2 = (float)((double)f2 * 1.75);
                f2 = Math.max(5.0f, f2);
                break;
            }
            case 4: {
                f2 = (float)((double)f2 * 1.2);
            }
        }
        if (this.hasFlag(2) && this.engineType != 0) {
            f2 *= 1.5f;
        }
        return TestEntity.ceilMaxHalf(f2, f);
    }

    public int getWeightFreeEngineHeatSinks() {
        if (this.isFusion()) {
            return 10;
        }
        if (this.engineType == 7) {
            return 5;
        }
        if (this.engineType == 4) {
            return 1;
        }
        return 0;
    }

    public int integralHeatSinkCapacity() {
        return this.engineRating / 25;
    }

    public String getShortEngineName() {
        switch (this.engineType) {
            case 0: {
                return Integer.toString(this.engineRating) + Messages.getString("Engine.ICE");
            }
            case 1: {
                return Integer.toString(this.engineRating);
            }
            case 2: {
                return Integer.toString(this.engineRating) + Messages.getString("Engine.XL");
            }
            case 5: {
                return Integer.toString(this.engineRating) + Messages.getString("Engine.Light");
            }
            case 3: {
                return Integer.toString(this.engineRating) + Messages.getString("Engine.XXL");
            }
            case 6: {
                return Integer.toString(this.engineRating) + Messages.getString("Engine.Compact");
            }
            case 7: {
                return Integer.toString(this.engineRating) + Messages.getString("Engine.Fission");
            }
            case 4: {
                return Integer.toString(this.engineRating) + Messages.getString("Engine.FuelCell");
            }
        }
        return Messages.getString("Engine.invalid");
    }

    public String getEngineName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toString(this.engineRating));
        if (this.hasFlag(4)) {
            stringBuffer.append(Messages.getString("Engine.Large"));
        }
        switch (this.engineType) {
            case 0: {
                stringBuffer.append(" ICE");
                break;
            }
            case 1: {
                stringBuffer.append(" Fusion");
                break;
            }
            case 2: {
                stringBuffer.append(" XL");
                break;
            }
            case 5: {
                stringBuffer.append(" Light");
                break;
            }
            case 3: {
                stringBuffer.append(" XXL");
                break;
            }
            case 6: {
                stringBuffer.append(" Compact");
                break;
            }
            case 4: {
                stringBuffer.append(" Fuel Cell");
                break;
            }
            case 7: {
                stringBuffer.append(" FISSION");
                break;
            }
            default: {
                return this.problem.toString();
            }
        }
        if (this.hasFlag(1)) {
            stringBuffer.append(Messages.getString("Engine.Clan"));
        }
        if (this.hasFlag(2)) {
            stringBuffer.append(Messages.getString("Engine.Vehicle"));
        }
        return stringBuffer.toString();
    }

    public int getRating() {
        return this.engineRating;
    }

    public int[] getCenterTorsoCriticalSlots(int n) {
        if (this.engineType == 6) {
            int[] nArray = new int[]{0, 1, 2};
            return nArray;
        }
        if (this.hasFlag(4)) {
            if (n == 2) {
                int[] nArray = new int[]{0, 1, 2, 5, 6, 7, 8, 9};
                return nArray;
            }
            int[] nArray = new int[]{0, 1, 2, 7, 8, 9, 10, 11};
            return nArray;
        }
        if (n == 2) {
            int[] nArray = new int[]{0, 1, 2, 5, 6, 7};
            return nArray;
        }
        if (n == 1) {
            int[] nArray = new int[]{0, 1, 2, 9, 10, 11};
            return nArray;
        }
        int[] nArray = new int[]{0, 1, 2, 7, 8, 9};
        return nArray;
    }

    public int[] getSideTorsoCriticalSlots() {
        if (this.engineType == 5 || this.engineType == 2 && this.hasFlag(1)) {
            int[] nArray = new int[]{0, 1};
            return nArray;
        }
        if (this.engineType == 2) {
            int[] nArray = new int[]{0, 1, 2};
            return nArray;
        }
        if (this.engineType == 3 && this.hasFlag(1)) {
            int[] nArray = new int[]{0, 1, 2, 3};
            return nArray;
        }
        if (this.engineType == 3) {
            int[] nArray = new int[]{0, 1, 2, 3, 4, 5};
            return nArray;
        }
        int[] nArray = new int[]{};
        return nArray;
    }

    public int getStandingHeat() {
        switch (this.engineType) {
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public int getWalkHeat() {
        switch (this.engineType) {
            case 0: {
                return 0;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public int getRunHeat() {
        switch (this.engineType) {
            case 0: {
                return 0;
            }
            case 3: {
                return 6;
            }
        }
        return 2;
    }

    public int getJumpHeat(int n) {
        switch (this.engineType) {
            case 3: {
                return Math.max(6, n * 2);
            }
        }
        return Math.max(3, n);
    }

    public double getBVMultiplier() {
        int n = this.getSideTorsoCriticalSlots().length;
        if (n >= 3) {
            return 0.5;
        }
        if (n > 0) {
            return 0.75;
        }
        return 1.0;
    }

    public int getBaseCost() {
        int n = 0;
        switch (this.engineType) {
            case 0: {
                n = 1250;
                break;
            }
            case 1: {
                n = 5000;
                break;
            }
            case 2: {
                n = 20000;
                break;
            }
            case 3: {
                n = 100000;
                break;
            }
            case 6: {
                n = 10000;
                break;
            }
            case 5: {
                n = 15000;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            case 7: {
                n = 1;
            }
        }
        if (this.hasFlag(4)) {
            n *= 2;
        }
        return n;
    }

    public int getTechType() {
        int n = 1;
        switch (this.engineType) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n = 2;
                break;
            }
            case 3: 
            case 6: {
                n = 3;
            }
        }
        if (this.hasFlag(4)) {
            n = 3;
        }
        if (n == 3) {
            if (this.hasFlag(1)) {
                return 6;
            }
            return 5;
        }
        if (n == 2) {
            if (this.hasFlag(1)) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public int getEngineType() {
        return this.engineType;
    }

    public void setBaseChassisHeatSinks(int n) {
        this.baseChassisHeatSinks = n;
    }

    public int getBaseChassisHeatSinks() {
        return Math.min(this.integralHeatSinkCapacity(), this.baseChassisHeatSinks);
    }
}

