/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Report;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.PilotOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pilot
implements Serializable {
    private static final long serialVersionUID = -141169182388269619L;
    private String name;
    private int gunnery;
    private int piloting;
    private int hits;
    private boolean unconscious;
    private boolean doomed;
    private boolean dead;
    private boolean ejected;
    private int gunneryL;
    private int gunneryM;
    private int gunneryB;
    private int initBonus;
    private int commandBonus;
    private boolean koThisRound;
    private PilotOptions options = new PilotOptions();
    private static double[][] bvMod = new double[][]{{2.8, 2.63, 2.45, 2.28, 2.01, 1.82, 1.75, 1.67, 1.59}, {2.56, 2.4, 2.24, 2.08, 1.84, 1.6, 1.58, 1.51, 1.44}, {2.24, 2.1, 1.96, 1.82, 1.61, 1.4, 1.33, 1.31, 1.25}, {1.92, 1.8, 1.68, 1.56, 1.38, 1.2, 1.14, 1.08, 1.06}, {1.6, 1.5, 1.4, 1.3, 1.15, 1.0, 0.95, 0.9, 0.85}, {1.5, 1.35, 1.26, 1.17, 1.04, 0.9, 0.86, 0.81, 0.77}, {1.43, 1.33, 1.19, 1.11, 0.98, 0.85, 0.81, 0.77, 0.72}, {1.36, 1.26, 1.16, 1.04, 0.92, 0.8, 0.76, 0.72, 0.68}, {1.28, 1.19, 1.1, 1.01, 0.86, 0.75, 0.71, 0.68, 0.64}};
    public static final int DEATH = 6;

    public Pilot() {
        this("Unnamed", 4, 5);
    }

    public Pilot(String string, int n, int n2) {
        this.name = string;
        this.gunnery = n;
        this.gunneryL = n;
        this.gunneryM = n;
        this.gunneryB = n;
        this.piloting = n2;
        this.initBonus = 0;
        this.commandBonus = 0;
        this.hits = 0;
        this.unconscious = false;
        this.dead = false;
        this.koThisRound = false;
        this.options.initialize();
    }

    public Pilot(String string, int n, int n2, int n3, int n4) {
        this.name = string;
        this.gunnery = (int)Math.round((double)(n + n2 + n3) / 3.0);
        this.gunneryL = n;
        this.gunneryM = n2;
        this.gunneryB = n3;
        this.piloting = n4;
        this.initBonus = 0;
        this.commandBonus = 0;
        this.hits = 0;
        this.unconscious = false;
        this.dead = false;
        this.koThisRound = false;
        this.options.initialize();
    }

    public String getName() {
        return this.name;
    }

    public int getGunnery() {
        return this.gunnery;
    }

    public int getGunneryL() {
        return this.gunneryL;
    }

    public int getGunneryM() {
        return this.gunneryM;
    }

    public int getGunneryB() {
        return this.gunneryB;
    }

    public int getPiloting() {
        return this.piloting;
    }

    public int getHits() {
        return this.hits;
    }

    public int getInitBonus() {
        return this.initBonus;
    }

    public int getCommandBonus() {
        return this.commandBonus;
    }

    public void setGunnery(int n) {
        this.gunnery = n;
    }

    public void setGunneryL(int n) {
        this.gunneryL = n;
    }

    public void setGunneryM(int n) {
        this.gunneryM = n;
    }

    public void setGunneryB(int n) {
        this.gunneryB = n;
    }

    public void setPiloting(int n) {
        this.piloting = n;
    }

    public void setHits(int n) {
        if (!this.ejected) {
            this.hits = n;
        }
    }

    public void setInitBonus(int n) {
        this.initBonus = n;
    }

    public void setCommandBonus(int n) {
        this.commandBonus = n;
    }

    public boolean isUnconscious() {
        return this.unconscious;
    }

    public void setUnconscious(boolean bl) {
        this.unconscious = bl;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean bl) {
        if (!this.ejected) {
            this.dead = bl;
            if (bl) {
                this.hits = 6;
            }
        }
    }

    public boolean isDoomed() {
        return this.doomed;
    }

    public void setDoomed(boolean bl) {
        if (!this.ejected) {
            this.doomed = bl;
            if (this.doomed) {
                this.hits = 6;
            }
        }
    }

    public boolean isActive() {
        return !this.unconscious && !this.dead;
    }

    public boolean isKoThisRound() {
        return this.koThisRound;
    }

    public void setKoThisRound(boolean bl) {
        this.koThisRound = bl;
    }

    public void setOptions(PilotOptions pilotOptions) {
        this.options = pilotOptions;
    }

    public PilotOptions getOptions() {
        return this.options;
    }

    public void clearAdvantages() {
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("lvl3Advantages")) continue;
            Enumeration<IOption> enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = enumeration2.nextElement();
                iOption.clearValue();
            }
        }
    }

    public int countAdvantages() {
        int n = 0;
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("lvl3Advantages")) continue;
            Enumeration<IOption> enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = enumeration2.nextElement();
                if (!iOption.booleanValue()) continue;
                ++n;
            }
        }
        return n;
    }

    public Enumeration<IOption> getAdvantages() {
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("lvl3Advantages")) continue;
            return iOptionGroup.getOptions();
        }
        return new Vector().elements();
    }

    public String getAdvantageList(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == string) {
            string = "";
        }
        Enumeration<IOption> enumeration = this.getAdvantages();
        while (enumeration.hasMoreElements()) {
            IOption iOption = enumeration.nextElement();
            if (!iOption.booleanValue()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(iOption.getName());
            if (iOption.getType() != 3 && iOption.getType() != 4 && iOption.getType() != 1) continue;
            stringBuffer.append(" ").append(iOption.stringValue());
        }
        return stringBuffer.toString();
    }

    public String getImplantList(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == string) {
            string = "";
        }
        Enumeration<IOption> enumeration = this.getMDImplants();
        while (enumeration.hasMoreElements()) {
            IOption iOption = enumeration.nextElement();
            if (!iOption.booleanValue()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(iOption.getName());
            if (iOption.getType() != 3 && iOption.getType() != 4 && iOption.getType() != 1) continue;
            stringBuffer.append(" ").append(iOption.stringValue());
        }
        return stringBuffer.toString();
    }

    public static String parseAdvantageName(String string) {
        int n = (string = string.trim()).indexOf(" ");
        if (n == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    public static Object parseAdvantageValue(String string) {
        Object object;
        int n = (string = string.trim()).indexOf(" ");
        if (n == -1) {
            return new Boolean(true);
        }
        String string2 = string.substring(n + 1, string.length());
        try {
            object = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            object = string2;
        }
        return object;
    }

    public void clearMDImplants() {
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("MDAdvantages")) continue;
            Enumeration<IOption> enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = enumeration2.nextElement();
                iOption.clearValue();
            }
        }
    }

    public int countMDImplants() {
        int n = 0;
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("MDAdvantages")) continue;
            Enumeration<IOption> enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = enumeration2.nextElement();
                if (!iOption.booleanValue()) continue;
                ++n;
            }
        }
        return n;
    }

    public Enumeration<IOption> getMDImplants() {
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("MDAdvantages")) continue;
            return iOptionGroup.getOptions();
        }
        return new Vector().elements();
    }

    public String getDesc() {
        String string = new String(this.name);
        if (this.hits > 0) {
            string = string + " (" + this.hits + " hit(s)";
            if (this.isUnconscious()) {
                string = string + " [ko]";
            } else if (this.isDead()) {
                string = string + " [dead]";
            }
            string = string + ")";
        } else if (this.isUnconscious()) {
            string = string + " [ko]";
        } else if (this.isDead()) {
            string = string + " [dead]";
        }
        return string;
    }

    public Vector<Report> getDescVector(boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report();
        report.type = 0;
        report.add(this.name);
        if (bl) {
            report.messageId = 7050;
            report.add(this.getGunnery());
        } else {
            report.messageId = 7045;
            report.add(this.getGunnery());
            report.add(this.getPiloting());
        }
        if (this.hits > 0 || this.isUnconscious() || this.isDead()) {
            Report report2 = new Report();
            report2.type = 0;
            if (this.hits > 0) {
                report2.messageId = 7055;
                report2.add(this.hits);
                if (this.isUnconscious()) {
                    report2.messageId = 7060;
                    report2.choose(true);
                } else if (this.isDead()) {
                    report2.messageId = 7060;
                    report2.choose(false);
                }
            } else if (this.isUnconscious()) {
                report2.messageId = 7065;
                report2.choose(true);
            } else if (this.isDead()) {
                report2.messageId = 7065;
                report2.choose(false);
            }
            report.newlines = 0;
            vector.addElement(report);
            vector.addElement(report2);
        } else {
            vector.addElement(report);
        }
        return vector;
    }

    public boolean isCustom() {
        return this.gunnery != 4 || this.piloting != 5;
    }

    public double getBVSkillMultiplier() {
        return this.getBVImplantMultiplier() * Pilot.getBVSkillMultiplier(this.gunnery, this.piloting);
    }

    public double getBVImplantMultiplier() {
        int n = 1;
        if (this.options.booleanOption("pain_shunt")) {
            n = 2;
        }
        if (this.options.booleanOption("vdni")) {
            n = 3;
        }
        if (this.options.booleanOption("bvdni")) {
            n = 5;
        }
        double d = (double)n / 4.0 + 0.75;
        return d;
    }

    public static double getBVSkillMultiplier(int n, int n2) {
        return bvMod[n][n2];
    }

    public int modifyPhysicalDamagaForMeleeSpecialist() {
        if (!this.getOptions().booleanOption("melee_specialist")) {
            return 0;
        }
        return 1;
    }

    public boolean hasEdgeRemaining() {
        return this.getOptions().intOption("edge") > 0;
    }

    public void decreaseEdge() {
        IOption iOption = this.getOptions().getOption("edge");
        iOption.setValue((Integer)iOption.getValue() - 1);
    }

    public boolean isEjected() {
        return this.ejected;
    }

    public void setEjected(boolean bl) {
        this.ejected = bl;
    }

    public String getGunneryRPG() {
        return "" + this.gunneryL + "(L)/" + this.gunneryM + "(M)/" + this.gunneryB + "(B)";
    }

    public int getSensorOps() {
        if (this.piloting > -1) {
            return this.piloting;
        }
        return this.gunnery;
    }

    public boolean isPilotingFatigued(int n) {
        if (this.piloting > 5 && n > 9) {
            return true;
        }
        if (this.piloting > 3 && n > 13) {
            return true;
        }
        if (this.piloting > 1 && n > 16) {
            return true;
        }
        return n > 19;
    }

    public boolean isGunneryFatigued(int n) {
        if (this.piloting > 5 && n > 13) {
            return true;
        }
        if (this.piloting > 3 && n > 16) {
            return true;
        }
        return this.piloting > 1 && n > 19;
    }
}

