/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;

public class ConfineMetaClassChangesInterceptor
implements IMethodInterceptor {
    private final Collection<Class<?>> classes;
    private final List<MetaClass> originalMetaClasses = new ArrayList<MetaClass>();

    public ConfineMetaClassChangesInterceptor(Collection<Class<?>> classes) {
        this.classes = classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Class<?> clazz : this.classes) {
            this.originalMetaClasses.add(registry.getMetaClass(clazz));
            ExpandoMetaClass temporaryMetaClass = new ExpandoMetaClass(clazz, true, true);
            temporaryMetaClass.initialize();
            registry.setMetaClass(clazz, (MetaClass)temporaryMetaClass);
        }
        try {
            invocation.proceed();
        }
        catch (Throwable throwable) {
            for (MetaClass original : this.originalMetaClasses) {
                registry.setMetaClass(original.getTheClass(), original);
            }
            throw throwable;
        }
        for (MetaClass original : this.originalMetaClasses) {
            registry.setMetaClass(original.getTheClass(), original);
        }
    }
}

