/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.table;

import java.util.Collection;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Loadable;
import pcgen.core.kit.KitGear;
import pcgen.core.kit.KitTable;
import pcgen.core.utils.ParsingSeparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class ValuesToken
extends AbstractNonEmptyToken<KitTable>
implements CDOMPrimaryToken<KitTable> {
    public String getTokenName() {
        return "VALUES";
    }

    public Class<KitTable> getTokenClass() {
        return KitTable.class;
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, KitTable kitTable, String value) {
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        while (sep.hasNext()) {
            String thing = sep.next();
            if (thing.length() == 0) {
                return new ParseResult.Fail(this.getTokenName() + " arguments has invalid pipe separator: " + value, context);
            }
            KitGear optionInfo = new KitGear();
            for (String s : thing.split("[\\[\\]]")) {
                if (s.length() == 0) continue;
                int colonLoc = s.indexOf(58);
                if (colonLoc == -1) {
                    return new ParseResult.Fail("Expected colon in Value item: " + s + " within: " + value, context);
                }
                String key = s.substring(0, colonLoc);
                String thingValue = s.substring(colonLoc + 1);
                try {
                    boolean passed = context.processToken((Loadable)optionInfo, key, thingValue);
                    if (passed) continue;
                    return new ParseResult.Fail("Failure in token: " + key, context);
                }
                catch (PersistenceLayerException e) {
                    return new ParseResult.Fail("Failure in token: " + key + " " + e.getMessage(), context);
                }
            }
            if (!sep.hasNext()) {
                return new ParseResult.Fail("Odd token count in Value: " + value, context);
            }
            String range = sep.next();
            if (this.processRange(kitTable, optionInfo, range)) continue;
            return new ParseResult.Fail("Invalid Range in Value: " + range + " within " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private boolean processRange(KitTable kitTable, KitGear optionInfo, String range) {
        if (this.isEmpty(range) || this.hasIllegalSeparator(',', range)) {
            return false;
        }
        ParsingSeparator sep = new ParsingSeparator(range, ',');
        String minString = sep.next();
        String maxString = sep.hasNext() ? sep.next() : range;
        if (sep.hasNext()) {
            return false;
        }
        Formula min = FormulaFactory.getFormulaFor((String)minString);
        if (!min.isValid()) {
            Logging.errorPrint((String)("Min Formula in " + this.getTokenName() + " was not valid: " + min.toString()));
            return false;
        }
        Formula max = FormulaFactory.getFormulaFor((String)maxString);
        if (!max.isValid()) {
            Logging.errorPrint((String)("Max Formula in " + this.getTokenName() + " was not valid: " + max.toString()));
            return false;
        }
        kitTable.addGear(optionInfo, min, max);
        return true;
    }

    public String[] unparse(LoadContext context, KitTable kitTable) {
        StringBuilder sb = new StringBuilder();
        List list = kitTable.getList();
        if (list.isEmpty()) {
            return null;
        }
        boolean first = true;
        for (KitTable.TableEntry rl : list) {
            Collection unparse;
            if (!first) {
                sb.append("|");
            }
            if ((unparse = context.unparse((Object)rl.gear)).size() == 1) {
                sb.append((String)unparse.iterator().next());
            } else {
                for (String s : unparse) {
                    sb.append('[');
                    sb.append(s);
                    sb.append(']');
                }
            }
            sb.append("|");
            sb.append(rl.lowRange.toString());
            if (!rl.lowRange.equals(rl.highRange)) {
                sb.append(',');
                sb.append(rl.highRange.toString());
            }
            first = false;
        }
        return new String[]{sb.toString()};
    }
}

