/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import org.lobobrowser.html.domimpl.DescendentHTMLCollection;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableCellElement;
import org.w3c.dom.html2.HTMLTableRowElement;

public class HTMLTableRowElementImpl
extends HTMLElementImpl
implements HTMLTableRowElement {
    public HTMLTableRowElementImpl(String name) {
        super(name, true);
    }

    public HTMLTableRowElementImpl() {
        super("TR", true);
    }

    public int getRowIndex() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        if (parent == null) {
            return -1;
        }
        try {
            parent.visit(new NodeVisitor(){
                private int count = 0;

                public void visit(Node node) {
                    if (node instanceof HTMLTableRowElementImpl) {
                        if (HTMLTableRowElementImpl.this == node) {
                            throw new StopVisitorException(new Integer(this.count));
                        }
                        ++this.count;
                    }
                }
            });
        }
        catch (StopVisitorException sve) {
            return (Integer)sve.getTag();
        }
        return -1;
    }

    public int getSectionRowIndex() {
        return 0;
    }

    public HTMLCollection getCells() {
        NodeFilter filter = new NodeFilter(){

            public boolean accept(Node node) {
                return node instanceof HTMLTableCellElementImpl;
            }
        };
        return new DescendentHTMLCollection(this, filter, this.treeLock, false);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public String getCh() {
        return this.getAttribute("ch");
    }

    public void setCh(String ch) {
        this.setAttribute("ch", ch);
    }

    public String getChOff() {
        return this.getAttribute("choff");
    }

    public void setChOff(String chOff) {
        this.setAttribute("choff", chOff);
    }

    public String getVAlign() {
        return this.getAttribute("valign");
    }

    public void setVAlign(String vAlign) {
        this.setAttribute("valign", vAlign);
    }

    public HTMLElement insertHeader(int index) throws DOMException {
        return this.insertCell(index, "TH");
    }

    public HTMLElement insertCell(int index) throws DOMException {
        return this.insertCell(index, "TD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTMLElement insertCell(int index, String tagName) throws DOMException {
        Document doc = this.document;
        if (doc == null) {
            throw new DOMException(4, "Orphan element");
        }
        HTMLElement cellElement = (HTMLElement)doc.createElement(tagName);
        Object object = this.treeLock;
        synchronized (object) {
            if (index == -1) {
                this.appendChild(cellElement);
                return cellElement;
            }
            ArrayList nl = this.nodeList;
            if (nl != null) {
                int size = nl.size();
                int trcount = 0;
                for (int i = 0; i < size; ++i) {
                    Node node = (Node)nl.get(i);
                    if (!(node instanceof HTMLTableCellElement)) continue;
                    if (trcount == index) {
                        this.insertAt(cellElement, i);
                        return cellElement;
                    }
                    ++trcount;
                }
            } else {
                this.appendChild(cellElement);
                return cellElement;
            }
        }
        throw new DOMException(1, "Index out of range");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCell(int index) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                int size = nl.size();
                int trcount = 0;
                for (int i = 0; i < size; ++i) {
                    Node node = (Node)nl.get(i);
                    if (!(node instanceof HTMLTableCellElement)) continue;
                    if (trcount == index) {
                        this.removeChildAt(index);
                    }
                    ++trcount;
                }
            }
        }
        throw new DOMException(1, "Index out of range");
    }
}

