/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.util.gui.ColorFactory;

public class BodyRenderState
extends StyleSheetRenderState {
    public BodyRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element);
    }

    public void invalidate() {
        super.invalidate();
    }

    public BackgroundInfo getBackgroundInfo() {
        String bgcolor;
        BackgroundInfo binfo = this.iBackgroundInfo;
        if (binfo != INVALID_BACKGROUND_INFO) {
            return binfo;
        }
        binfo = super.getBackgroundInfo();
        if ((binfo == null || binfo.backgroundColor == null) && (bgcolor = this.element.getAttribute("bgcolor")) != null && bgcolor.length() != 0) {
            if (binfo == null) {
                binfo = new BackgroundInfo();
            }
            binfo.backgroundColor = ColorFactory.getInstance().getColor(bgcolor);
        }
        this.iBackgroundInfo = binfo;
        return binfo;
    }

    public HtmlInsets getMarginInsets() {
        HtmlInsets insets = this.marginInsets;
        if (insets != INVALID_INSETS) {
            return insets;
        }
        insets = super.getMarginInsets();
        if (insets == null) {
            HTMLElementImpl element = this.element;
            String leftMargin = element.getAttribute("leftmargin");
            String rightMargin = element.getAttribute("rightmargin");
            String bottomMargin = element.getAttribute("rightmargin");
            String topMargin = element.getAttribute("topmargin");
            String marginWidth = element.getAttribute("marginwidth");
            String marginHeight = element.getAttribute("marginheight");
            if (leftMargin == null) {
                leftMargin = marginWidth;
            }
            if (rightMargin == null) {
                rightMargin = marginWidth;
            }
            if (topMargin == null) {
                topMargin = marginHeight;
            }
            if (bottomMargin == null) {
                bottomMargin = marginHeight;
            }
            if (leftMargin != null) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                insets.left = HtmlValues.getOldSyntaxPixelSizeSimple(leftMargin, 0);
                insets.leftType = 1;
            }
            if (rightMargin != null) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                insets.right = HtmlValues.getOldSyntaxPixelSizeSimple(rightMargin, 0);
                insets.rightType = 1;
            }
            if (topMargin != null) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                insets.top = HtmlValues.getOldSyntaxPixelSizeSimple(topMargin, 0);
                insets.topType = 1;
            }
            if (bottomMargin != null) {
                if (insets == null) {
                    insets = new HtmlInsets();
                }
                insets.bottom = HtmlValues.getOldSyntaxPixelSizeSimple(bottomMargin, 0);
                insets.bottomType = 1;
            }
        }
        this.marginInsets = insets;
        return insets;
    }
}

