/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import pcgen.facade.core.ChooserFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.FontManipulation;
import pcgen.system.LanguageBundle;

public class RadioChooserDialog
extends JDialog
implements ActionListener {
    private final ChooserFacade chooser;
    private boolean committed;
    private ButtonGroup avaGroup = null;
    private JRadioButton[] avaRadioButton = null;
    private JPanel buttonPanel;
    private JRadioButton selectedButton;

    public RadioChooserDialog(Frame frame, ChooserFacade chooser) {
        super(frame, true);
        this.chooser = chooser;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.setTitle(LanguageBundle.getString("in_chooserSelectOne"));
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JLabel titleLabel = new JLabel(this.chooser.getName());
        FontManipulation.title(titleLabel);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        pane.add((Component)titleLabel, "North");
        this.buildButtonPanel();
        pane.add((Component)this.buttonPanel, "Center");
        JPanel bottomPane = new JPanel(new FlowLayout());
        JButton button = new JButton(LanguageBundle.getString("in_ok"));
        button.setMnemonic(LanguageBundle.getMnemonic("in_mn_ok"));
        button.setActionCommand("OK");
        button.addActionListener(this);
        bottomPane.add(button);
        button = new JButton(LanguageBundle.getString("in_cancel"));
        button.setMnemonic(LanguageBundle.getMnemonic("in_mn_cancel"));
        button.setActionCommand("CANCEL");
        button.addActionListener(this);
        bottomPane.add(button);
        pane.add((Component)bottomPane, "South");
    }

    private void buildButtonPanel() {
        ListFacade<InfoFacade> availableList = this.chooser.getAvailableList();
        int row = 0;
        this.avaRadioButton = new JRadioButton[availableList.getSize()];
        this.avaGroup = new ButtonGroup();
        for (InfoFacade infoFacade : availableList) {
            this.avaRadioButton[row] = new JRadioButton(infoFacade.toString(), false);
            this.avaGroup.add(this.avaRadioButton[row]);
            this.avaRadioButton[row].addActionListener(this);
            ++row;
        }
        int numRows = row;
        if (numRows > 0) {
            this.avaRadioButton[0].setSelected(true);
            this.selectedButton = this.avaRadioButton[0];
        }
        GridBagLayout gridbag = new GridBagLayout();
        this.buttonPanel = new JPanel();
        TitledBorder title = BorderFactory.createTitledBorder(null, "");
        this.buttonPanel.setBorder(title);
        this.buttonPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        if (numRows > 11) {
            this.buildTwoColLayout(numRows, c, gridbag);
        } else {
            for (int i = 0; i < numRows; ++i) {
                int cr = i;
                c.anchor = 17;
                Utility.buildConstraints(c, 0, cr, 2, 1, 1.0, 0.0);
                gridbag.setConstraints(this.avaRadioButton[i], c);
                this.buttonPanel.add(this.avaRadioButton[i]);
            }
        }
    }

    private void buildTwoColLayout(int numButtons, GridBagConstraints c, GridBagLayout gridbag) {
        int numRows = numButtons - numButtons / 2;
        for (int i = 0; i < numRows; ++i) {
            int cr = i;
            c.anchor = 17;
            Utility.buildConstraints(c, 0, cr, 2, 1, 1.0, 0.0);
            gridbag.setConstraints(this.avaRadioButton[i], c);
            this.buttonPanel.add(this.avaRadioButton[i]);
            if (i + numRows >= numButtons) continue;
            c.anchor = 13;
            Utility.buildConstraints(c, 3, cr, 2, 1, 1.0, 0.0);
            gridbag.setConstraints(this.avaRadioButton[i + numRows], c);
            this.buttonPanel.add(this.avaRadioButton[i + numRows]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JRadioButton) {
            this.selectedButton = (JRadioButton)e.getSource();
            return;
        }
        if (e.getActionCommand().equals("OK")) {
            for (int i = 0; i < this.avaRadioButton.length; ++i) {
                if (this.selectedButton != this.avaRadioButton[i]) continue;
                this.chooser.addSelected(this.chooser.getAvailableList().getElementAt(i));
                break;
            }
            if (this.chooser.isRequireCompleteSelection() && this.chooser.getRemainingSelections().getReference() > 0) {
                JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_chooserRequireComplete", this.chooser.getRemainingSelections().getReference()), this.chooser.getName(), 1);
                return;
            }
            this.chooser.commit();
        } else {
            this.chooser.rollback();
        }
        this.committed = e.getActionCommand().equals("OK");
        this.dispose();
    }

    public boolean isCommitted() {
        return this.committed;
    }
}

