/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class AbilityTreeViews {
    public static List<TreeView<AbilityFacade>> createTreeViewList(CharacterFacade character) {
        ArrayList<TreeView<AbilityFacade>> list = new ArrayList<TreeView<AbilityFacade>>();
        list.add(new NameTreeView());
        list.add(new TypeTreeView());
        list.add(new PreReqTreeView(character.getDataSet()));
        list.add(new SourceTreeView());
        return list;
    }

    private static class PreReqTreeView
    implements TreeView<AbilityFacade> {
        private DataSetFacade dataset;

        public PreReqTreeView(DataSetFacade dataset) {
            this.dataset = dataset;
        }

        @Override
        public String getViewName() {
            return LanguageBundle.getString("in_preReqTree");
        }

        @Override
        public List<TreeViewPath<AbilityFacade>> getPaths(AbilityFacade pobj) {
            ArrayList<List<AbilityFacade>> abilityPaths = new ArrayList<List<AbilityFacade>>();
            this.addPaths(abilityPaths, this.dataset.getPrereqAbilities(pobj), new ArrayList<AbilityFacade>());
            if (abilityPaths.isEmpty()) {
                return Collections.singletonList(new TreeViewPath<AbilityFacade>(pobj));
            }
            ArrayList<TreeViewPath<AbilityFacade>> paths = new ArrayList<TreeViewPath<AbilityFacade>>();
            for (List list : abilityPaths) {
                Collections.reverse(list);
                paths.add(new TreeViewPath<AbilityFacade>(list.toArray(), pobj));
            }
            return paths;
        }

        private void addPaths(List<List<AbilityFacade>> abilityPaths, List<AbilityFacade> preAbilities, ArrayList<AbilityFacade> path) {
            if (path.size() > 20) {
                Logging.errorPrint("Found probable ability prereq cycle [" + StringUtils.join(path, ",") + "] with prereqs [" + StringUtils.join(preAbilities, ",") + "]. Skipping.");
                return;
            }
            for (AbilityFacade preAbility : preAbilities) {
                ArrayList pathclone = (ArrayList)path.clone();
                pathclone.add(preAbility);
                List<AbilityFacade> preAbilities2 = this.dataset.getPrereqAbilities(preAbility);
                preAbilities2.remove(preAbility);
                preAbilities2.removeAll(pathclone);
                if (preAbilities2.isEmpty()) {
                    abilityPaths.add(pathclone);
                    continue;
                }
                this.addPaths(abilityPaths, preAbilities2, pathclone);
            }
        }
    }

    private static class SourceTreeView
    implements TreeView<AbilityFacade> {
        private SourceTreeView() {
        }

        @Override
        public String getViewName() {
            return LanguageBundle.getString("in_sourceName");
        }

        @Override
        public List<TreeViewPath<AbilityFacade>> getPaths(AbilityFacade pobj) {
            return Collections.singletonList(new TreeViewPath<AbilityFacade>(pobj, (Object)pobj.getSourceForNodeDisplay()));
        }
    }

    private static class TypeTreeView
    implements TreeView<AbilityFacade> {
        private TypeTreeView() {
        }

        @Override
        public String getViewName() {
            return LanguageBundle.getString("in_typeName");
        }

        @Override
        public List<TreeViewPath<AbilityFacade>> getPaths(AbilityFacade pobj) {
            ArrayList<TreeViewPath<AbilityFacade>> list = new ArrayList<TreeViewPath<AbilityFacade>>();
            List<String> types = pobj.getTypes();
            if (types.isEmpty()) {
                list.add(new TreeViewPath<AbilityFacade>(pobj));
            } else {
                for (String type : types) {
                    list.add(new TreeViewPath<AbilityFacade>(pobj, (Object)type));
                }
            }
            return list;
        }
    }

    private static class NameTreeView
    implements TreeView<AbilityFacade> {
        private NameTreeView() {
        }

        @Override
        public String getViewName() {
            return LanguageBundle.getString("in_nameLabel");
        }

        @Override
        public List<TreeViewPath<AbilityFacade>> getPaths(AbilityFacade pobj) {
            return Collections.singletonList(new TreeViewPath<AbilityFacade>(pobj));
        }
    }
}

