/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.choose;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.UserChooseInformation;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class UserInputToken
implements CDOMSecondaryToken<CDOMObject> {
    @Override
    public String getTokenName() {
        return "USERINPUT";
    }

    @Override
    public String getParentToken() {
        return "CHOOSE";
    }

    @Override
    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        UserChooseInformation ci = new UserChooseInformation();
        if (value != null) {
            String titleString;
            int pipeLoc = value.indexOf(124);
            if (pipeLoc == -1) {
                titleString = value;
            } else {
                int firstarg;
                String countString = value.substring(0, pipeLoc);
                Logging.deprecationPrint("CHOOSE:USERINPUT with count is deprecated, please use SELECT: to identify the quantity of selections", context);
                try {
                    firstarg = Integer.parseInt(countString);
                }
                catch (NumberFormatException nfe) {
                    return new ParseResult.Fail("If CHOOSE:" + this.getTokenName() + " contains a pipe, " + "first argument must be an Integer : " + value, context);
                }
                Formula count = FormulaFactory.getFormulaFor(firstarg);
                context.getObjectContext().put(obj, FormulaKey.NUMCHOICES, count);
                context.getObjectContext().put(obj, FormulaKey.SELECT, count);
                titleString = value.substring(pipeLoc + 1);
            }
            if (!titleString.startsWith("TITLE=")) {
                return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " in " + obj.getClass() + " " + obj.getKeyName() + " had invalid arguments: " + value, context);
            }
            String title = titleString.substring(6);
            if (title.startsWith("\"")) {
                title = title.substring(1, title.length() - 1);
            }
            ci.setTitle(title);
        } else {
            ci.setTitle(this.getDefaultTitle());
        }
        context.getObjectContext().put(obj, ObjectKey.CHOOSE_INFO, ci);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject cdo) {
        ChooseInformation<?> ci = context.getObjectContext().getObject(cdo, ObjectKey.CHOOSE_INFO);
        if (ci == null || !ci.getName().equals("User Input")) {
            return null;
        }
        String title = ci.getTitle();
        String result = "";
        if (!title.equals(this.getDefaultTitle())) {
            result = "TITLE=" + title;
        }
        return new String[]{result};
    }

    private String getDefaultTitle() {
        return "Provide User Input";
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

