/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.deprecated;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.BasicChooseInformation;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.choiceset.CollectionToAbilitySelection;
import pcgen.cdom.content.AbilitySelection;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class ChooseFeatSelectionToken
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
Chooser<AbilitySelection> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    @Override
    public String getParentToken() {
        return "CHOOSE";
    }

    @Override
    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, ReferenceManufacturer<Ability> rm, CDOMObject obj, String value) {
        String title;
        String activeValue;
        int pipeLoc = value.lastIndexOf(124);
        if (pipeLoc == -1) {
            activeValue = value;
            title = this.getDefaultTitle();
        } else {
            String titleString = value.substring(pipeLoc + 1);
            if (titleString.startsWith("TITLE=")) {
                title = titleString.substring(6);
                if (title.startsWith("\"")) {
                    title = title.substring(1, title.length() - 1);
                }
                if (title == null || title.length() == 0) {
                    return new ParseResult.Fail(this.getParentToken() + ":" + this.getTokenName() + " had TITLE= but no title: " + value, context);
                }
                activeValue = value.substring(0, pipeLoc);
            } else {
                activeValue = value;
                title = this.getDefaultTitle();
            }
        }
        PrimitiveCollection<Ability> prim = context.getChoiceSet(rm, activeValue);
        if (prim == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        if (!prim.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        CollectionToAbilitySelection pcs = new CollectionToAbilitySelection(CDOMDirectSingleRef.getRef(AbilityCategory.FEAT), prim);
        BasicChooseInformation<AbilitySelection> tc = new BasicChooseInformation<AbilitySelection>("ABILITYSELECTION", pcs);
        tc.setTitle(title);
        tc.setChoiceActor(this);
        context.getObjectContext().put(obj, ObjectKey.CHOOSE_INFO, tc);
        return ParseResult.SUCCESS;
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject cdo) {
        return null;
    }

    @Override
    public void applyChoice(ChooseDriver owner, AbilitySelection st, PlayerCharacter pc) {
        this.restoreChoice(pc, owner, st);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, AbilitySelection choice) {
        pc.removeAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<?> ca : actors) {
                ca.removeChoice(owner, choice, pc);
            }
        }
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, AbilitySelection choice) {
        pc.addAssoc(owner, this.getListKey(), choice);
        List<ChooseSelectionActor<?>> actors = owner.getActors();
        if (actors != null) {
            for (ChooseSelectionActor<?> ca : actors) {
                ca.applyChoice(owner, choice, pc);
            }
        }
    }

    @Override
    public List<AbilitySelection> getCurrentlySelected(ChooseDriver owner, PlayerCharacter pc) {
        return pc.getAssocList(owner, this.getListKey());
    }

    @Override
    public boolean allow(AbilitySelection choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    @Override
    public String getTokenName() {
        return "FEATSELECTION";
    }

    @Override
    public ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        return this.parseTokenWithSeparator(context, context.getReferenceContext().getManufacturer(ABILITY_CLASS, AbilityCategory.FEAT), obj, value);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    protected String getDefaultTitle() {
        return "Ability choice";
    }

    protected AssociationListKey<AbilitySelection> getListKey() {
        return AssociationListKey.getKeyFor(AbilitySelection.class, "CHOOSE*FEATSELECTION");
    }

    @Override
    public AbilitySelection decodeChoice(LoadContext context, String s) {
        Ability ability = context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, s);
        if (ability == null) {
            ArrayList<String> choices = new ArrayList<String>();
            String baseKey = AbilityUtilities.getUndecoratedName(s, choices);
            ability = context.getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, baseKey);
            if (ability == null) {
                throw new IllegalArgumentException("String in decodeChoice must be a Feat Key (or Feat Key with Selection if appropriate), was: " + s);
            }
            return new AbilitySelection(ability, (String)choices.get(0));
        }
        if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            return new AbilitySelection(ability, "");
        }
        return new AbilitySelection(ability, null);
    }

    @Override
    public String encodeChoice(AbilitySelection choice) {
        Ability ability = (Ability)choice.getObject();
        StringBuilder sb = new StringBuilder(50);
        sb.append(ability.getKeyName());
        String selection = (String)choice.getSelection();
        if (selection != null && selection.length() > 0) {
            sb.append(" (");
            sb.append(selection);
            sb.append(')');
        }
        return sb.toString();
    }
}

