/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.statsandchecks.bonusspell;

import pcgen.cdom.content.BonusSpellInfo;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class StatrangeToken
implements CDOMPrimaryToken<BonusSpellInfo> {
    @Override
    public String getTokenName() {
        return "STATRANGE";
    }

    @Override
    public Class<BonusSpellInfo> getTokenClass() {
        return BonusSpellInfo.class;
    }

    @Override
    public ParseResult parseToken(LoadContext context, BonusSpellInfo bsi, String value) {
        try {
            int intValue = Integer.valueOf(value);
            if (intValue < 1) {
                return new ParseResult.Fail(this.getTokenName() + " must be an integer >= " + 1, context);
            }
            bsi.setStatRange(intValue);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>", context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, BonusSpellInfo bsi) {
        int range = bsi.getStatRange();
        if (range == 0) {
            return null;
        }
        return new String[]{String.valueOf(range)};
    }
}

