/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteListParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreDeityParser
extends AbstractPrerequisiteListParser
implements PrerequisiteParserInterface {
    @Override
    public String[] kindsHandled() {
        return new String[]{"DEITY"};
    }

    @Override
    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        this.replaceHasDeityPrereqs(prereq);
        return prereq;
    }

    private void replaceHasDeityPrereqs(Prerequisite prereq) {
        String key = prereq.getKey();
        if ("deity".equalsIgnoreCase(prereq.getKind()) && key != null) {
            char firstChar = key.charAt(0);
            if (key.length() == 1 && (firstChar == 'y' || firstChar == 'Y' || firstChar == 'n' || firstChar == 'N') || key.equalsIgnoreCase("yes") || key.equalsIgnoreCase("no")) {
                if (firstChar == 'y' || firstChar == 'Y') {
                    prereq.setKey("Y");
                } else {
                    prereq.setKey("N");
                }
                prereq.setKind("has.deity");
            }
        }
        for (Prerequisite subprereq : prereq.getPrerequisites()) {
            this.replaceHasDeityPrereqs(subprereq);
        }
    }
}

