/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.producer;

import java.io.StringWriter;
import java.math.BigInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import weka.classifiers.pmml.producer.AbstractPMMLProducerHelper;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.pmml.jaxbbindings.DATATYPE;
import weka.core.pmml.jaxbbindings.DerivedField;
import weka.core.pmml.jaxbbindings.FIELDUSAGETYPE;
import weka.core.pmml.jaxbbindings.LocalTransformations;
import weka.core.pmml.jaxbbindings.MININGFUNCTION;
import weka.core.pmml.jaxbbindings.MISSINGVALUETREATMENTMETHOD;
import weka.core.pmml.jaxbbindings.MiningField;
import weka.core.pmml.jaxbbindings.MiningSchema;
import weka.core.pmml.jaxbbindings.NormDiscrete;
import weka.core.pmml.jaxbbindings.NumericPredictor;
import weka.core.pmml.jaxbbindings.OPTYPE;
import weka.core.pmml.jaxbbindings.Output;
import weka.core.pmml.jaxbbindings.OutputField;
import weka.core.pmml.jaxbbindings.PMML;
import weka.core.pmml.jaxbbindings.REGRESSIONNORMALIZATIONMETHOD;
import weka.core.pmml.jaxbbindings.RegressionModel;
import weka.core.pmml.jaxbbindings.RegressionTable;
import weka.core.pmml.jaxbbindings.TransformationDictionary;

public class LogisticProducerHelper
extends AbstractPMMLProducerHelper {
    public static String toPMML(Instances train, Instances structureAfterFiltering, double[][] par, int numClasses) {
        int i;
        PMML pmml = LogisticProducerHelper.initPMML();
        LogisticProducerHelper.addDataDictionary(train, pmml);
        String currentAttrName = null;
        TransformationDictionary transformDict = null;
        LocalTransformations localTransforms = null;
        MiningSchema schema = new MiningSchema();
        for (int i2 = 0; i2 < structureAfterFiltering.numAttributes(); ++i2) {
            Attribute attr = structureAfterFiltering.attribute(i2);
            Attribute originalAttr = train.attribute(attr.name());
            if (i2 == structureAfterFiltering.classIndex()) {
                schema.addMiningFields(new MiningField(attr.name(), FIELDUSAGETYPE.PREDICTED));
            }
            if (originalAttr == null) {
                String[] nameAndValue;
                if (localTransforms == null) {
                    localTransforms = new LocalTransformations();
                }
                if (transformDict == null) {
                    transformDict = new TransformationDictionary();
                }
                if (!(nameAndValue = LogisticProducerHelper.getNameAndValueFromUnsupervisedNominalToBinaryDerivedAttribute(train, attr))[0].equals(currentAttrName)) {
                    currentAttrName = nameAndValue[0];
                    if (i2 != structureAfterFiltering.classIndex()) {
                        int mode = (int)train.meanOrMode(train.attribute(nameAndValue[0]));
                        schema.addMiningFields(new MiningField(nameAndValue[0], FIELDUSAGETYPE.ACTIVE, MISSINGVALUETREATMENTMETHOD.AS_MODE, train.attribute(nameAndValue[0]).value(mode)));
                    }
                }
                DerivedField derivedfield = new DerivedField(attr.name(), DATATYPE.DOUBLE, OPTYPE.CONTINUOUS);
                NormDiscrete normDiscrete = new NormDiscrete(nameAndValue[0], nameAndValue[1]);
                derivedfield.setNormDiscrete(normDiscrete);
                transformDict.addDerivedField(derivedfield);
                continue;
            }
            if (i2 == structureAfterFiltering.classIndex()) continue;
            if (originalAttr.isNumeric()) {
                String mean = "" + train.meanOrMode(originalAttr);
                schema.addMiningFields(new MiningField(originalAttr.name(), FIELDUSAGETYPE.ACTIVE, MISSINGVALUETREATMENTMETHOD.AS_MEAN, mean));
                continue;
            }
            int mode = (int)train.meanOrMode(originalAttr);
            schema.addMiningFields(new MiningField(originalAttr.name(), FIELDUSAGETYPE.ACTIVE, MISSINGVALUETREATMENTMETHOD.AS_MODE, originalAttr.value(mode)));
        }
        RegressionModel model = new RegressionModel();
        if (transformDict != null) {
            pmml.setTransformationDictionary(transformDict);
        }
        model.addContent(schema);
        model.setFunctionName(MININGFUNCTION.CLASSIFICATION);
        model.setAlgorithmName("logisticRegression");
        model.setModelType("logisticRegression");
        model.setNormalizationMethod(REGRESSIONNORMALIZATIONMETHOD.SOFTMAX);
        Output output = new Output();
        Attribute classAttribute = structureAfterFiltering.classAttribute();
        for (i = 0; i < classAttribute.numValues(); ++i) {
            OutputField outputField = new OutputField();
            outputField.setName(classAttribute.name());
            outputField.setValue(classAttribute.value(i));
            output.addOutputField(outputField);
        }
        model.addContent(output);
        for (i = 0; i < numClasses - 1; ++i) {
            RegressionTable table = new RegressionTable(structureAfterFiltering.classAttribute().value(i));
            int j = 1;
            for (int k = 0; k < structureAfterFiltering.numAttributes(); ++k) {
                if (k == structureAfterFiltering.classIndex()) continue;
                Attribute attr = structureAfterFiltering.attribute(k);
                table.addNumericPredictor(new NumericPredictor(attr.name(), BigInteger.valueOf(1L), par[j][i]));
                ++j;
            }
            table.setIntercept(par[0][i]);
            model.addContent(table);
        }
        pmml.addAssociationModelOrBaselineModelOrClusteringModes(model);
        try {
            StringWriter sw = new StringWriter();
            JAXBContext jc = JAXBContext.newInstance(PMML.class);
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", true);
            marshaller.marshal((Object)pmml, sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return "";
        }
    }
}

