/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.AbstractDensityBasedClusterer;
import weka.clusterers.Clusterer;
import weka.clusterers.NumberOfClustersRequestable;
import weka.clusterers.SimpleKMeans;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.DiscreteEstimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class MakeDensityBasedClusterer
extends AbstractDensityBasedClusterer
implements NumberOfClustersRequestable,
OptionHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -5643302427972186631L;
    private Instances m_theInstances;
    private double[] m_priors;
    private double[][][] m_modelNormal;
    private DiscreteEstimator[][] m_model;
    private double m_minStdDev = 1.0E-6;
    private Clusterer m_wrappedClusterer = new SimpleKMeans();
    private ReplaceMissingValues m_replaceMissing;
    private static double m_normConst = 0.5 * Math.log(Math.PI * 2);

    public MakeDensityBasedClusterer() {
    }

    public MakeDensityBasedClusterer(Clusterer toWrap) {
        this.setClusterer(toWrap);
    }

    public String globalInfo() {
        return "Class for wrapping a Clusterer to make it return a distribution and density. Fits normal distributions and discrete distributions within each cluster produced by the wrapped clusterer. Supports the NumberOfClustersRequestable interface only if the wrapped Clusterer does.";
    }

    protected String defaultClustererString() {
        return SimpleKMeans.class.getName();
    }

    @Override
    public void setNumClusters(int n) throws Exception {
        if (this.m_wrappedClusterer == null) {
            throw new Exception("Can't set the number of clusters to generate - no clusterer has been set yet.");
        }
        if (!(this.m_wrappedClusterer instanceof NumberOfClustersRequestable)) {
            throw new Exception("Can't set the number of clusters to generate - wrapped clusterer does not support this facility.");
        }
        ((NumberOfClustersRequestable)((Object)this.m_wrappedClusterer)).setNumClusters(n);
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.m_wrappedClusterer != null) {
            return this.m_wrappedClusterer.getCapabilities();
        }
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildClusterer(Instances data) throws Exception {
        int i;
        int j;
        int i2;
        this.getCapabilities().testWithFail(data);
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_replaceMissing.setInputFormat(data);
        data = Filter.useFilter(data, this.m_replaceMissing);
        this.m_theInstances = new Instances(data, 0);
        if (this.m_wrappedClusterer == null) {
            throw new Exception("No clusterer has been set");
        }
        this.m_wrappedClusterer.buildClusterer(data);
        this.m_model = new DiscreteEstimator[this.m_wrappedClusterer.numberOfClusters()][data.numAttributes()];
        this.m_modelNormal = new double[this.m_wrappedClusterer.numberOfClusters()][data.numAttributes()][2];
        double[][] weights = new double[this.m_wrappedClusterer.numberOfClusters()][data.numAttributes()];
        this.m_priors = new double[this.m_wrappedClusterer.numberOfClusters()];
        for (int i3 = 0; i3 < this.m_wrappedClusterer.numberOfClusters(); ++i3) {
            this.m_priors[i3] = 1.0;
            for (int j2 = 0; j2 < data.numAttributes(); ++j2) {
                if (!data.attribute(j2).isNominal()) continue;
                this.m_model[i3][j2] = new DiscreteEstimator(data.attribute(j2).numValues(), true);
            }
        }
        Instance inst = null;
        int[] clusterIndex = new int[data.numInstances()];
        for (i2 = 0; i2 < data.numInstances(); ++i2) {
            int cluster;
            inst = data.instance(i2);
            int n = cluster = this.m_wrappedClusterer.clusterInstance(inst);
            this.m_priors[n] = this.m_priors[n] + inst.weight();
            for (int j3 = 0; j3 < data.numAttributes(); ++j3) {
                if (inst.isMissing(j3)) continue;
                if (data.attribute(j3).isNominal()) {
                    this.m_model[cluster][j3].addValue(inst.value(j3), inst.weight());
                    continue;
                }
                double[] dArray = this.m_modelNormal[cluster][j3];
                dArray[0] = dArray[0] + inst.weight() * inst.value(j3);
                double[] dArray2 = weights[cluster];
                int n2 = j3;
                dArray2[n2] = dArray2[n2] + inst.weight();
            }
            clusterIndex[i2] = cluster;
        }
        for (j = 0; j < data.numAttributes(); ++j) {
            if (!data.attribute(j).isNumeric()) continue;
            for (i = 0; i < this.m_wrappedClusterer.numberOfClusters(); ++i) {
                if (!(weights[i][j] > 0.0)) continue;
                double[] dArray = this.m_modelNormal[i][j];
                dArray[0] = dArray[0] / weights[i][j];
            }
        }
        for (i2 = 0; i2 < data.numInstances(); ++i2) {
            inst = data.instance(i2);
            for (int j4 = 0; j4 < data.numAttributes(); ++j4) {
                if (inst.isMissing(j4) || !data.attribute(j4).isNumeric()) continue;
                double diff = this.m_modelNormal[clusterIndex[i2]][j4][0] - inst.value(j4);
                double[] dArray = this.m_modelNormal[clusterIndex[i2]][j4];
                dArray[1] = dArray[1] + inst.weight() * diff * diff;
            }
        }
        for (j = 0; j < data.numAttributes(); ++j) {
            if (!data.attribute(j).isNumeric()) continue;
            for (i = 0; i < this.m_wrappedClusterer.numberOfClusters(); ++i) {
                if (weights[i][j] > 0.0) {
                    this.m_modelNormal[i][j][1] = Math.sqrt(this.m_modelNormal[i][j][1] / weights[i][j]);
                } else if (weights[i][j] <= 0.0) {
                    this.m_modelNormal[i][j][1] = Double.MAX_VALUE;
                }
                if (!(this.m_modelNormal[i][j][1] <= this.m_minStdDev)) continue;
                this.m_modelNormal[i][j][1] = data.attributeStats((int)j).numericStats.stdDev;
                if (!(this.m_modelNormal[i][j][1] <= this.m_minStdDev)) continue;
                this.m_modelNormal[i][j][1] = this.m_minStdDev;
            }
        }
        Utils.normalize(this.m_priors);
    }

    @Override
    public double[] clusterPriors() {
        double[] n = new double[this.m_priors.length];
        System.arraycopy(this.m_priors, 0, n, 0, n.length);
        return n;
    }

    @Override
    public double[] logDensityPerClusterForInstance(Instance inst) throws Exception {
        double[] wghts = new double[this.m_wrappedClusterer.numberOfClusters()];
        this.m_replaceMissing.input(inst);
        inst = this.m_replaceMissing.output();
        for (int i = 0; i < this.m_wrappedClusterer.numberOfClusters(); ++i) {
            double logprob = 0.0;
            for (int j = 0; j < inst.numAttributes(); ++j) {
                if (inst.isMissing(j)) continue;
                if (inst.attribute(j).isNominal()) {
                    logprob += Math.log(this.m_model[i][j].getProbability(inst.value(j)));
                    continue;
                }
                logprob += this.logNormalDens(inst.value(j), this.m_modelNormal[i][j][0], this.m_modelNormal[i][j][1]);
            }
            wghts[i] = logprob;
        }
        return wghts;
    }

    private double logNormalDens(double x, double mean, double stdDev) {
        double diff = x - mean;
        return -(diff * diff / (2.0 * stdDev * stdDev)) - m_normConst - Math.log(stdDev);
    }

    @Override
    public int numberOfClusters() throws Exception {
        return this.m_wrappedClusterer.numberOfClusters();
    }

    public String toString() {
        if (this.m_priors == null) {
            return "No clusterer built yet!";
        }
        StringBuffer text = new StringBuffer();
        text.append("MakeDensityBasedClusterer: \n\nWrapped clusterer: " + this.m_wrappedClusterer.toString());
        text.append("\nFitted estimators (with ML estimates of variance):\n");
        for (int j = 0; j < this.m_priors.length; ++j) {
            text.append("\nCluster: " + j + " Prior probability: " + Utils.doubleToString(this.m_priors[j], 4) + "\n\n");
            for (int i = 0; i < this.m_model[0].length; ++i) {
                text.append("Attribute: " + this.m_theInstances.attribute(i).name() + "\n");
                if (this.m_theInstances.attribute(i).isNominal()) {
                    if (this.m_model[j][i] == null) continue;
                    text.append(this.m_model[j][i].toString());
                    continue;
                }
                text.append("Normal Distribution. Mean = " + Utils.doubleToString(this.m_modelNormal[j][i][0], 4) + " StdDev = " + Utils.doubleToString(this.m_modelNormal[j][i][1], 4) + "\n");
            }
        }
        return text.toString();
    }

    public String clustererTipText() {
        return "the clusterer to wrap";
    }

    public void setClusterer(Clusterer toWrap) {
        this.m_wrappedClusterer = toWrap;
    }

    public Clusterer getClusterer() {
        return this.m_wrappedClusterer;
    }

    public String minStdDevTipText() {
        return "set minimum allowable standard deviation";
    }

    public void setMinStdDev(double m) {
        this.m_minStdDev = m;
    }

    public double getMinStdDev() {
        return this.m_minStdDev;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tminimum allowable standard deviation for normal density computation \n\t(default 1e-6)", "M", 1, "-M <num>"));
        result.addElement(new Option("\tClusterer to wrap.\n\t(default " + this.defaultClustererString() + ")", "W", 1, "-W <clusterer name>"));
        result.addAll(Collections.list(super.listOptions()));
        if (this.m_wrappedClusterer != null && this.m_wrappedClusterer instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_wrappedClusterer.getClass().getName() + ":"));
            result.addAll(Collections.list(((OptionHandler)((Object)this.m_wrappedClusterer)).listOptions()));
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('M', options);
        if (optionString.length() != 0) {
            this.setMinStdDev(new Double(optionString));
        } else {
            this.setMinStdDev(1.0E-6);
        }
        String wString = Utils.getOption('W', options);
        if (wString.length() == 0) {
            wString = this.defaultClustererString();
        }
        this.setClusterer(AbstractClusterer.forName(wString, Utils.partitionOptions(options)));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-M");
        options.add("" + this.getMinStdDev());
        if (this.getClusterer() != null) {
            String[] clustererOptions;
            options.add("-W");
            options.add(this.getClusterer().getClass().getName());
            if (this.m_wrappedClusterer instanceof OptionHandler && (clustererOptions = ((OptionHandler)((Object)this.m_wrappedClusterer)).getOptions()).length > 0) {
                options.add("--");
                Collections.addAll(options, clustererOptions);
            }
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15520 $");
    }

    public static void main(String[] argv) {
        MakeDensityBasedClusterer.runClusterer(new MakeDensityBasedClusterer(), argv);
    }
}

