/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;

class TestNGTestClassDetector
extends TestClassVisitor {
    private static final Set<String> TEST_METHOD_ANNOTATIONS = ImmutableSet.builder().add((Object)"Lorg/testng/annotations/Test;").add((Object)"Lorg/testng/annotations/BeforeSuite;").add((Object)"Lorg/testng/annotations/AfterSuite;").add((Object)"Lorg/testng/annotations/BeforeTest;").add((Object)"Lorg/testng/annotations/AfterTest;").add((Object)"Lorg/testng/annotations/BeforeGroups;").add((Object)"Lorg/testng/annotations/AfterGroups;").add((Object)"Lorg/testng/annotations/Factory;").build();

    TestNGTestClassDetector(TestFrameworkDetector detector) {
        super(detector);
    }

    @Override
    protected boolean ignoreNonStaticInnerClass() {
        return false;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if ("Lorg/testng/annotations/Test;".equals(desc)) {
            this.setTest(true);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.isAbstract() && !this.isTest()) {
            return new TestNGTestMethodDetector();
        }
        return null;
    }

    private class TestNGTestMethodDetector
    extends MethodVisitor {
        private TestNGTestMethodDetector() {
            super(589824);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (TEST_METHOD_ANNOTATIONS.contains(desc)) {
                TestNGTestClassDetector.this.setTest(true);
            }
            return null;
        }
    }
}

