/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree.unboxed;

import com.sun.electric.database.geometry.btree.unboxed.UnboxedComparable;

public class UnboxedDouble
implements UnboxedComparable<Double> {
    public static final UnboxedDouble instance = new UnboxedDouble();

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public Double deserialize(byte[] buf, int ofs) {
        return new Double(this.deserializeDouble(buf, ofs));
    }

    @Override
    public void serialize(Double k, byte[] buf, int ofs) {
        this.serializeDouble(k, buf, ofs);
    }

    public Double deserializeDouble(byte[] buf, int ofs) {
        return Double.longBitsToDouble(((long)buf[ofs + 0] & 0xFFL) << 0 | ((long)buf[ofs + 1] & 0xFFL) << 8 | ((long)buf[ofs + 2] & 0xFFL) << 16 | ((long)buf[ofs + 3] & 0xFFL) << 24 | ((long)buf[ofs + 4] & 0xFFL) << 32 | ((long)buf[ofs + 5] & 0xFFL) << 40 | ((long)buf[ofs + 6] & 0xFFL) << 48 | ((long)buf[ofs + 7] & 0xFFL) << 56);
    }

    public void serializeDouble(double f, byte[] buf, int ofs) {
        long i = Double.doubleToRawLongBits(f);
        buf[ofs + 0] = (byte)(i >> 0 & 0xFFL);
        buf[ofs + 1] = (byte)(i >> 8 & 0xFFL);
        buf[ofs + 2] = (byte)(i >> 16 & 0xFFL);
        buf[ofs + 3] = (byte)(i >> 24 & 0xFFL);
        buf[ofs + 4] = (byte)(i >> 32 & 0xFFL);
        buf[ofs + 5] = (byte)(i >> 40 & 0xFFL);
        buf[ofs + 6] = (byte)(i >> 48 & 0xFFL);
        buf[ofs + 7] = (byte)(i >> 56 & 0xFFL);
    }

    @Override
    public int compare(byte[] buf1, int ofs1, byte[] buf2, int ofs2) {
        double f1 = this.deserializeDouble(buf1, ofs1);
        double f2 = this.deserializeDouble(buf2, ofs2);
        return Double.compare(f1, f2);
    }
}

