/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.JsonArray;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactory;
import com.google.jstestdriver.BrowserStartupAction;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FailureCheckerAction;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.ServerShutdownAction;
import com.google.jstestdriver.ServerStartupAction;
import com.google.jstestdriver.action.ConfigureProxyAction;
import com.google.jstestdriver.action.UploadAction;
import com.google.jstestdriver.browser.BrowserActionExecutorAction;
import com.google.jstestdriver.output.PrintXmlTestResultsAction;
import com.google.jstestdriver.output.XmlPrinter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSequenceBuilder {
    private final ActionFactory actionFactory;
    private final FileLoader fileLoader;
    private final CapturedBrowsers capturedBrowsers;
    private HashMap<String, FileInfo> files = new LinkedHashMap<String, FileInfo>();
    private Set<FileInfo> fileSet;
    private int localServerPort = -1;
    private boolean preloadFiles = false;
    private boolean reset;
    private List<String> tests = new LinkedList<String>();
    private List<String> dryRunFor = new LinkedList<String>();
    private List<String> commands = new LinkedList<String>();
    private XmlPrinter xmlPrinter;
    private final BrowserActionExecutorAction browserActionsRunner;
    private final FailureCheckerAction failureCheckerAction;
    private final UploadAction uploadAction;
    private final ConfigureProxyAction.Factory proxyActionFactory;
    private boolean raiseOnFailure = false;
    private JsonArray proxyConfig;
    private final BrowserStartupAction browserStartup;

    @Inject
    public ActionSequenceBuilder(ActionFactory actionFactory, FileLoader fileLoader, ResponseStreamFactory responseStreamFactory, BrowserActionExecutorAction browserActionsRunner, FailureCheckerAction failureCheckerAction, UploadAction uploadAction, CapturedBrowsers capturedBrowsers, @Named(value="proxy") JsonArray proxyConfig, ConfigureProxyAction.Factory proxyActionFactory, BrowserStartupAction browserStartup) {
        this.actionFactory = actionFactory;
        this.fileLoader = fileLoader;
        this.browserActionsRunner = browserActionsRunner;
        this.failureCheckerAction = failureCheckerAction;
        this.uploadAction = uploadAction;
        this.capturedBrowsers = capturedBrowsers;
        this.proxyConfig = proxyConfig;
        this.proxyActionFactory = proxyActionFactory;
        this.browserStartup = browserStartup;
    }

    private void addServerActions(List<Action> actions, boolean leaveServerRunning) {
        if (this.preloadFiles) {
            for (FileInfo file : this.fileLoader.loadFiles(this.fileSet, true)) {
                this.files.put(file.getFilePath(), file);
            }
        }
        ServerStartupAction serverStartupAction = this.actionFactory.getServerStartupAction(this.localServerPort, this.capturedBrowsers, new FilesCache(this.files));
        actions.add(0, serverStartupAction);
        if (!leaveServerRunning) {
            actions.add(new ServerShutdownAction(serverStartupAction));
        } else {
            actions.add(this.browserStartup);
        }
    }

    public ActionSequenceBuilder addTests(List<String> tests) {
        this.tests.addAll(tests);
        return this;
    }

    public ActionSequenceBuilder asDryRunFor(List<String> dryRunFor) {
        this.dryRunFor.addAll(dryRunFor);
        return this;
    }

    public List<Action> build() {
        LinkedList<Action> actions = new LinkedList<Action>();
        actions.add(this.proxyActionFactory.create(this.proxyConfig));
        actions.add(this.uploadAction);
        if (!this.leaveServerRunning()) {
            actions.add(this.browserActionsRunner);
        }
        if (this.xmlPrinter != null) {
            actions.add(new PrintXmlTestResultsAction(this.xmlPrinter));
        }
        if (this.needToStartServer()) {
            this.addServerActions(actions, this.leaveServerRunning());
        }
        if (!this.tests.isEmpty() && this.raiseOnFailure) {
            actions.add(this.failureCheckerAction);
        }
        return actions;
    }

    private boolean leaveServerRunning() {
        return this.tests.isEmpty() && this.commands.isEmpty() && !this.reset && this.dryRunFor.isEmpty();
    }

    private boolean needToStartServer() {
        return this.localServerPort != -1;
    }

    public ActionSequenceBuilder reset(boolean reset) {
        this.reset = reset;
        return this;
    }

    public ActionSequenceBuilder usingFiles(Set<FileInfo> fileSet, boolean preloadFiles) {
        this.fileSet = fileSet;
        this.preloadFiles = preloadFiles;
        return this;
    }

    public ActionSequenceBuilder withLocalServerPort(int localServerPort) {
        this.localServerPort = localServerPort;
        return this;
    }

    public ActionSequenceBuilder addCommands(List<String> commands) {
        this.commands.addAll(commands);
        return this;
    }

    public ActionSequenceBuilder printingResultsWhenFinished(XmlPrinter printer) {
        this.xmlPrinter = printer;
        return this;
    }

    public ActionSequenceBuilder raiseOnFailure() {
        this.raiseOnFailure = true;
        return this;
    }
}

