/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.action;

import com.google.gson.JsonArray;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.hooks.ProxyConfigurationFilter;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.model.RunData;
import java.net.MalformedURLException;
import java.net.URL;

public class ConfigureProxyAction
implements Action {
    private final HandlerPathPrefix prefixer;
    private final String baseUrl;
    private final Server server;
    private final ProxyConfigurationFilter filter;
    private final JsonArray proxyConfig;

    @Inject
    public ConfigureProxyAction(@Named(value="serverHandlerPrefix") HandlerPathPrefix prefixer, @Named(value="server") String baseUrl, Server server, ProxyConfigurationFilter filter, @Assisted JsonArray proxyConfig) {
        this.prefixer = prefixer;
        this.baseUrl = baseUrl;
        this.server = server;
        this.filter = filter;
        this.proxyConfig = proxyConfig;
    }

    public RunData run(RunData runData) {
        try {
            URL initialUrl = new URL(this.baseUrl + "/proxy");
            URL adjustedUrl = new URL(initialUrl.getProtocol(), initialUrl.getHost(), initialUrl.getPort(), this.prefixer.prefixPath(initialUrl.getPath(), "jstd"));
            this.server.postJson(adjustedUrl.toString(), this.filter.filter(this.proxyConfig));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return runData;
    }

    public static interface Factory {
        public ConfigureProxyAction create(JsonArray var1);
    }
}

