/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.jstestdriver.hooks.AuthStrategy;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthHandler
implements RequestHandler {
    private final HttpServletResponse response;
    private final Set<AuthStrategy> authStrategies;

    @Inject
    public AuthHandler(HttpServletResponse response, Set<AuthStrategy> authStrategies) {
        this.response = response;
        this.authStrategies = authStrategies;
    }

    @Override
    public void handleIt() throws IOException {
        for (AuthStrategy strategy : this.authStrategies) {
            for (Cookie cookie : strategy.getCookies()) {
                this.response.addCookie(cookie);
            }
        }
    }
}

