/* retroMrnaInfo.h was originally generated by the autoSql program, which also 
 * generated retroMrnaInfo.c and retroMrnaInfo.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef RETROMRNAINFO_H
#define RETROMRNAINFO_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define RETROMRNAINFO_NUM_COLS 57

struct retroMrnaInfo
/* Retrogenes based on cDNA alignments that are expressed or processed pseudogenes. */
    {
    struct retroMrnaInfo *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold col1 */
    unsigned chromStart;	/* pseudogene alignment start position col2 */
    unsigned chromEnd;	/* pseudogene alignment end position col3 */
    char *name;	/* Name of pseudogene col4 */
    unsigned score;	/* score of pseudogene with gene col5 */
    char strand[3];	/* + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Always zero for now */
    int blockCount;	/* Number of blocks */
    int *blockSizes;	/* Comma separated list of block sizes */
    int *chromStarts;	/* Start positions relative to chromStart */
    int retroExonCount;	/* number of exons in retroGene col13 */
    int axtScore;	/* blastz score, parent mrna aligned to pseudogene col14 */
    char *type;	/* type of evidence col15 */
    char *gChrom;	/* Chromosome name col16 */
    int gStart;	/* gene alignment start position col17 */
    int gEnd;	/* gene alignment end position col18 */
    char gStrand[3];	/* strand of gene col19 */
    unsigned parentSpliceCount;	/* # of splice sites in parent gene col20 */
    unsigned geneOverlap;	/* bases overlapping col21 */
    unsigned polyA;	/* count of As in polyA col22 */
    int polyAstart;	/* start of polyA, relative to end of pseudogene col23 */
    int exonCover;	/* number of exons in Gene covered col24 */
    unsigned intronCount;	/* number of introns in pseudogene col25 */
    unsigned bestAliCount;	/* number of good mrnas aligning col26 */
    unsigned matches;	/* matches + repMatches col27 */
    unsigned qSize;	/* aligning bases in pseudogene col28 */
    unsigned qEnd;	/* end of cdna alignment col29 */
    unsigned tReps;	/* repeats in gene col30 */
    int overlapRhesus;	/* percent of retro that breaks net relative to Rhesus col31 */
    int overlapMouse;	/* percent of retro that breaks net relative to Mouse col32 */
    unsigned coverage;	/* % of bases that align to gene col33 */
    int label;	/* 1=pseudogene,-1 not pseudogene -2 expressed retroGene col34 */
    unsigned milliBad;	/* milliBad score, pseudogene aligned to genome col35 */
    unsigned oldScore;	/* another heuristic col36 */
    int oldIntronCount;	/* old simple intron count col37 */
    int processedIntrons;	/* count of introns removed via retrotransposition col38 */
    int conservedSpliceSites;	/* conserved splice site count col39 */
    int maxOverlap;	/* largest overlap with another mrna col40 */
    char *refSeq;	/* Name of closest regSeq to gene col41 */
    int rStart;	/* refSeq alignment start position col42 */
    int rEnd;	/* refSeq alignment end position col43 */
    char *mgc;	/* Name of closest mgc to gene col44 */
    int mStart;	/* mgc alignment start position col45 */
    int mEnd;	/* mgc alignment end position col46 */
    char *kgName;	/* Name of closest knownGene to gene col47 */
    int kStart;	/* kg alignment start position col48 */
    int kEnd;	/* kg alignment end position col49 */
    char *overName;	/* name of overlapping mrna col50 */
    int overStart;	/* overlapping mrna start position col51 */
    int overExonCover;	/* count of overlapping mrna exons col52 */
    char overStrand[3];	/* strand of overlapping mrna col53 */
    int overlapDog;	/* percent of retro that breaks net relative to dog col54 */
    float posConf;	/* pvalue for positive col55 */
    unsigned polyAlen;	/* length of polyA col56 */
    float kaku;	/* ratio of substitutions between coding and utr wrt parent gene */
    };

struct retroMrnaInfo *retroMrnaInfoLoad(char **row);
struct retroMrnaInfo *retroMrnaInfo56Load(char **row);
/* Load a retroMrnaInfo from row fetched with select * from retroMrnaInfo
 * from database.  Dispose of this with retroMrnaInfoFree(). */

struct retroMrnaInfo *retroMrnaInfoLoadAll(char *fileName);
/* Load all retroMrnaInfo from whitespace-separated file.
 * Dispose of this with retroMrnaInfoFreeList(). */

struct retroMrnaInfo *retroMrnaInfoLoadAllByChar(char *fileName, char chopper);
/* Load all retroMrnaInfo from chopper separated file.
 * Dispose of this with retroMrnaInfoFreeList(). */

#define retroMrnaInfoLoadAllByTab(a) retroMrnaInfoLoadAllByChar(a, '\t');
/* Load all retroMrnaInfo from tab separated file.
 * Dispose of this with retroMrnaInfoFreeList(). */

struct retroMrnaInfo *retroMrnaInfoLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all retroMrnaInfo from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with retroMrnaInfoFreeList(). */

void retroMrnaInfoSaveToDb(struct sqlConnection *conn, struct retroMrnaInfo *el, char *tableName, int updateSize);
/* Save retroMrnaInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use retroMrnaInfoSaveToDbEscaped() */

void retroMrnaInfoSaveToDbEscaped(struct sqlConnection *conn, struct retroMrnaInfo *el, char *tableName, int updateSize);
/* Save retroMrnaInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than retroMrnaInfoSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct retroMrnaInfo *retroMrnaInfoCommaIn(char **pS, struct retroMrnaInfo *ret);
/* Create a retroMrnaInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new retroMrnaInfo */

void retroMrnaInfoFree(struct retroMrnaInfo **pEl);
/* Free a single dynamically allocated retroMrnaInfo such as created
 * with retroMrnaInfoLoad(). */

void retroMrnaInfoFreeList(struct retroMrnaInfo **pList);
/* Free a list of dynamically allocated retroMrnaInfo's */

void retroMrnaInfoOutput(struct retroMrnaInfo *el, FILE *f, char sep, char lastSep);
/* Print out retroMrnaInfo.  Separate fields with sep. Follow last field with lastSep. */

#define retroMrnaInfoTabOut(el,f) retroMrnaInfoOutput(el,f,'\t','\n');
/* Print out retroMrnaInfo as a line in a tab-separated file. */

#define retroMrnaInfoCommaOut(el,f) retroMrnaInfoOutput(el,f,',',',');
/* Print out retroMrnaInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */


struct retroMrnaInfo *retroMrnaInfoQuery(struct sqlConnection *conn,
                                       char *table, char *mappedId);
/* load a single transMapInfo object for an mapped id from a table,
 * or error if not found */
#endif /* RETROMRNAINFO_H */
