/* affyAtlas.c was originally generated by the autoSql program, which also 
 * generated affyAtlas.h and affyAtlas.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "affyAtlas.h"


void affyAtlasStaticLoad(char **row, struct affyAtlas *ret)
/* Load a row from affyAtlas table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->annName = row[0];
ret->probeSet = row[1];
ret->signal = atof(row[2]);
strcpy(ret->detection, row[3]);
ret->pval = atof(row[4]);
ret->tissue = row[5];
}

struct affyAtlas *affyAtlasLoad(char **row)
/* Load a affyAtlas from row fetched with select * from affyAtlas
 * from database.  Dispose of this with affyAtlasFree(). */
{
struct affyAtlas *ret;

AllocVar(ret);
ret->annName = cloneString(row[0]);
ret->probeSet = cloneString(row[1]);
ret->signal = atof(row[2]);
strcpy(ret->detection, row[3]);
ret->pval = atof(row[4]);
ret->tissue = cloneString(row[5]);
return ret;
}

struct affyAtlas *affyAtlasLoadAll(char *fileName) 
/* Load all affyAtlas from a tab-separated file.
 * Dispose of this with affyAtlasFreeList(). */
{
struct affyAtlas *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = affyAtlasLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct affyAtlas *affyAtlasLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all affyAtlas from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with affyAtlasFreeList(). */
{
struct affyAtlas *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = affyAtlasLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void affyAtlasSaveToDb(struct sqlConnection *conn, struct affyAtlas *el, char *tableName, int updateSize)
/* Save affyAtlas as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use affyAtlasSaveToDbEscaped() */
{
struct dyString *update = newDyString(updateSize);
dyStringPrintf(update, "insert into %s values ( '%s','%s',%f,'%s',%f,'%s')", 
	tableName,  el->annName,  el->probeSet,  el->signal,  el->detection,  el->pval,  el->tissue);
sqlUpdate(conn, update->string);
freeDyString(&update);
}

void affyAtlasSaveToDbEscaped(struct sqlConnection *conn, struct affyAtlas *el, char *tableName, int updateSize)
/* Save affyAtlas as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than affyAtlasSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 
{
struct dyString *update = newDyString(updateSize);
char  *annName, *probeSet, *detection, *tissue;
annName = sqlEscapeString(el->annName);
probeSet = sqlEscapeString(el->probeSet);
detection = sqlEscapeString(el->detection);
tissue = sqlEscapeString(el->tissue);

dyStringPrintf(update, "insert into %s values ( '%s','%s',%f,'%s',%f,'%s')", 
	tableName,  annName,  probeSet, el->signal ,  detection, el->pval ,  tissue);
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&annName);
freez(&probeSet);
freez(&detection);
freez(&tissue);
}

struct affyAtlas *affyAtlasCommaIn(char **pS, struct affyAtlas *ret)
/* Create a affyAtlas out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new affyAtlas */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->annName = sqlStringComma(&s);
ret->probeSet = sqlStringComma(&s);
ret->signal = sqlFloatComma(&s);
sqlFixedStringComma(&s, ret->detection, sizeof(ret->detection));
ret->pval = sqlFloatComma(&s);
ret->tissue = sqlStringComma(&s);
*pS = s;
return ret;
}

void affyAtlasFree(struct affyAtlas **pEl)
/* Free a single dynamically allocated affyAtlas such as created
 * with affyAtlasLoad(). */
{
struct affyAtlas *el;

if ((el = *pEl) == NULL) return;
freeMem(el->annName);
freeMem(el->probeSet);
freeMem(el->tissue);
freez(pEl);
}

void affyAtlasFreeList(struct affyAtlas **pList)
/* Free a list of dynamically allocated affyAtlas's */
{
struct affyAtlas *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    affyAtlasFree(&el);
    }
*pList = NULL;
}

void affyAtlasOutput(struct affyAtlas *el, FILE *f, char sep, char lastSep) 
/* Print out affyAtlas.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->annName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->probeSet);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->signal);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->detection);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->pval);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tissue);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

