# samAlignment.sql was originally generated by the autoSql program, which also 
# generated samAlignment.c and samAlignment.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#The fields of a SAM short read alignment, the text version of BAM.
CREATE TABLE samAlignment (
    qName varchar(255) not null,	# Query template name - name of a read
    flag smallint unsigned not null,	# Flags.  0x10 set for reverse complement.  See SAM docs for others.
    rName varchar(255) not null,	# Reference sequence name (often a chromosome)
    pos int unsigned not null,	# 1 based position
    mapQ tinyint unsigned not null,	# Mapping quality 0-255, 255 is best
    cigar varchar(255) not null,	# CIGAR encoded alignment string.
    rNext varchar(255) not null,	# Ref sequence for next (mate) read. '=' if same as rName, '*' if no mate
    pNext int not null,	# Position (1-based) of next (mate) sequence. May be -1 or 0 if no mate
    tLen int not null,	# Size of DNA template for mated pairs.  -size for one of mate pairs
    seq varchar(255) not null,	# Query template sequence
    qual varchar(255) not null,	# ASCII of Phred-scaled base QUALity+33.  Just '*' if no quality scores
    tagTypeVals varchar(255) not null,	# Tab-delimited list of tag:type:value optional extra fields
              #Indices
    PRIMARY KEY(qName)
);
