/* txInfo.c was originally generated by the autoSql program, which also 
 * generated txInfo.h and txInfo.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "txInfo.h"


void txInfoStaticLoad(char **row, struct txInfo *ret)
/* Load a row from txInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->category = row[1];
ret->sourceAcc = row[2];
ret->isRefSeq = sqlUnsigned(row[3]);
ret->sourceSize = sqlSigned(row[4]);
ret->aliCoverage = sqlDouble(row[5]);
ret->aliIdRatio = sqlDouble(row[6]);
ret->genoMapCount = sqlSigned(row[7]);
ret->exonCount = sqlSigned(row[8]);
ret->orfSize = sqlSigned(row[9]);
ret->cdsScore = sqlDouble(row[10]);
ret->startComplete = sqlUnsigned(row[11]);
ret->endComplete = sqlUnsigned(row[12]);
ret->nonsenseMediatedDecay = sqlUnsigned(row[13]);
ret->retainedIntron = sqlUnsigned(row[14]);
ret->bleedIntoIntron = sqlSigned(row[15]);
ret->strangeSplice = sqlSigned(row[16]);
ret->atacIntrons = sqlSigned(row[17]);
ret->cdsSingleInIntron = sqlUnsigned(row[18]);
ret->cdsSingleInUtr3 = sqlUnsigned(row[19]);
ret->selenocysteine = sqlUnsigned(row[20]);
ret->genomicFrameShift = sqlUnsigned(row[21]);
ret->genomicStop = sqlUnsigned(row[22]);
}

struct txInfo *txInfoLoad(char **row)
/* Load a txInfo from row fetched with select * from txInfo
 * from database.  Dispose of this with txInfoFree(). */
{
struct txInfo *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->category = cloneString(row[1]);
ret->sourceAcc = cloneString(row[2]);
ret->isRefSeq = sqlUnsigned(row[3]);
ret->sourceSize = sqlSigned(row[4]);
ret->aliCoverage = sqlDouble(row[5]);
ret->aliIdRatio = sqlDouble(row[6]);
ret->genoMapCount = sqlSigned(row[7]);
ret->exonCount = sqlSigned(row[8]);
ret->orfSize = sqlSigned(row[9]);
ret->cdsScore = sqlDouble(row[10]);
ret->startComplete = sqlUnsigned(row[11]);
ret->endComplete = sqlUnsigned(row[12]);
ret->nonsenseMediatedDecay = sqlUnsigned(row[13]);
ret->retainedIntron = sqlUnsigned(row[14]);
ret->bleedIntoIntron = sqlSigned(row[15]);
ret->strangeSplice = sqlSigned(row[16]);
ret->atacIntrons = sqlSigned(row[17]);
ret->cdsSingleInIntron = sqlUnsigned(row[18]);
ret->cdsSingleInUtr3 = sqlUnsigned(row[19]);
ret->selenocysteine = sqlUnsigned(row[20]);
ret->genomicFrameShift = sqlUnsigned(row[21]);
ret->genomicStop = sqlUnsigned(row[22]);
return ret;
}

struct txInfo *txInfoLoadAll(char *fileName) 
/* Load all txInfo from a whitespace-separated file.
 * Dispose of this with txInfoFreeList(). */
{
struct txInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[23];

while (lineFileRow(lf, row))
    {
    el = txInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct txInfo *txInfoLoadAllByChar(char *fileName, char chopper) 
/* Load all txInfo from a chopper separated file.
 * Dispose of this with txInfoFreeList(). */
{
struct txInfo *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[23];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = txInfoLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct txInfo *txInfoCommaIn(char **pS, struct txInfo *ret)
/* Create a txInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txInfo */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->category = sqlStringComma(&s);
ret->sourceAcc = sqlStringComma(&s);
ret->isRefSeq = sqlUnsignedComma(&s);
ret->sourceSize = sqlSignedComma(&s);
ret->aliCoverage = sqlDoubleComma(&s);
ret->aliIdRatio = sqlDoubleComma(&s);
ret->genoMapCount = sqlSignedComma(&s);
ret->exonCount = sqlSignedComma(&s);
ret->orfSize = sqlSignedComma(&s);
ret->cdsScore = sqlDoubleComma(&s);
ret->startComplete = sqlUnsignedComma(&s);
ret->endComplete = sqlUnsignedComma(&s);
ret->nonsenseMediatedDecay = sqlUnsignedComma(&s);
ret->retainedIntron = sqlUnsignedComma(&s);
ret->bleedIntoIntron = sqlSignedComma(&s);
ret->strangeSplice = sqlSignedComma(&s);
ret->atacIntrons = sqlSignedComma(&s);
ret->cdsSingleInIntron = sqlUnsignedComma(&s);
ret->cdsSingleInUtr3 = sqlUnsignedComma(&s);
ret->selenocysteine = sqlUnsignedComma(&s);
ret->genomicFrameShift = sqlUnsignedComma(&s);
ret->genomicStop = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void txInfoFree(struct txInfo **pEl)
/* Free a single dynamically allocated txInfo such as created
 * with txInfoLoad(). */
{
struct txInfo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->category);
freeMem(el->sourceAcc);
freez(pEl);
}

void txInfoFreeList(struct txInfo **pList)
/* Free a list of dynamically allocated txInfo's */
{
struct txInfo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    txInfoFree(&el);
    }
*pList = NULL;
}

void txInfoOutput(struct txInfo *el, FILE *f, char sep, char lastSep) 
/* Print out txInfo.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->category);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sourceAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->isRefSeq);
fputc(sep,f);
fprintf(f, "%d", el->sourceSize);
fputc(sep,f);
fprintf(f, "%g", el->aliCoverage);
fputc(sep,f);
fprintf(f, "%g", el->aliIdRatio);
fputc(sep,f);
fprintf(f, "%d", el->genoMapCount);
fputc(sep,f);
fprintf(f, "%d", el->exonCount);
fputc(sep,f);
fprintf(f, "%d", el->orfSize);
fputc(sep,f);
fprintf(f, "%g", el->cdsScore);
fputc(sep,f);
fprintf(f, "%u", el->startComplete);
fputc(sep,f);
fprintf(f, "%u", el->endComplete);
fputc(sep,f);
fprintf(f, "%u", el->nonsenseMediatedDecay);
fputc(sep,f);
fprintf(f, "%u", el->retainedIntron);
fputc(sep,f);
fprintf(f, "%d", el->bleedIntoIntron);
fputc(sep,f);
fprintf(f, "%d", el->strangeSplice);
fputc(sep,f);
fprintf(f, "%d", el->atacIntrons);
fputc(sep,f);
fprintf(f, "%u", el->cdsSingleInIntron);
fputc(sep,f);
fprintf(f, "%u", el->cdsSingleInUtr3);
fputc(sep,f);
fprintf(f, "%u", el->selenocysteine);
fputc(sep,f);
fprintf(f, "%u", el->genomicFrameShift);
fputc(sep,f);
fprintf(f, "%u", el->genomicStop);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

double txInfoCodingScore(struct txInfo *info, boolean boostRefSeq)
/* Return coding score for info.  This is just the cdsScore score,
 * plus another 1000 if it's a refSeq.  1000 is quite a bit for a
 * cdsScore score, equivalent to another 1000 bases in the coding region. */
{
double score = info->cdsScore;
if (boostRefSeq && info->isRefSeq)
    score += 1000;
return score;
}

