/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.IPositioned;
import org.xmind.core.IRelationship;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddRelationshipCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CreateRelationshipCommand;
import org.xmind.ui.commands.CreateTopicCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyRelationshipEndCommand;
import org.xmind.ui.commands.ModifyStyleCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.decorations.IRelationshipDecoration;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.util.MindMapUtils;

public class RelationshipCreatablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "create".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("create".equals(type)) {
            this.performCreateTopic(request);
        }
    }

    private void performCreateTopic(Request request) {
        IDecoration decoration;
        IPart source = request.getPrimaryTarget();
        if (!(source instanceof IRelationshipPart)) {
            return;
        }
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        IRelationshipPart rel = (IRelationshipPart)source;
        IRelationship r = rel.getRelationship();
        IFigure figure = rel.getFigure();
        Point newPosition = null;
        if (figure instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)figure).getDecoration()) instanceof IRelationshipDecoration) {
            PrecisionPoint titlePosition = ((IRelationshipDecoration)decoration).getTitlePosition(figure);
            newPosition = titlePosition.toDraw2DPoint();
        }
        if (newPosition == null) {
            newPosition = figure.getBounds().getCenter();
        }
        ITopic rootTopic = (ITopic)viewer.getAdapter(ITopic.class);
        CreateTopicCommand createTopic = new CreateTopicCommand(rootTopic.getOwnedWorkbook());
        String newTitle = r.getTitleText();
        ModifyTitleTextCommand modifyTitle = new ModifyTitleTextCommand((ISourceProvider)createTopic, newTitle);
        ModifyTitleTextCommand clearRelTitle = new ModifyTitleTextCommand((ITitled)r, null);
        ModifyPositionCommand modifyPosition = new ModifyPositionCommand((ISourceProvider)createTopic, MindMapUtils.toModelPosition(newPosition));
        ModifyRelationshipEndCommand modifyRelEnd = new ModifyRelationshipEndCommand(r, (ISourceProvider)createTopic, false);
        ModifyPositionCommand resetCP1 = new ModifyPositionCommand((IPositioned)r.getControlPoint(0), null);
        ModifyPositionCommand resetCP2 = new ModifyPositionCommand((IPositioned)r.getControlPoint(1), null);
        CreateRelationshipCommand createRel = new CreateRelationshipCommand(rootTopic.getOwnedWorkbook());
        ModifyRelationshipEndCommand modifyRel2End1 = new ModifyRelationshipEndCommand((ISourceProvider)createRel, (ISourceProvider)createTopic, true);
        ModifyRelationshipEndCommand modifyRel2End2 = new ModifyRelationshipEndCommand((ISourceProvider)createRel, r.getEnd2Id(), false);
        ModifyStyleCommand modifyRelStyle = new ModifyStyleCommand((ISourceProvider)createRel, r.getStyleId());
        AddTopicCommand addTopic = new AddTopicCommand((ISourceProvider)createTopic, rootTopic, -1, "detached");
        AddRelationshipCommand addRel = new AddRelationshipCommand((ISourceProvider)createRel, r.getOwnedSheet());
        clearRelTitle.setSourceCollectable(false);
        modifyRelEnd.setSourceCollectable(false);
        resetCP1.setSourceCollectable(false);
        resetCP2.setSourceCollectable(false);
        createRel.setSourceCollectable(false);
        modifyRel2End1.setSourceCollectable(false);
        modifyRel2End2.setSourceCollectable(false);
        modifyRelStyle.setSourceCollectable(false);
        addRel.setSourceCollectable(false);
        CompoundCommand cmd = new CompoundCommand(new Command[]{createTopic, modifyTitle, clearRelTitle, modifyPosition, modifyRelEnd, resetCP1, resetCP2, createRel, modifyRel2End1, modifyRel2End2, modifyRelStyle, addTopic, addRel});
        this.saveAndRun((Command)cmd, request.getTargetDomain());
        if (cmd instanceof ISourceProvider) {
            this.select(cmd.getSources(), viewer);
        }
    }
}

