/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.properties.StyledPropertySectionPart;

public class SheetBackgroundPropertySectionPart
extends StyledPropertySectionPart {
    private Control bar;
    private ColorPicker backgroundColorPicker;

    @Override
    protected GridLayout createLayout(Composite parent) {
        GridLayout layout = super.createLayout(parent);
        layout.numColumns = 2;
        layout.horizontalSpacing = 7;
        return layout;
    }

    @Override
    protected void createContent(Composite parent) {
        Label caption = new Label(parent, 0);
        caption.setText(PropertyMessages.BackgroundColor_label);
        caption.setLayoutData((Object)new GridData(4, 2, false, false));
        this.backgroundColorPicker = new ColorPicker(5, PaletteContents.getDefault());
        this.backgroundColorPicker.getAction().setToolTipText(PropertyMessages.BackgroundColor_toolTip);
        this.backgroundColorPicker.addOpenListener((IOpenListener)new BackgroundColorOpenListener());
        ToolBarManager colorBar = new ToolBarManager(0x800000);
        colorBar.add((IContributionItem)this.backgroundColorPicker);
        this.bar = colorBar.createControl(parent);
        this.bar.setLayoutData((Object)new GridData(1, 2, false, false));
    }

    @Override
    protected void doRefresh() {
        this.updateColorPicker(this.backgroundColorPicker, "svg:fill", null);
    }

    public void setFocus() {
        if (this.bar != null && !this.bar.isDisposed()) {
            this.bar.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.bar = null;
        this.backgroundColorPicker = null;
    }

    private void changeBackgroundColor(IColorSelection selection) {
        this.changeColor(selection, "svg:fill", CommandMessages.Command_ModifySheetBackgroundColor);
    }

    private class BackgroundColorOpenListener
    implements IOpenListener {
        private BackgroundColorOpenListener() {
        }

        public void open(OpenEvent event) {
            SheetBackgroundPropertySectionPart.this.changeBackgroundColor((IColorSelection)event.getSelection());
        }
    }
}

