/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPageWithPro20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.core.ITopic;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.image.ImageWriter;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt.GanttPlugin;
import org.xmind.ui.gantt.export.DateInfoPickerViewer2;
import org.xmind.ui.gantt.export.GanttImageCreator;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.wizards.UncompletablePage;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.io.MonitoredOutputStream;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.ImagePreviewViewer;
import org.xmind.ui.wizards.AbstractExportPage;
import org.xmind.ui.wizards.AbstractExportWizard;

public class ExportToImageWizard
extends AbstractExportWizard {
    private static final String IMAGE_EXPORT_PAGE_NAME = "imageExportPage";
    private static final String PROP_FORMAT = "FORMAT";
    private static final int PREVIEW_CONTROL_WIDTH = 400;
    private static final int PREVIEW_CONTROL_HEIGHT = 220;
    private static final int MAX_IMAGE_SIZE = 50000000;
    private GanttViewer ganttViewer;
    private ImageFormat format;
    private ImageExportPage page;
    private GanttImageCreator imageCreator = null;
    private GhostShellProvider shell = null;

    public ExportToImageWizard(GanttViewer ganttViewer) {
        this.ganttViewer = ganttViewer;
        this.setWindowTitle(WizardMessages.ImageExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(GanttPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
    }

    protected void loadDialogSettings(IDialogSettings settings) {
        String mediaType = settings.get(PROP_FORMAT);
        ImageFormat lastFormat = ImageFormat.findByMediaType((String)mediaType, (ImageFormat)ImageFormat.PNG);
        this.setFormat(lastFormat);
        super.loadDialogSettings(settings);
    }

    protected void saveDialogSettings(IDialogSettings settings) {
        super.saveDialogSettings(settings);
        if (this.format != null) {
            settings.put(PROP_FORMAT, this.format.getMediaType());
        }
    }

    public void addPages() {
        if (this.ganttViewer != null) {
            this.addPage((IWizardPage)new VerifyWizardPageWithPro20141031("ExportGanttToImage", GanttMessages.ExportToImagePage));
            this.page = new ImageExportPage();
            this.addPage((IWizardPage)this.page);
        } else {
            UncompletablePage errorPage = new UncompletablePage(WizardMessages.NoContentPage_title, WizardMessages.NoContentPage_message);
            errorPage.setDescription(WizardMessages.NoContentPage_description);
            this.addPage((IWizardPage)errorPage);
        }
    }

    private void setFormat(ImageFormat format) {
        this.format = format;
    }

    private ImageFormat getFormat() {
        return this.format;
    }

    private boolean hasFormat() {
        return this.format != null;
    }

    public boolean performFinish() {
        if (this.page.getPreviewState() == PreviewState.Error && !MessageDialog.openConfirm((Shell)this.getShell(), (String)WizardMessages.ImageExport_ConfirmProceedWithError_title, (String)WizardMessages.ImageExport_ConfirmProceedWithError_message)) {
            return false;
        }
        if (this.page != null) {
            this.page.cancel();
        }
        if (!this.hasTargetPath()) {
            return false;
        }
        if (!this.isExtensionCompatible(FileUtils.getExtension((String)this.getTargetPath()))) {
            String fileName = new File(this.getTargetPath()).getName();
            String formatName = this.getFormatName();
            String messages = NLS.bind((String)WizardMessages.Export_UncompatibleFormat_message, (Object)fileName, (Object)formatName);
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)WizardMessages.Export_UncompatibleFormat_title, (String)messages)) {
                return false;
            }
        }
        if (!this.isOverwriteWithoutPrompt() && new File(this.getTargetPath()).exists() && !DialogUtils.confirmOverwrite((Shell)this.getShell(), (String)this.getTargetPath())) {
            return false;
        }
        return this.doExport();
    }

    /*
     * Unable to fully structure code
     */
    private boolean doExport() {
        VerifyUI20141031.getUsageDataCollector().increase("ExportGanttToImageCount");
        display = Display.getCurrent();
        parentShell = this.findParentShell(display);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    display.syncExec(new Runnable(){

                        public void run() {
                            try {
                                ExportToImageWizard.this.doExport(monitor, display, parentShell);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ExportToImageWizard.this.deleteTargetFile();
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.ExportToImageWizard_Error_text, (String)GanttMessages.ExportToImageWizard_Error_message);
                            }
                        }
                    });
                }
            });
            return true;
        }
        catch (Throwable e) {
            if (!(e instanceof InterruptedException) && !(e instanceof InterruptedIOException)) ** GOTO lbl12
            return false;
        }
        while ((t = ((InvocationTargetException)e).getCause()) != null) {
            e = t;
lbl12:
            // 2 sources

            if (e instanceof InvocationTargetException) continue;
        }
        ex = e;
        display.asyncExec(new Runnable((Throwable)ex){
            private final /* synthetic */ Throwable val$ex;
            {
                this.val$ex = throwable;
            }

            public void run() {
                ExportToImageWizard.this.handleExportException(this.val$ex);
            }
        });
        return false;
    }

    private void deleteTargetFile() {
        String path = this.getTargetPath();
        File file = new File(path);
        file.delete();
    }

    private Shell findParentShell(Display display) {
        Shell parentShell;
        Composite shellParent;
        Shell shell = this.getContainer().getShell();
        if (shell != null && (shellParent = shell.getParent()) instanceof Shell && !(parentShell = (Shell)shellParent).isDisposed() && parentShell.getDisplay() == display) {
            return parentShell;
        }
        return null;
    }

    private String getFormatName() {
        return this.hasFormat() ? "'" + this.getFormat().getName() + "'" : "";
    }

    private boolean isExtensionCompatible(String extension) {
        return this.hasFormat() && this.getFormat().getExtensions().contains(extension.toLowerCase());
    }

    private GanttImageCreator getImageCreator(Display display) {
        if (this.imageCreator == null) {
            this.imageCreator = this.createImageCreator(display);
        }
        return this.imageCreator;
    }

    private GanttImageCreator createImageCreator(Display display) {
        IDialogSettings settings = this.getDialogSettings();
        GanttImageCreator exporter = new GanttImageCreator(display, this.ganttViewer, settings);
        return exporter;
    }

    public void dispose() {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        if (this.imageCreator != null) {
            this.imageCreator.dispose();
            this.imageCreator = null;
        }
        super.dispose();
    }

    private void writeImage(Image image, String destPath, IProgressMonitor monitor) throws IOException {
        MonitoredOutputStream output = new MonitoredOutputStream((OutputStream)new FileOutputStream(destPath), monitor);
        ImageWriter writer = this.createImageWriter(image, (OutputStream)output);
        try {
            writer.write();
        }
        finally {
            output.close();
        }
    }

    private ImageWriter createImageWriter(Image image, OutputStream output) {
        return ImageExportUtils.createImageWriter((Image)image, (int)this.getFormat().getSWTFormat(), (OutputStream)output);
    }

    private void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        Image image;
        monitor.beginTask(null, 100);
        monitor.subTask(WizardMessages.ImageExport_CreatingSourceImage);
        GanttImageCreator exporter = this.getImageCreator(display);
        try {
            image = exporter.createCutImage();
        }
        catch (Throwable e) {
            monitor.setCanceled(true);
            throw new InvocationTargetException(e);
        }
        try {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.worked(50);
            String path = this.getTargetPath();
            monitor.subTask(NLS.bind((String)WizardMessages.ImageExport_WritingTargetFile, (Object)path));
            try {
                this.writeImage(image, path, monitor);
            }
            catch (IOException e) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                throw new InvocationTargetException(e);
            }
        }
        finally {
            image.dispose();
        }
        monitor.worked(49);
        this.launchTargetFile(true, monitor, display, parentShell);
        monitor.done();
    }

    protected void launchTargetFile(boolean fileOrDirectory, final IProgressMonitor monitor, final Display display, final Shell parentShell) {
        display.syncExec(new Runnable(){

            public void run() {
                boolean isLinux = Util.isLinux();
                if (!isLinux) {
                    new AbstractExportWizard.ExportSucceedDialog((AbstractExportWizard)ExportToImageWizard.this, parentShell, monitor).open();
                } else {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            new AbstractExportWizard.ExportSucceedDialog((AbstractExportWizard)ExportToImageWizard.this, parentShell, monitor).open();
                        }
                    });
                }
            }
        });
    }

    public void openFile(String path, IProgressMonitor monitor) {
        if (new File(path).exists()) {
            boolean isLinux = Util.isLinux();
            if (!isLinux) {
                monitor.subTask(WizardMessages.ExportPage_Launching);
            }
            Program.launch((String)path);
        }
    }

    private void handleExportException(Throwable e) {
        Logger.log((Throwable)e, (String)NLS.bind((String)WizardMessages.Export_FailedWhenExport, (Object)this.getFormatName()));
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private ITopic getCentralTopic() {
        return (ITopic)this.ganttViewer.getInput();
    }

    protected String getSuggestedFileName() {
        if (this.ganttViewer == null) {
            return null;
        }
        String fileName = this.getCentralTopic().getTitleText();
        String replacedFileName = MindMapUtils.trimFileName((String)fileName);
        return String.valueOf(replacedFileName) + (String)this.getFormat().getExtensions().get(0);
    }

    private static String makeErrorMessage(String originalMessage, boolean largeImage) {
        if (largeImage) {
            return String.valueOf(originalMessage) + " " + WizardMessages.ImageExportPage_ImageTooLarge;
        }
        return originalMessage;
    }

    private class ImageExportPage
    extends AbstractExportPage {
        private Combo formatCombo;
        private Button allTasksRadio;
        private Button tasksBetweenRadio;
        private DateInfoPickerViewer2 startDatePicker;
        private DateInfoPickerViewer2 endDatePicker;
        private ImagePreviewViewer viewer;
        private GeneratePreviewJob generatePreviewJob;
        private PreviewState previewState;
        private Calendar minTime;
        private Calendar maxTime;
        private boolean updating;

        private ImageExportPage() {
            super(ExportToImageWizard.IMAGE_EXPORT_PAGE_NAME, WizardMessages.ImageExportPage_title, null);
            this.updating = false;
            this.setDescription(GanttMessages.ImageExportPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            this.createFormatControls(composite);
            this.createTimeRangeControls(composite);
            this.createPreviewControl(composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.update(null);
            this.generatePreview(ExportToImageWizard.this.getFormat());
        }

        private void createFormatControls(Composite parent) {
            Group group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)new GridLayout());
            group.setText(WizardMessages.ImageExportPage_FormatGroup_title);
            Label label = new Label((Composite)group, 64);
            GridData gd = new GridData(4, 4, true, false);
            gd.widthHint = 400;
            label.setLayoutData((Object)gd);
            label.setText(WizardMessages.ImageExportPage_FormatGroup_description);
            this.formatCombo = new Combo((Composite)group, 2124);
            this.formatCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            ImageFormat[] imageFormatArray = ImageFormat.values();
            int n = imageFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImageFormat format = imageFormatArray[n2];
                this.formatCombo.add(format.getDescription());
                ++n2;
            }
            if (ExportToImageWizard.this.getFormat() != null) {
                this.formatCombo.select(ExportToImageWizard.this.getFormat().ordinal());
            }
            this.hookWidget((Widget)this.formatCombo, 13);
        }

        private void createTimeRangeControls(Composite parent) {
            this.initTimeRange();
            Group group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(GanttMessages.ExportToImage_timeSet);
            this.allTasksRadio = new Button((Composite)group, 16);
            this.allTasksRadio.setText(GanttMessages.ExportToImageWizard_AllTopics_text);
            this.allTasksRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.hookWidget((Widget)this.allTasksRadio, 13);
            this.createTaskBetweenOption((Composite)group);
        }

        private void initTimeRange() {
            ITopic rootTopic = ExportToImageWizard.this.getCentralTopic();
            Date earliestDate = TaskInfoUtils.getEarliestStartDate((ITopic)rootTopic);
            if (earliestDate == null) {
                earliestDate = ExportToImageWizard.this.ganttViewer.getEditDomain().getTimelineModel().getOriginDate().getTime();
            }
            this.minTime = Calendar.getInstance();
            this.minTime.setTime(earliestDate);
            Date latestDate = TaskInfoUtils.getLatestEndDate((ITopic)rootTopic);
            if (latestDate == null) {
                latestDate = ExportToImageWizard.this.ganttViewer.getEditDomain().getTimelineModel().getOriginDate().getTime();
            }
            this.maxTime = Calendar.getInstance();
            this.maxTime.setTime(latestDate);
        }

        private void createTaskBetweenOption(Composite parent) {
            this.tasksBetweenRadio = new Button(parent, 16);
            this.tasksBetweenRadio.setText(GanttMessages.ExportToImageWizard_TasksBetween_text);
            this.tasksBetweenRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.createChangeDateSection(parent);
        }

        private void createChangeDateSection(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            gridData.horizontalIndent = 5;
            composite.setLayoutData((Object)gridData);
            this.startDatePicker = this.createDatePicker(composite);
            this.startDatePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(this.minTime, false)));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label.setText(GanttMessages.ExportToImageWizard_and_text);
            this.endDatePicker = this.createDatePicker(composite);
            this.endDatePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(this.maxTime, false)));
            this.startDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Calendar selectedTime = ImageExportPage.this.startDatePicker.getSelectedDate();
                    Calendar minTime = ImageExportPage.this.startDatePicker.getMinTime();
                    Calendar maxTime = ImageExportPage.this.startDatePicker.getMaxTime();
                    if (!selectedTime.before(minTime) && !selectedTime.after(maxTime)) {
                        ImageExportPage.this.getDialogSettings().put("startTime", ImageExportPage.this.startDatePicker.getSelectedDate().getTimeInMillis());
                        ImageExportPage.this.endDatePicker.setMinTime(ImageExportPage.this.startDatePicker.getSelectedDate());
                        ImageExportPage.this.generatePreview();
                    }
                }
            });
            this.endDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Calendar selectedTime = ImageExportPage.this.endDatePicker.getSelectedDate();
                    Calendar minTime = ImageExportPage.this.endDatePicker.getMinTime();
                    Calendar maxTime = ImageExportPage.this.endDatePicker.getMaxTime();
                    if (!selectedTime.before(minTime) && !selectedTime.after(maxTime)) {
                        ImageExportPage.this.getDialogSettings().put("endTime", ImageExportPage.this.endDatePicker.getSelectedDate().getTimeInMillis());
                        ImageExportPage.this.startDatePicker.setMaxTime(ImageExportPage.this.endDatePicker.getSelectedDate());
                        ImageExportPage.this.generatePreview();
                    }
                }
            });
        }

        private DateInfoPickerViewer2 createDatePicker(Composite parent) {
            final DateInfoPickerViewer2 datePicker = new DateInfoPickerViewer2(parent);
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            datePicker.getControl().setLayoutData((Object)gridData);
            datePicker.setMinTime(this.minTime);
            datePicker.setMaxTime(this.maxTime);
            datePicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Calendar selectedTime = datePicker.getSelectedDate();
                    final Calendar minTime = datePicker.getMinTime();
                    final Calendar maxTime = datePicker.getMaxTime();
                    if (selectedTime.before(minTime)) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.ExportToImageWizard_InvalidValue_text, (String)GanttMessages.ExportToImageWizard_InvalidSmall_text);
                                datePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(minTime, false)));
                            }
                        });
                    } else if (selectedTime.after(maxTime)) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.ExportToImageWizard_InvalidValue_text, (String)GanttMessages.ExportToImageWizard_InvalidBig_text);
                                datePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(maxTime, false)));
                            }
                        });
                    }
                }
            });
            return datePicker;
        }

        private void createPreviewControl(Composite parent) {
            this.viewer = new ImagePreviewViewer(true);
            this.viewer.setPrefWidth(400);
            this.viewer.setPrefHeight(220);
            this.viewer.createControl(parent);
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewer.getControl().setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)8));
            this.hookWidget((Widget)this.viewer.getControl(), 11);
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ImageExportPage.this.updateViewerSize();
                }
            });
        }

        public void dispose() {
            super.dispose();
            if (this.viewer != null && this.viewer.getImage() != null) {
                this.viewer.getImage().dispose();
            }
            this.viewer = null;
            this.disposePreview();
        }

        private void disposePreview() {
            this.cancel();
        }

        protected void handleWidgetEvent(Event event) {
            if (event.widget == this.formatCombo) {
                int selection = this.formatCombo.getSelectionIndex();
                ImageFormat oldFormat = ExportToImageWizard.this.getFormat();
                if (selection < 0) {
                    ExportToImageWizard.this.setFormat(null);
                } else {
                    ExportToImageWizard.this.setFormat(ImageFormat.values()[selection]);
                }
                if (oldFormat != ExportToImageWizard.this.getFormat()) {
                    this.formatChanged();
                }
            } else if (this.viewer != null && event.widget == this.viewer.getControl()) {
                this.updateViewerSize();
            } else if (event.widget == this.allTasksRadio || event.widget == this.tasksBetweenRadio) {
                this.setProperty("timeRange", this.tasksBetweenRadio.getSelection());
            } else {
                super.handleWidgetEvent(event);
            }
        }

        private void update(String key) {
            if (this.updating) {
                return;
            }
            boolean timeRangeRadioChanged = key == null || "timeRange".equals(key);
            this.updating = true;
            if (timeRangeRadioChanged) {
                boolean tasksBetween = this.getBoolean("timeRange");
                this.allTasksRadio.setSelection(!tasksBetween);
                this.tasksBetweenRadio.setSelection(tasksBetween);
                if (!tasksBetween) {
                    this.getDialogSettings().put("startTime", this.minTime.getTimeInMillis());
                    this.getDialogSettings().put("endTime", this.maxTime.getTimeInMillis());
                    this.startDatePicker.setEnabled(false);
                    this.endDatePicker.setEnabled(false);
                } else {
                    this.getDialogSettings().put("startTime", this.startDatePicker.getSelectedDate().getTimeInMillis());
                    this.getDialogSettings().put("endTime", this.endDatePicker.getSelectedDate().getTimeInMillis());
                    this.startDatePicker.setEnabled(true);
                    this.endDatePicker.setEnabled(true);
                }
                if (key != null) {
                    this.generatePreview();
                }
            }
            this.updating = false;
        }

        private boolean getBoolean(String key) {
            return this.getDialogSettings().getBoolean(key);
        }

        private void setProperty(String key, boolean value) {
            this.getDialogSettings().put(key, value);
            this.update(key);
        }

        private void updateViewerSize() {
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            Canvas canvas = this.viewer.getCanvas();
            if (canvas == null || canvas.isDisposed()) {
                return;
            }
            Rectangle bounds = canvas.getBounds();
            this.viewer.setPrefWidth(bounds.width);
            this.viewer.setPrefHeight(bounds.height);
        }

        protected boolean isPageCompletable() {
            return super.isPageCompletable() && ExportToImageWizard.this.hasFormat();
        }

        protected String generateWarningMessage() {
            if (this.previewState == PreviewState.Error && this.viewer != null) {
                return this.viewer.getTitle();
            }
            return super.generateWarningMessage();
        }

        private PreviewState getPreviewState() {
            return this.previewState;
        }

        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            DialogUtils.makeImageSelectorDialog((FileDialog)dialog, (boolean)false, (ImageFormat[])new ImageFormat[]{ExportToImageWizard.this.getFormat()});
            return dialog;
        }

        private void formatChanged() {
            String ext;
            List exts;
            if (this.hasTargetPath() && ExportToImageWizard.this.hasFormat() && !(exts = ExportToImageWizard.this.getFormat().getExtensions()).contains(ext = FileUtils.getExtension((String)this.getTargetPath()))) {
                this.setTargetPath(this.replaceExtension(this.getTargetPath(), ext, (String)exts.get(0)));
            }
            this.updateStatus();
            this.generatePreview(ExportToImageWizard.this.getFormat());
        }

        private String replaceExtension(String path, String oldExt, String newExt) {
            return String.valueOf(path.substring(0, path.length() - oldExt.length())) + newExt;
        }

        private void generatePreview(ImageFormat format) {
            if (format == null) {
                return;
            }
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.updateViewer(null, PreviewState.Generating, false, null);
            }
            this.disposePreview();
            Display display = Display.getCurrent();
            this.generatePreviewJob = new GeneratePreviewJob(format, display);
            this.generatePreviewJob.schedule();
        }

        private void generatePreview() {
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.updateViewer(null, PreviewState.Generating, false, null);
            }
            this.disposePreview();
            Display display = Display.getCurrent();
            this.generatePreviewJob = new GeneratePreviewJob(ExportToImageWizard.this.format, display);
            this.generatePreviewJob.schedule();
        }

        private void asyncUpdateViewer(Display display, final Image image, final PreviewState state, final boolean largeImage, final Point origin) {
            if (Thread.currentThread() != display.getThread()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        ImageExportPage.this.updateViewer(image, state, largeImage, origin);
                    }
                });
            } else {
                this.updateViewer(image, state, largeImage, origin);
            }
        }

        private void updateViewer(Image image, PreviewState state, boolean largeImage, Point origin) {
            this.previewState = state;
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            Image oldImage = this.viewer.getImage();
            if (oldImage != null) {
                oldImage.dispose();
            }
            if (image != null && !image.isDisposed() && origin != null) {
                this.viewer.setImage(image, (double)origin.x, (double)origin.y);
            } else {
                this.viewer.setImage(image);
            }
            if (this.viewer.getRatio() > 1.0) {
                this.viewer.changeRatio(1.0);
            }
            this.viewer.setTitle(state.getTitle(image, largeImage));
            this.viewer.setTitlePlacement(state.getTitlePlacement());
            state.setColor(this.viewer.getControl());
            this.updateStatus();
            this.initPreviewImageRatio();
        }

        private void initPreviewImageRatio() {
            if (this.viewer.getImage() != null && !this.viewer.getImage().isDisposed()) {
                double heightRatio;
                double widthRatio = (double)this.viewer.getPrefWidth() / (double)this.viewer.getImage().getBounds().width;
                double ratio = widthRatio < (heightRatio = (double)this.viewer.getPrefHeight() / (double)this.viewer.getImage().getBounds().height) ? widthRatio : heightRatio;
                this.viewer.changeRatio(ratio);
            }
        }

        private void cancel() {
            if (this.generatePreviewJob != null) {
                this.generatePreviewJob.cancel();
                this.generatePreviewJob = null;
            }
        }

        private class GeneratePreviewJob
        extends Job {
            private Display display;

            public GeneratePreviewJob(ImageFormat format, Display display) {
                super(NLS.bind((String)WizardMessages.ImageExportPage_GeneratePreview_jobName, (Object)format.getName()));
                this.display = display;
            }

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(null, 100);
                monitor.worked(50);
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        ImageExportPage.this.asyncUpdateViewer(GeneratePreviewJob.this.display, null, PreviewState.Showing, false, null);
                        GanttImageCreator exporter = ExportToImageWizard.this.getImageCreator(GeneratePreviewJob.this.display);
                        exporter.releaseResource();
                        if (exporter.isImageLarge(50000000)) {
                            ImageExportPage.this.asyncUpdateViewer(GeneratePreviewJob.this.display, null, PreviewState.Error, false, null);
                        } else {
                            Image previewImage = exporter.createCutImage();
                            ImageExportPage.this.asyncUpdateViewer(GeneratePreviewJob.this.display, previewImage, PreviewState.Showing, false, null);
                        }
                    }
                });
                monitor.worked(50);
                if (ImageExportPage.this.generatePreviewJob == this) {
                    ImageExportPage.this.generatePreviewJob = null;
                }
                monitor.done();
                return new Status(0, "org.xmind.ui.gantt", WizardMessages.ImageExportPage_GeneratePreview_Completed);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PreviewState {
        Showing(null, 16, 132096){

            public String getTitle(Image image, boolean largeImage) {
                if (image == null || image.isDisposed()) {
                    return super.getTitle(image, largeImage);
                }
                Rectangle r = image.getBounds();
                return String.format("%d x %d", r.width, r.height);
            }
        }
        ,
        Generating(WizardMessages.ImageExportPage_GeneratingPreview, 16, 0),
        Error(WizardMessages.ImageExportPage_FailedToGeneratePreview, 4, 0){

            public String getTitle(Image image, boolean largeImage) {
                return ExportToImageWizard.makeErrorMessage(super.getTitle(image, largeImage), largeImage);
            }
        };

        private int colorId;
        private String title;
        private int titlePlacement;

        private PreviewState(String title, int colorId, int titlePlacement) {
            this.title = title;
            this.colorId = colorId;
            this.titlePlacement = titlePlacement;
        }

        public String getTitle(Image image, boolean largeImage) {
            return this.title;
        }

        public void setColor(Control control) {
            control.setForeground(control.getDisplay().getSystemColor(this.colorId));
        }

        public int getTitlePlacement() {
            return this.titlePlacement;
        }
    }
}

