/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.evernote.signin;

import com.evernote.clients.UserStoreClient;
import java.util.Properties;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.evernote.EvernoteStore;
import org.xmind.ui.evernote.signin.Evernote;
import org.xmind.ui.evernote.signin.IEvernoteAccount;
import org.xmind.ui.internal.evernote.signin.InternalEvernote;
import org.xmind.ui.internal.evernote.signin.SignInJob;

public class EvernoteAuthenticator {
    private SignInJob job = null;

    public IEvernoteAccount signIn() {
        IEvernoteAccount account = Evernote.getAccountInfo();
        if (account != null) {
            return account;
        }
        Display display = Display.getCurrent();
        this.job = new SignInJob();
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (EvernoteAuthenticator.this.job == event.getJob()) {
                    EvernoteAuthenticator.this.authenticationChanged(EvernoteAuthenticator.this.job.getData());
                    EvernoteAuthenticator.this.job = null;
                }
            }
        });
        this.job.setSystem(true);
        this.job.schedule();
        this.block(display);
        return Evernote.getAccountInfo();
    }

    private void authenticationChanged(Properties data) {
        if (data == null) {
            InternalEvernote.getInstance().getAccountStore().signedOut();
        } else {
            this.authenticationChanged(data.getProperty("token"), data.getProperty("username"), data.getProperty("serviceType"));
        }
    }

    private void authenticationChanged(String token, String username, String acceptLanguage) {
        if (!(token == null || "".equals(token) || username == null || "".equals(username) || acceptLanguage == null || "".equals(acceptLanguage))) {
            InternalEvernote.getInstance().getAccountStore().signedIn(token, username, acceptLanguage);
        } else if (token == null && username == null) {
            InternalEvernote.getInstance().getAccountStore().signedOut();
        }
    }

    private void block(Display display) {
        while (this.job != null) {
            if (display == null) {
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void signOut() {
        IEvernoteAccount account = Evernote.getAccountInfo();
        if (account != null) {
            EvernoteStore evernoteStore = new EvernoteStore(account);
            try {
                UserStoreClient userStore = evernoteStore.getUserStore();
                userStore.revokeLongSession();
            }
            catch (Exception exception) {}
        }
        this.authenticationChanged(null, null, null);
    }
}

