/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.ISelectionSupport;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.mindmap.IIconTipPart;
import org.xmind.ui.mindmap.ITopicPart;

public class PresentationViewer
extends MindMapViewer {
    public static final Object LAYER_MENU = "menu layer";

    protected Control internalCreateControl(Composite parent, int style) {
        FigureCanvas canvas = new FigureCanvas(parent, style, this.getLightweightSystem());
        canvas.setViewport(this.getViewport());
        this.addHorizontalScrollSupport(canvas);
        return canvas;
    }

    private void addHorizontalScrollSupport(final FigureCanvas canvas) {
        if (Util.isWindows()) {
            canvas.addListener(38, new Listener(){

                public void handleEvent(Event event) {
                    if (!canvas.isDisposed()) {
                        int offset = event.count;
                        offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                        Point viewLocation = canvas.getViewport().getViewLocation();
                        canvas.getViewport().setHorizontalLocation(viewLocation.x + offset);
                    }
                }
            });
        }
    }

    protected ISelectionSupport createSelectionSupport() {
        return new PresentationSelectionSupport();
    }

    public void center(int x, int y) {
        Rectangle clientArea = this.getViewport().getClientArea();
        this.scrollTo(x - clientArea.width / 2, y - clientArea.height / 2);
    }

    public void setInput(Object input) {
        super.setInput(input);
    }

    protected void handleDispose(DisposeEvent e) {
        super.handleDispose(e);
    }

    protected class PresentationSelectionSupport
    extends MindMapViewer.MindMapSelectionSupport {
        protected PresentationSelectionSupport() {
            super((MindMapViewer)PresentationViewer.this);
        }

        public boolean isSelectable(IPart p) {
            return p instanceof ITopicPart || p instanceof IIconTipPart;
        }
    }
}

