/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xmind.core.internal.sharing.AbstractSharedMap;
import org.xmind.core.internal.sharing.Base64;
import org.xmind.core.internal.sharing.LocalNetworkSharing;
import org.xmind.core.sharing.ILocalSharedMap;
import org.xmind.core.sharing.ISharedLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSharedMap
extends AbstractSharedMap
implements ILocalSharedMap {
    private String path;
    private String encodedThumbnailData;
    private long addedTime = 0L;
    private List<String> receiverIDs = new ArrayList<String>();

    public LocalSharedMap(ISharedLibrary library, String id) {
        super(library, id);
    }

    public void setResourcePath(String path) {
        this.path = path;
        File file = new File(path);
        String name = file.getName();
        int extIndex = name.lastIndexOf(46);
        if (extIndex >= 0) {
            name = name.substring(0, extIndex);
        }
        this.setResourceName(name);
        this.setMissing(!file.exists());
    }

    @Override
    public String getResourcePath() {
        return this.path;
    }

    public void setEncodedThumbnailData(String data) {
        if (data == null || "".equals(data)) {
            this.encodedThumbnailData = null;
            super.setThumbnailData(null);
        } else {
            this.encodedThumbnailData = data;
            super.setThumbnailData(Base64.base64ToByteArray(data));
        }
    }

    @Override
    public void setThumbnailData(byte[] data) {
        if (data != null && data.length == 0) {
            data = null;
        }
        super.setThumbnailData(data);
        this.encodedThumbnailData = data == null ? null : Base64.byteArrayToBase64(data);
    }

    public String getEncodedThumbnailData() {
        return this.encodedThumbnailData == null ? "" : this.encodedThumbnailData;
    }

    @Override
    public long getAddedTime() {
        return this.addedTime;
    }

    public void setAddedTime(long time) {
        this.addedTime = time;
    }

    @Override
    public InputStream getResourceAsStream(IProgressMonitor progress) {
        String path = this.getResourcePath();
        if (path == null) {
            return null;
        }
        progress.beginTask(null, 1);
        try {
            FileInputStream fileInputStream = new FileInputStream(path);
            return fileInputStream;
        }
        catch (IOException e) {
            LocalNetworkSharing.log("Failed to load shared map content from local file: " + path, e);
            return null;
        }
        finally {
            progress.done();
        }
    }

    public void addReceiver(String receiverID) {
        this.receiverIDs.add(receiverID);
    }

    public void addReceivers(List<String> receiverIDs) {
        this.receiverIDs.addAll(receiverIDs);
    }

    @Override
    public List<String> getReceiverIDs() {
        return this.receiverIDs;
    }

    @Override
    public boolean hasAccessRight(String remoteID) {
        boolean isContact = LocalNetworkSharing.getDefault().getSharingService().getContactManager().isContact(remoteID);
        if (remoteID == null) {
            return true;
        }
        if (!isContact) {
            return false;
        }
        return this.receiverIDs.isEmpty() || this.receiverIDs.contains(remoteID);
    }

    @Override
    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalSharedMap)) {
            return false;
        }
        LocalSharedMap that = (LocalSharedMap)obj;
        return this.getID().equals(that.getID());
    }

    public String toString() {
        return "LocalSharedMap(" + this.getResourcePath() + "@" + this.getID() + ")";
    }
}

