/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.ui.internal.e4handlers;

import net.xmind.core.IAccount;
import net.xmind.signin.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class SignOutHandler {
    public void execute(IAccount account) {
        if (account == null) {
            return;
        }
        SignOutHandler.signOut(account);
    }

    public static final void signOut(final IAccount account) {
        Job job = new Job(Messages.SignOutHandler_signOut_jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    account.unauthenticate(monitor);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    return new Status(2, "net.xmind.signin", "Failed to sign out", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.setUser(false);
        job.schedule();
    }
}

