/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.css;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.eclipse.e4.ui.css.swt.dom.CTabFolderElement;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.cathy.internal.css.ICTabFolderRendering;

public class CathyCTabFolderRendering
extends CTabFolderRenderer
implements ICTabFolderRendering {
    private static final String CONTAINS_TOOLBAR = "CathyCTabFolderRendering.containsToolbar";
    static final int LEFT_TOP = 0;
    static final int LEFT_BOTTOM = 1;
    static final int RIGHT_TOP = 2;
    static final int RIGHT_BOTTOM = 3;
    static final int SIDE_DROP_WIDTH = 3;
    static final int BOTTOM_DROP_WIDTH = 4;
    static final int OUTER_KEYLINE = 1;
    static final int INNER_KEYLINE = 0;
    static final int TOP_KEYLINE = 0;
    static final int ITEM_TOP_MARGIN = 2;
    static final int ITEM_BOTTOM_MARGIN = 6;
    static final int ITEM_LEFT_MARGIN = 8;
    static final int ITEM_RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final int FLAGS = 9;
    static final String ELLIPSIS = "...";
    static final String E4_TOOLBAR_ACTIVE_IMAGE = "org.eclipse.e4.renderer.toolbar_background_active_image";
    static final String E4_TOOLBAR_INACTIVE_IMAGE = "org.eclipse.e4.renderer.toolbar_background_inactive_image";
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_SIZE = 16;
    static final RGB CLOSE_FILL = new RGB(252, 160, 160);
    private Color closeFillColor;
    int[] shape;
    Image shadowImage;
    Image toolbarActiveImage;
    Image toolbarInactiveImage;
    int cornerSize = 14;
    boolean shadowEnabled = true;
    Color shadowColor;
    Color outerKeyline;
    Color innerKeyline;
    Color[] activeToolbar;
    int[] activePercents;
    Color[] inactiveToolbar;
    int[] inactivePercents;
    boolean active;
    Color[] selectedTabFillColors;
    int[] selectedTabFillPercents;
    Color[] selectedTabAreaColors;
    int[] selectedTabAreaPercents;
    Color[] unselectedTabsColors;
    int[] unselectedTabsPercents;
    Color[] hoverTabColors;
    int[] hoverTabPercents;
    Color tabOutlineColor;
    int paddingLeft = 2;
    int paddingRight = 2;
    int paddingTop = 2;
    int paddingBottom = 2;
    private CTabFolderRendererWrapper rendererWrapper;
    private CTabFolderWrapper parentWrapper;
    private boolean textVisible = true;
    private boolean imageVisible = true;
    private boolean outerBorderVisible = true;
    private boolean innerBorderVisible = true;
    private boolean unselectedTabsBackgroundVisible = true;
    private Image maxImage;
    private Image minImage;
    private Image closeImage;
    private Image closeHoverImage;
    private int[] tabArea;
    private boolean hoverBorderVisible = false;
    private boolean nothingToRender = false;

    @Inject
    public CathyCTabFolderRendering(CTabFolder parent) {
        super(parent);
        this.parentWrapper = new CTabFolderWrapper(parent);
        this.rendererWrapper = new CTabFolderRendererWrapper(this);
    }

    protected Rectangle computeTrim(int part, int state, int x, int y, int width, int height) {
        if (!this.nothingToRender) {
            boolean onBottom = this.isTabOnBottom();
            int borderTop = onBottom ? 1 : 1;
            int borderBottom = onBottom ? 1 : 1;
            int marginWidth = this.parent.marginWidth;
            int marginHeight = this.parent.marginHeight;
            int sideDropWidth = this.shadowEnabled ? 3 : 0;
            int bottomDropWidth = this.shadowEnabled ? 4 : 0;
            int headerBorderBottom = this.outerBorderVisible ? 1 : 0;
            switch (part) {
                case -1: {
                    if (state == 4) {
                        x = x - this.paddingLeft - sideDropWidth - 1 - marginWidth;
                        int tabHeight = this.parent.getTabHeight() + 1;
                        y = onBottom ? y - this.paddingTop - marginHeight - borderTop - bottomDropWidth : y - this.paddingTop - marginHeight - tabHeight - borderTop - headerBorderBottom - bottomDropWidth;
                        width = 2 + this.paddingLeft + this.paddingRight + 2 * sideDropWidth + 2 * marginWidth;
                        height += this.paddingTop + this.paddingBottom + bottomDropWidth;
                        height += tabHeight + headerBorderBottom + borderBottom + borderTop;
                        break;
                    }
                    x = x - marginWidth - 1 - 0 - sideDropWidth - this.cornerSize / 2 - this.paddingLeft;
                    width = width + 2 + 0 + 2 * marginWidth + 2 * sideDropWidth + this.cornerSize + this.paddingRight + this.paddingLeft;
                    int tabHeight = this.parent.getTabHeight() + 1;
                    if (this.parent.getMinimized()) {
                        y = onBottom ? y - borderTop - 5 : y - tabHeight - borderTop - 5;
                        height = borderTop + borderBottom + tabHeight;
                        break;
                    }
                    y = onBottom ? y - marginHeight - borderTop - this.paddingTop - bottomDropWidth : y - marginHeight - tabHeight - borderTop - this.paddingTop - headerBorderBottom - bottomDropWidth;
                    height = height + borderBottom + borderTop + 2 * marginHeight + tabHeight + headerBorderBottom + bottomDropWidth + this.paddingTop + this.paddingBottom;
                    break;
                }
                case -2: {
                    x = x - 1 - marginWidth - sideDropWidth;
                    width = width + 2 + 2 * marginWidth + 2 * sideDropWidth;
                    y = y - borderTop - marginHeight;
                    break;
                }
                case -3: {
                    x = x - 0 - 1 - sideDropWidth - this.cornerSize / 4;
                    width = width + 2 + 2 * sideDropWidth + this.cornerSize / 2;
                    height = height + borderTop + borderBottom;
                    y -= borderTop;
                    if (!onBottom || !this.shadowEnabled) break;
                    height += 3;
                    break;
                }
                default: {
                    if (part < 0 || part >= this.parent.getItemCount()) break;
                    x -= 8;
                    width = width + 8 + 4 + 1;
                    y -= 2;
                    height = height + 2 + 6;
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    protected Point computeSize(int part, int state, GC gc, int wHint, int hHint) {
        int width = 0;
        int height = 0;
        switch (part) {
            case -2: {
                int fixedTabHeight = this.parentWrapper.getFixedTabHeight();
                if (fixedTabHeight != -1) {
                    height = fixedTabHeight == 0 ? 0 : fixedTabHeight + 1;
                    break;
                }
                CTabItem[] items = this.parent.getItems();
                if (items.length == 0) {
                    height = gc.textExtent((String)"Default", (int)9).y + 2 + 6;
                } else {
                    int i = 0;
                    while (i < items.length) {
                        height = Math.max(height, this.computeSize((int)i, (int)0, (GC)gc, (int)wHint, (int)hHint).y);
                        ++i;
                    }
                }
                height = Math.max(height, this.parent.getTabHeight() + 1);
                gc.dispose();
                break;
            }
            case -8: 
            case -6: 
            case -5: {
                height = 16;
                width = 16;
                break;
            }
            case -7: {
                width = 24;
                height = 16;
                break;
            }
            default: {
                Image image;
                if (part < 0 || part >= this.parent.getItemCount()) break;
                gc.setAdvanced(true);
                CTabItem item = this.parent.getItem(part);
                if (item.isDisposed()) {
                    return new Point(0, 0);
                }
                if ((this.imageVisible || this.shouldDrawImage(item)) && (image = item.getImage()) != null && !image.isDisposed()) {
                    Rectangle bounds = image.getBounds();
                    if ((state & 2) != 0 || this.parent.getUnselectedImageVisible()) {
                        width += bounds.width;
                    }
                    height = bounds.height;
                }
                if (this.textVisible) {
                    String text = null;
                    if ((state & 0x1000000) != 0) {
                        int minChars = this.parent.getMinimumCharacters();
                        String string = text = minChars == 0 ? null : item.getText();
                        if (text != null && text.length() > minChars) {
                            int end;
                            if (this.useEllipse()) {
                                end = minChars < ELLIPSIS.length() + 1 ? minChars : minChars - ELLIPSIS.length();
                                text = text.substring(0, end);
                                if (minChars > ELLIPSIS.length() + 1) {
                                    text = String.valueOf(text) + ELLIPSIS;
                                }
                            } else {
                                end = minChars;
                                text = text.substring(0, end);
                            }
                        }
                    } else {
                        text = item.getText();
                    }
                    if (text != null) {
                        if (width > 0) {
                            width += 4;
                        }
                        if (item.getFont() == null) {
                            Point size = gc.textExtent(text, 9);
                            width += size.x;
                            height = Math.max(height, size.y);
                        } else {
                            Font gcFont = gc.getFont();
                            gc.setFont(item.getFont());
                            Point size = gc.textExtent(text, 9);
                            width += size.x;
                            height = Math.max(height, size.y);
                            gc.setFont(gcFont);
                        }
                    }
                }
                if (!this.parentWrapper.isShowClose() && !item.getShowClose() || (state & 2) == 0 && !this.parent.getUnselectedCloseVisible()) break;
                if (width > 0) {
                    width += 4;
                }
                width += this.computeSize((int)-8, (int)0, (GC)gc, (int)-1, (int)-1).x;
            }
        }
        Rectangle trim = this.computeTrim(part, state, 0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    private boolean useEllipse() {
        return this.parent.getSimple();
    }

    private Color getCloseFillColor() {
        if (this.closeFillColor == null) {
            this.closeFillColor = new Color((Device)this.parent.getDisplay(), CLOSE_FILL);
        }
        return this.closeFillColor;
    }

    protected void dispose() {
        if (this.shadowImage != null && !this.shadowImage.isDisposed()) {
            this.shadowImage.dispose();
            this.shadowImage = null;
        }
        if (this.closeFillColor != null) {
            this.closeFillColor.dispose();
            this.closeFillColor = null;
        }
        super.dispose();
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        if (this.nothingToRender) {
            return;
        }
        switch (part) {
            case -4: {
                this.drawCustomBackground(gc, bounds, state);
                return;
            }
            case -1: {
                this.drawTabBody(gc, bounds, state);
                return;
            }
            case -2: {
                this.drawTabHeader(gc, bounds, state);
                return;
            }
            case -5: {
                if (this.maxImage == null) break;
                this.drawMaximizeButton(gc, bounds, state);
                return;
            }
            case -6: {
                if (this.minImage == null) break;
                this.drawMinimizeButton(gc, bounds, state);
                return;
            }
            case -8: {
                if (this.closeImage == null) break;
                this.drawCloseButton(gc, bounds, state);
                return;
            }
            default: {
                if (part < 0 || part >= this.parent.getItemCount()) break;
                gc.setAdvanced(true);
                if (bounds.width == 0 || bounds.height == 0) {
                    return;
                }
                if ((state & 2) != 0) {
                    this.drawSelectedTab(part, gc, bounds, state);
                    if (((state &= 0xFFFFFFF7) & 2) != 0) {
                        this.toDrawTab(true, part, gc, bounds, state);
                    }
                } else {
                    this.drawUnselectedTab(part, gc, bounds, state);
                    if ((state & 0x20) == 0 && !this.active) {
                        gc.setAlpha(127);
                        this.toDrawTab(false, part, gc, bounds, state &= 0xFFFFFFF7);
                        gc.setAlpha(255);
                    } else {
                        this.toDrawTab(false, part, gc, bounds, state &= 0xFFFFFFF7);
                    }
                }
                return;
            }
        }
        super.draw(part, state, bounds, gc);
    }

    private void drawCloseButton(GC gc, Rectangle bounds, int state) {
        Image hoverImage = this.closeHoverImage == null ? this.closeImage : this.closeHoverImage;
        switch (state & 0x2A) {
            case 0: {
                gc.drawImage(this.closeImage, bounds.x, bounds.y);
                break;
            }
            case 32: {
                gc.drawImage(hoverImage, bounds.x, bounds.y);
                break;
            }
            case 2: {
                gc.drawImage(hoverImage, bounds.x + 1, bounds.y + 1);
                break;
            }
        }
    }

    private void drawMinimizeButton(GC gc, Rectangle bounds, int state) {
        gc.drawImage(this.minImage, bounds.x, bounds.y);
    }

    private void drawMaximizeButton(GC gc, Rectangle bounds, int state) {
        gc.drawImage(this.maxImage, bounds.x, bounds.y);
    }

    void drawTabHeader(GC gc, Rectangle bounds, int state) {
        boolean onBottom = this.parent.getTabPosition() == 1024;
        Region clipping = new Region();
        gc.getClipping(clipping);
        Region region = new Region();
        region.add(this.shape);
        region.intersect(clipping);
        gc.setClipping(region);
        int header = this.shadowEnabled ? (onBottom ? 6 : 3) : 1;
        Rectangle trim = this.computeTrim(-2, state, 0, 0, 0, 0);
        trim.width = bounds.width - trim.width;
        trim.height = this.computeSize((int)-2, (int)state, (GC)gc, (int)0, (int)0).y;
        trim.x = -trim.x;
        trim.y = onBottom ? bounds.height - this.parent.getTabHeight() - 1 - header : -trim.y;
        this.draw(-4, 0, trim, gc);
        gc.setClipping(clipping);
        clipping.dispose();
        region.dispose();
        if (this.outerKeyline == null) {
            this.outerKeyline = gc.getDevice().getSystemColor(2);
        }
        gc.setForeground(this.outerKeyline);
        if (this.outerBorderVisible) {
            gc.drawPolyline(this.tabArea);
            gc.drawLine(trim.x, trim.y + trim.height, trim.x + trim.width, trim.y + trim.height);
        }
    }

    void generateTabArea(Rectangle bounds) {
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int delta = 2 + marginWidth * 2;
        int width = bounds.width - delta;
        int height = Math.max(this.parent.getTabHeight() + 0 + 1, bounds.height - (1 + marginHeight * 2));
        int circX = bounds.x + radius + delta / 2;
        int circY = bounds.y + radius;
        index = 0;
        int[] ltt = new int[]{bounds.x + delta / 2, bounds.y + this.parent.getTabHeight() + delta};
        System.arraycopy(ltt, 0, points, index, ltt.length);
        int[] lbb = CathyCTabFolderRendering.drawCircle(circX, circY + height - radius * 2, radius, 1);
        System.arraycopy(lbb, 0, points, index += ltt.length, lbb.length);
        int[] rb = CathyCTabFolderRendering.drawCircle(circX + width - radius * 2, circY + height - radius * 2, radius, 3);
        System.arraycopy(rb, 0, points, index += lbb.length, rb.length);
        int[] rt = new int[]{bounds.x + delta / 2 + width, bounds.y + this.parent.getTabHeight() + delta};
        System.arraycopy(rt, 0, points, index += rb.length, rt.length);
        int[] tempPoints = new int[index += rt.length];
        System.arraycopy(points, 0, tempPoints, 0, index);
        this.tabArea = tempPoints;
    }

    void drawTabBody(GC gc, Rectangle bounds, int state) {
        this.generateTabArea(bounds);
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int delta = 2 + marginWidth * 2;
        int width = bounds.width - delta;
        int height = Math.max(this.parent.getTabHeight() + 0 + 1, bounds.height - (1 + marginHeight * 2));
        int circX = bounds.x + radius + delta / 2;
        int circY = bounds.y + radius;
        index = 0;
        int[] ltt = CathyCTabFolderRendering.drawCircle(circX, circY, radius, 0);
        System.arraycopy(ltt, 0, points, index, ltt.length);
        int[] lbb = CathyCTabFolderRendering.drawCircle(circX, circY + height - radius * 2, radius, 1);
        System.arraycopy(lbb, 0, points, index += ltt.length, lbb.length);
        int[] rb = CathyCTabFolderRendering.drawCircle(circX + width - radius * 2, circY + height - radius * 2, radius, 3);
        System.arraycopy(rb, 0, points, index += lbb.length, rb.length);
        int[] rt = CathyCTabFolderRendering.drawCircle(circX + width - radius * 2, circY, radius, 2);
        System.arraycopy(rt, 0, points, index += rb.length, rt.length);
        index += rt.length;
        points[index++] = circX;
        points[index++] = circY - radius;
        int[] tempPoints = new int[index];
        System.arraycopy(points, 0, tempPoints, 0, index);
        Region r = new Region();
        r.add(bounds);
        r.subtract(tempPoints);
        gc.setBackground(this.parent.getParent().getBackground());
        Display display = this.parent.getDisplay();
        Region clipping = new Region();
        gc.getClipping(clipping);
        r.intersect(clipping);
        gc.setClipping(r);
        Rectangle mappedBounds = display.map((Control)this.parent, (Control)this.parent.getParent(), bounds);
        this.parent.getParent().drawBackground(gc, bounds.x, bounds.y, bounds.width, bounds.height, mappedBounds.x, mappedBounds.y);
        if (this.shadowEnabled) {
            this.drawShadow(display, bounds, gc);
        }
        gc.setClipping(clipping);
        clipping.dispose();
        r.dispose();
        this.shape = tempPoints;
    }

    void drawSelectedTab(int itemIndex, GC gc, Rectangle bounds, int state) {
        int selectionY2;
        int selectionX2;
        int[] rt;
        int[] ltt;
        int selectionY1;
        int selectionX1;
        int bottomY;
        if (this.parent.getSingle() && this.parent.getItem(itemIndex).isShowing()) {
            return;
        }
        boolean onBottom = this.parent.getTabPosition() == 1024;
        int header = this.shadowEnabled ? 2 : 0;
        int width = bounds.width;
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int circX = bounds.x + radius;
        int circY = onBottom ? bounds.y + bounds.height - header - radius : bounds.y + radius;
        int n = bottomY = onBottom ? bounds.y - header : bounds.y + bounds.height;
        if (itemIndex == 0 && bounds.x == -this.computeTrim((int)-2, (int)0, (int)0, (int)0, (int)0, (int)0).x) {
            points[index++] = selectionX1 = circX - radius;
            points[index++] = selectionY1 = bottomY;
        } else {
            if (this.active) {
                points[index++] = this.shadowEnabled ? 3 : 1;
                points[index++] = bottomY;
            }
            points[index++] = selectionX1 = bounds.x;
            points[index++] = selectionY1 = bottomY;
        }
        int startX = -1;
        int endX = -1;
        if (!onBottom) {
            ltt = CathyCTabFolderRendering.drawCircle(circX, circY, radius, 0);
            startX = ltt[6];
            int i = 0;
            while (i < ltt.length / 2) {
                int tmp = ltt[i];
                ltt[i] = ltt[ltt.length - i - 2];
                ltt[ltt.length - i - 2] = tmp;
                tmp = ltt[i + 1];
                ltt[i + 1] = ltt[ltt.length - i - 1];
                ltt[ltt.length - i - 1] = tmp;
                i += 2;
            }
            System.arraycopy(ltt, 0, points, index, ltt.length);
            index += ltt.length;
            rt = CathyCTabFolderRendering.drawCircle(circX + width - radius * 2, circY, radius, 2);
            endX = rt[rt.length - 4];
            int i2 = 0;
            while (i2 < rt.length / 2) {
                int tmp = rt[i2];
                rt[i2] = rt[rt.length - i2 - 2];
                rt[rt.length - i2 - 2] = tmp;
                tmp = rt[i2 + 1];
                rt[i2 + 1] = rt[rt.length - i2 - 1];
                rt[rt.length - i2 - 1] = tmp;
                i2 += 2;
            }
            System.arraycopy(rt, 0, points, index, rt.length);
            index += rt.length;
            points[index++] = selectionX2 = bounds.width + circX - radius;
            points[index++] = selectionY2 = bottomY;
        } else {
            ltt = CathyCTabFolderRendering.drawCircle(circX, circY, radius, 1);
            startX = ltt[6];
            System.arraycopy(ltt, 0, points, index, ltt.length);
            rt = CathyCTabFolderRendering.drawCircle(circX + width - radius * 2, circY, radius, 3);
            endX = rt[rt.length - 4];
            System.arraycopy(rt, 0, points, index += ltt.length, rt.length);
            index += rt.length;
            points[index++] = selectionX2 = bounds.width + circX - radius;
            points[index++] = selectionY2 = bottomY;
        }
        if (this.active) {
            points[index++] = this.parent.getSize().x - (this.shadowEnabled ? 3 : 1);
            points[index++] = bottomY;
        }
        gc.setClipping(bounds.x, onBottom ? bounds.y - header : bounds.y, this.parent.getSize().x - (this.shadowEnabled ? 3 : 1), bounds.y + bounds.height);
        Pattern backgroundPattern = null;
        if (this.selectedTabFillColors == null) {
            this.setSelectedTabFill(gc.getDevice().getSystemColor(1));
        }
        if (this.selectedTabFillColors.length == 1) {
            gc.setBackground(this.selectedTabFillColors[0]);
            gc.setForeground(this.selectedTabFillColors[0]);
        } else if (!onBottom && this.selectedTabFillColors.length == 2) {
            backgroundPattern = new Pattern(gc.getDevice(), 0.0f, 0.0f, 0.0f, (float)(bounds.height + 1), this.selectedTabFillColors[0], this.selectedTabFillColors[1]);
            gc.setBackgroundPattern(backgroundPattern);
            gc.setForeground(this.selectedTabFillColors[1]);
        }
        int[] tmpPoints = new int[index];
        System.arraycopy(points, 0, tmpPoints, 0, index);
        gc.fillPolygon(tmpPoints);
        gc.drawLine(selectionX1, selectionY1, selectionX2, selectionY2);
        gc.setClipping(bounds.x - 1, onBottom ? bounds.y - header : bounds.y - 1, this.parent.getSize().x - (this.shadowEnabled ? 3 : 1), bounds.y + bounds.height);
        if (this.innerBorderVisible) {
            if (this.innerKeyline == null) {
                this.innerKeyline = gc.getDevice().getSystemColor(2);
            }
            gc.setForeground(this.innerKeyline);
            gc.drawPolyline(tmpPoints);
        }
        Rectangle rect = null;
        gc.setClipping(rect);
        if (this.outerBorderVisible && !onBottom) {
            if (this.outerKeyline == null) {
                this.outerKeyline = gc.getDevice().getSystemColor(2);
            }
            gc.setForeground(this.outerKeyline);
            gc.drawLine(startX + 2, 1, endX - 1, 1);
        }
        if (backgroundPattern != null) {
            backgroundPattern.dispose();
        }
    }

    private boolean isTabOnBottom() {
        return this.parent.getTabPosition() == 1024;
    }

    private String getShortenedText(GC gc, String text, int width) {
        return this.useEllipse() ? this.getShortenedText(gc, text, width, ELLIPSIS) : this.getShortenedText(gc, text, width, "");
    }

    private String getShortenedText(GC gc, String text, int width, String ellipses) {
        if (gc.textExtent((String)text, (int)9).x <= width) {
            return text;
        }
        int ellipseWidth = gc.textExtent((String)ellipses, (int)9).x;
        int length = text.length();
        TextLayout layout = new TextLayout((Device)this.parent.getDisplay());
        layout.setText(text);
        int end = layout.getPreviousOffset(length, 2);
        while (end > 0) {
            text = text.substring(0, end);
            int l = gc.textExtent((String)text, (int)9).x;
            if (l + ellipseWidth <= width) break;
            end = layout.getPreviousOffset(end, 2);
        }
        layout.dispose();
        return end == 0 ? text.substring(0, 1) : String.valueOf(text) + ellipses;
    }

    private void toDrawTab(boolean selected, int itemIndex, GC gc, Rectangle bounds, int state) {
        CTabItem item = this.parent.getItem(itemIndex);
        int x = bounds.x;
        int y = bounds.y;
        int height = bounds.height;
        int width = bounds.width;
        int rightEdge = Math.min(x + width, this.parentWrapper.getRightItemEdge(gc));
        if ((state & 0x10) != 0) {
            Image image;
            CTabItemWrapper itemWrapper = new CTabItemWrapper(item);
            Rectangle itemCloseRect = itemWrapper.getCloseRect();
            itemCloseRect = new Rectangle(itemCloseRect.x, itemCloseRect.y, itemCloseRect.width, itemCloseRect.height);
            Rectangle trim = this.computeTrim(itemIndex, 0, 0, 0, 0, 0);
            int xDraw = x - trim.x;
            if (this.parent.getSingle() && (this.parentWrapper.isShowClose() || item.getShowClose())) {
                xDraw += itemWrapper.getCloseRect().width;
            }
            if ((this.imageVisible || this.shouldDrawImage(item)) && (image = item.getImage()) != null && !image.isDisposed()) {
                Rectangle imageBounds = image.getBounds();
                int maxImageWidth = rightEdge - xDraw - (trim.width + trim.x);
                if (!this.parent.getSingle() && itemCloseRect.width > 0) {
                    maxImageWidth -= itemCloseRect.width + 4;
                }
                if (imageBounds.width < maxImageWidth) {
                    int imageX = xDraw;
                    int imageY = y + (height - imageBounds.height) / 2;
                    gc.drawImage(image, imageX, imageY += this.isTabOnBottom() ? -1 : 1);
                    xDraw += imageBounds.width + 4;
                }
            }
            if (this.textVisible) {
                int textWidth = rightEdge - xDraw - (trim.width + trim.x);
                if (!this.parent.getSingle() && itemCloseRect.width > 0) {
                    textWidth -= itemCloseRect.width + 4;
                }
                if (textWidth > 0) {
                    Font gcFont = gc.getFont();
                    gc.setFont(item.getFont() == null ? this.parent.getFont() : item.getFont());
                    if (itemWrapper.getShortenedText() == null || itemWrapper.getShortenedTextWidth() != textWidth) {
                        itemWrapper.setShortenedText(this.getShortenedText(gc, item.getText(), textWidth));
                        itemWrapper.setShortenedTextWidth(textWidth);
                    }
                    Point extent = gc.textExtent(itemWrapper.getShortenedText(), 9);
                    int textY = y + (height - extent.y) / 2;
                    int n = this.isTabOnBottom() ? -1 : 1;
                    gc.setForeground(selected ? this.parent.getSelectionForeground() : this.parent.getForeground());
                    gc.drawText(itemWrapper.getShortenedText(), xDraw, textY += n, 9);
                    gc.setFont(gcFont);
                    if (selected && this.parent.isFocusControl()) {
                        Display display = this.parent.getDisplay();
                        if (this.parent.getSimple() || this.parent.getSingle()) {
                            gc.setBackground(display.getSystemColor(2));
                            gc.setForeground(display.getSystemColor(1));
                            gc.drawFocus(xDraw - 1, textY - 1, extent.x + 2, extent.y + 2);
                        } else {
                            gc.setForeground(display.getSystemColor(17));
                            gc.drawLine(xDraw, textY + extent.y + 1, xDraw + extent.x + 1, textY + extent.y + 1);
                        }
                    }
                }
            }
            if (this.parentWrapper.isShowClose() || item.getShowClose()) {
                if (this.closeImage != null) {
                    this.drawCloseButton(gc, itemCloseRect, itemWrapper.getCloseImageState());
                } else {
                    this.drawClose2(gc, itemCloseRect, itemWrapper.getCloseImageState());
                }
            }
        }
    }

    void drawClose2(GC gc, Rectangle closeRect, int closeImageState) {
        if (closeRect.width == 0 || closeRect.height == 0) {
            return;
        }
        Display display = this.parent.getDisplay();
        int x = closeRect.x + Math.max(1, (closeRect.width - 9) / 2);
        int y = closeRect.y + Math.max(1, (closeRect.height - 9) / 2);
        Color closeBorder = display.getSystemColor(17);
        int[] fillShape = new int[]{x + 1, y + 1, x + 3, y + 1, x + 5, y + 3, x + 6, y + 3, x + 8, y + 1, x + 10, y + 1, x + 10, y + 3, x + 8, y + 5, x + 8, y + 6, x + 10, y + 8, x + 10, y + 10, x + 8, y + 10, x + 6, y + 8, x + 5, y + 8, x + 3, y + 10, x + 1, y + 10, x + 1, y + 8, x + 3, y + 6, x + 3, y + 5, x + 1, y + 3};
        int[] drawShape = new int[]{x, y, x + 2, y, x + 4, y + 2, x + 5, y + 2, x + 7, y, x + 9, y, x + 9, y + 2, x + 7, y + 4, x + 7, y + 5, x + 9, y + 7, x + 9, y + 9, x + 7, y + 9, x + 5, y + 7, x + 4, y + 7, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
        switch (closeImageState & 0x2A) {
            case 0: {
                gc.setBackground(display.getSystemColor(1));
                gc.fillPolygon(fillShape);
                gc.setForeground(closeBorder);
                gc.drawPolygon(drawShape);
                break;
            }
            case 32: {
                gc.setBackground(this.getCloseFillColor());
                gc.fillPolygon(fillShape);
                gc.setForeground(closeBorder);
                gc.drawPolygon(drawShape);
                break;
            }
            case 2: {
                gc.setBackground(this.getCloseFillColor());
                gc.fillPolygon(fillShape);
                gc.setForeground(closeBorder);
                gc.drawPolygon(drawShape);
                break;
            }
            case 8: {
                this.rendererWrapper.drawClose(gc, closeRect, closeImageState);
            }
        }
    }

    private boolean shouldDrawImage(CTabItem item) {
        MUIElement element;
        Object model = item.getData("modelElement");
        return model != null && model instanceof MUIElement && (element = (MUIElement)model).getTags().contains("CathyShowImage");
    }

    void drawUnselectedTab(int itemIndex, GC gc, Rectangle bounds, int state) {
        if ((state & 0x20) != 0) {
            int[] rt;
            int[] ltt;
            int header = this.shadowEnabled ? 2 : 0;
            int width = bounds.width;
            boolean onBottom = this.parent.getTabPosition() == 1024;
            int[] points = new int[1024];
            int[] inactive = new int[8];
            int index = 0;
            int inactive_index = 0;
            int radius = this.cornerSize / 2;
            int circX = bounds.x + radius;
            int circY = onBottom ? bounds.y + bounds.height + 1 - header - radius : bounds.y - 1 + radius;
            int bottomY = onBottom ? bounds.y - header : bounds.y + bounds.height;
            int leftIndex = circX;
            if (itemIndex == 0) {
                points[index++] = leftIndex - radius;
                points[index++] = bottomY;
            } else {
                points[index++] = bounds.x;
                points[index++] = bottomY;
            }
            if (!this.active) {
                System.arraycopy(points, 0, inactive, 0, index);
                inactive_index += 2;
            }
            int rightIndex = circX - 1;
            int startX = -1;
            int endX = -1;
            if (!onBottom) {
                ltt = CathyCTabFolderRendering.drawCircle(leftIndex, circY, radius, 0);
                startX = ltt[6];
                int i = 0;
                while (i < ltt.length / 2) {
                    int tmp = ltt[i];
                    ltt[i] = ltt[ltt.length - i - 2];
                    ltt[ltt.length - i - 2] = tmp;
                    tmp = ltt[i + 1];
                    ltt[i + 1] = ltt[ltt.length - i - 1];
                    ltt[ltt.length - i - 1] = tmp;
                    i += 2;
                }
                System.arraycopy(ltt, 0, points, index, ltt.length);
                index += ltt.length;
                if (!this.active) {
                    System.arraycopy(ltt, 0, inactive, inactive_index, 2);
                    inactive_index += 2;
                }
                rt = CathyCTabFolderRendering.drawCircle(rightIndex + width - radius * 2, circY, radius, 2);
                endX = rt[rt.length - 4];
                int i2 = 0;
                while (i2 < rt.length / 2) {
                    int tmp = rt[i2];
                    rt[i2] = rt[rt.length - i2 - 2];
                    rt[rt.length - i2 - 2] = tmp;
                    tmp = rt[i2 + 1];
                    rt[i2 + 1] = rt[rt.length - i2 - 1];
                    rt[rt.length - i2 - 1] = tmp;
                    i2 += 2;
                }
                System.arraycopy(rt, 0, points, index, rt.length);
                index += rt.length;
                if (!this.active) {
                    System.arraycopy(rt, rt.length - 4, inactive, inactive_index, 2);
                    int n = inactive_index;
                    inactive[n] = inactive[n] - 1;
                    inactive_index += 2;
                }
            } else {
                ltt = CathyCTabFolderRendering.drawCircle(leftIndex, circY, radius, 1);
                startX = ltt[6];
                System.arraycopy(ltt, 0, points, index, ltt.length);
                index += ltt.length;
                if (!this.active) {
                    System.arraycopy(ltt, 0, inactive, inactive_index, 2);
                    inactive_index += 2;
                }
                rt = CathyCTabFolderRendering.drawCircle(rightIndex + width - radius * 2, circY, radius, 3);
                endX = rt[rt.length - 4];
                System.arraycopy(rt, 0, points, index, rt.length);
                index += rt.length;
                if (!this.active) {
                    System.arraycopy(rt, rt.length - 4, inactive, inactive_index, 2);
                    int n = inactive_index;
                    inactive[n] = inactive[n] - 1;
                    inactive_index += 2;
                }
            }
            points[index++] = bounds.width + rightIndex - radius;
            points[index++] = bottomY;
            if (!this.active) {
                System.arraycopy(points, index - 2, inactive, inactive_index, 2);
                int n = inactive_index;
                inactive[n] = inactive[n] - 1;
                inactive_index += 2;
            }
            gc.setClipping(points[0], onBottom ? bounds.y - header : bounds.y - 1, this.parent.getSize().x - (this.shadowEnabled ? 3 : 1), bounds.y + bounds.height);
            if (this.hoverTabColors == null) {
                this.hoverTabColors = new Color[]{gc.getDevice().getSystemColor(1)};
                this.hoverTabPercents = new int[]{100};
            }
            gc.setBackground(this.hoverTabColors[0]);
            int[] tmpPoints = new int[index];
            System.arraycopy(points, 0, tmpPoints, 0, index);
            gc.fillPolygon(tmpPoints);
            Color tempBorder = new Color(gc.getDevice(), 182, 188, 204);
            gc.setForeground(tempBorder);
            tempBorder.dispose();
            if (this.hoverBorderVisible) {
                if (this.outerBorderVisible) {
                    if (this.outerKeyline == null) {
                        this.outerKeyline = gc.getDevice().getSystemColor(2);
                    }
                    gc.setForeground(this.outerKeyline);
                    if (this.active) {
                        gc.drawLine(startX, 1, endX, 1);
                    } else {
                        gc.drawLine(inactive[0], inactive[1], inactive[2], inactive[3]);
                        gc.drawLine(inactive[4], inactive[5], inactive[6], inactive[7]);
                    }
                }
                if (this.innerBorderVisible) {
                    if (this.innerKeyline == null) {
                        this.innerKeyline = gc.getDevice().getSystemColor(2);
                    }
                    gc.setForeground(this.innerKeyline);
                    gc.drawPolyline(tmpPoints);
                }
            }
            Rectangle rect = null;
            gc.setClipping(rect);
        }
    }

    static int[] drawCircle(int xC, int yC, int r, int circlePart) {
        int x = 0;
        int y = r;
        int u = 1;
        int v = 2 * r - 1;
        int e = 0;
        int[] points = new int[1024];
        int[] pointsMirror = new int[1024];
        int loop = 0;
        int loopMirror = 0;
        if (r == 0) {
            int i = 0;
            while (i < 4) {
                points[loop++] = xC;
                points[loop++] = yC;
                ++i;
            }
        }
        while (x < y) {
            if (circlePart == 3) {
                points[loop++] = xC + x;
                points[loop++] = yC + y;
            }
            if (circlePart == 2) {
                points[loop++] = xC + y;
                points[loop++] = yC - x;
            }
            if (circlePart == 0) {
                points[loop++] = xC - x;
                points[loop++] = yC - y;
            }
            if (circlePart == 1) {
                points[loop++] = xC - y;
                points[loop++] = yC + x;
            }
            ++x;
            if (v < 2 * (e += (u += 2))) {
                --y;
                e -= v;
                v -= 2;
            }
            if (x > y) break;
            if (circlePart == 3) {
                pointsMirror[loopMirror++] = xC + y;
                pointsMirror[loopMirror++] = yC + x;
            }
            if (circlePart == 2) {
                pointsMirror[loopMirror++] = xC + x;
                pointsMirror[loopMirror++] = yC - y;
            }
            if (circlePart == 0) {
                pointsMirror[loopMirror++] = xC - y;
                pointsMirror[loopMirror++] = yC - x;
            }
            if (circlePart == 1) {
                pointsMirror[loopMirror++] = xC - x;
                pointsMirror[loopMirror++] = yC + y;
            }
            if (loop + 1 <= points.length) continue;
            int length = points.length * 2;
            int[] newPointTable = new int[length];
            int[] newPointTableMirror = new int[length];
            System.arraycopy(points, 0, newPointTable, 0, points.length);
            points = newPointTable;
            System.arraycopy(pointsMirror, 0, newPointTableMirror, 0, pointsMirror.length);
            pointsMirror = newPointTableMirror;
        }
        int[] finalArray = new int[loop + loopMirror];
        System.arraycopy(points, 0, finalArray, 0, loop);
        int i = loopMirror - 1;
        int j = loop;
        while (i > 0) {
            int tempX;
            int tempY = pointsMirror[i];
            finalArray[j] = tempX = pointsMirror[i - 1];
            finalArray[j + 1] = tempY;
            i -= 2;
            j += 2;
        }
        return finalArray;
    }

    static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = CathyCTabFolderRendering.blend(c1.red, c2.red, ratio);
        int g = CathyCTabFolderRendering.blend(c1.green, c2.green, ratio);
        int b = CathyCTabFolderRendering.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    void drawShadow(Display display, Rectangle bounds, GC gc) {
        if (this.shadowImage == null) {
            this.createShadow(display);
        }
        int x = bounds.x;
        int y = bounds.y;
        int SIZE = this.shadowImage.getBounds().width / 3;
        int height = Math.max(bounds.height, SIZE * 2);
        int width = Math.max(bounds.width, SIZE * 2);
        gc.drawImage(this.shadowImage, 0, 0, SIZE, SIZE, 2, 10, SIZE, 20);
        int fillHeight = height - SIZE * 2;
        int fillWidth = width + 5 - SIZE * 2;
        int xFill = 0;
        int i = SIZE;
        while (i < fillHeight) {
            xFill = i;
            gc.drawImage(this.shadowImage, 0, SIZE, SIZE, SIZE, 2, i, SIZE, SIZE);
            i += SIZE;
        }
        gc.drawImage(this.shadowImage, 0, SIZE, SIZE, fillHeight - xFill, 2, xFill + SIZE, SIZE, fillHeight - xFill);
        gc.drawImage(this.shadowImage, 0, 40, 20, 20, 2, y + height - SIZE, 20, 20);
        int yFill = 0;
        int i2 = SIZE;
        while (i2 <= fillWidth) {
            yFill = i2;
            gc.drawImage(this.shadowImage, SIZE, SIZE * 2, SIZE, SIZE, i2, y + height - SIZE, SIZE, SIZE);
            i2 += SIZE;
        }
        gc.drawImage(this.shadowImage, SIZE, SIZE * 2, fillWidth - yFill, SIZE, yFill + SIZE, y + height - SIZE, fillWidth - yFill, SIZE);
        gc.drawImage(this.shadowImage, SIZE * 2, SIZE * 2, SIZE, SIZE, x + width - SIZE - 1, y + height - SIZE, SIZE, SIZE);
        gc.drawImage(this.shadowImage, SIZE * 2, 0, SIZE, SIZE, x + width - SIZE - 1, 10, SIZE, SIZE);
        xFill = 0;
        i2 = SIZE;
        while (i2 < fillHeight) {
            xFill = i2;
            gc.drawImage(this.shadowImage, SIZE * 2, SIZE, SIZE, SIZE, x + width - SIZE - 1, i2, SIZE, SIZE);
            i2 += SIZE;
        }
        gc.drawImage(this.shadowImage, SIZE * 2, SIZE, SIZE, fillHeight - xFill, x + width - SIZE - 1, xFill + SIZE, SIZE, fillHeight - xFill);
    }

    void createShadow(Display display) {
        if (this.shadowImage != null) {
            this.shadowImage.dispose();
            this.shadowImage = null;
        }
        ImageData data = new ImageData(60, 60, 32, new PaletteData(0xFF0000, 65280, 255));
        Image tmpImage = this.shadowImage = new Image((Device)display, data);
        GC gc = new GC((Drawable)tmpImage);
        if (this.shadowColor == null) {
            this.shadowColor = gc.getDevice().getSystemColor(15);
        }
        gc.setBackground(this.shadowColor);
        this.drawTabBody(gc, new Rectangle(0, 0, 60, 60), 0);
        ImageData blured = this.blur(tmpImage, 5, 25);
        this.shadowImage = new Image((Device)display, blured);
        tmpImage.dispose();
        gc.dispose();
    }

    public ImageData blur(Image src, int radius, int sigma) {
        float[] kernel = this.create1DKernel(radius, sigma);
        ImageData imgPixels = src.getImageData();
        int width = imgPixels.width;
        int height = imgPixels.height;
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        int offset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                RGB rgb = imgPixels.palette.getRGB(imgPixels.getPixel(x, y));
                inPixels[offset] = rgb.red == 255 && rgb.green == 255 && rgb.blue == 255 ? rgb.red << 16 | rgb.green << 8 | rgb.blue : imgPixels.getAlpha(x, y) << 24 | rgb.red << 16 | rgb.green << 8 | rgb.blue;
                ++offset;
                ++x;
            }
            ++y;
        }
        this.convolve(kernel, inPixels, outPixels, width, height, true);
        this.convolve(kernel, outPixels, inPixels, height, width, true);
        ImageData dst = new ImageData(imgPixels.width, imgPixels.height, 24, new PaletteData(0xFF0000, 65280, 255));
        dst.setPixels(0, 0, inPixels.length, inPixels, 0);
        offset = 0;
        int y2 = 0;
        while (y2 < height) {
            int x = 0;
            while (x < width) {
                if (inPixels[offset] == -1) {
                    dst.setAlpha(x, y2, 0);
                } else {
                    int a = inPixels[offset] >> 24 & 0xFF;
                    dst.setAlpha(x, y2, a);
                }
                ++offset;
                ++x;
            }
            ++y2;
        }
        return dst;
    }

    private void convolve(float[] kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha) {
        int kernelWidth = kernel.length;
        int kernelMid = kernelWidth / 2;
        int y = 0;
        while (y < height) {
            int index = y;
            int currentLine = y * width;
            int x = 0;
            while (x < width) {
                float a = 0.0f;
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                int k = -kernelMid;
                while (k <= kernelMid) {
                    float val = kernel[k + kernelMid];
                    int xcoord = x + k;
                    if (xcoord < 0) {
                        xcoord = 0;
                    }
                    if (xcoord >= width) {
                        xcoord = width - 1;
                    }
                    int pixel = inPixels[currentLine + xcoord];
                    a += val * (float)(pixel >> 24 & 0xFF);
                    r += val * (float)(pixel >> 16 & 0xFF);
                    g += val * (float)(pixel >> 8 & 0xFF);
                    b += val * (float)(pixel & 0xFF);
                    ++k;
                }
                int ia = alpha ? this.clamp((int)((double)a + 0.5)) : 255;
                int ir = this.clamp((int)((double)r + 0.5));
                int ig = this.clamp((int)((double)g + 0.5));
                int ib = this.clamp((int)((double)b + 0.5));
                outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                index += height;
                ++x;
            }
            ++y;
        }
    }

    private int clamp(int value) {
        if (value > 255) {
            return 255;
        }
        if (value < 0) {
            return 0;
        }
        return value;
    }

    private float[] create1DKernel(int radius, int sigma) {
        int size = radius * 2 + 1;
        float[] kernel = new float[size];
        int radiusSquare = radius * radius;
        float sigmaSquare = 2 * sigma * sigma;
        float piSigma = (float)Math.PI * 2 * (float)sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(piSigma);
        int start = size / 2;
        int index = 0;
        float total = 0.0f;
        int i = -start;
        while (i <= start) {
            float d = i * i;
            kernel[index] = d > (float)radiusSquare ? 0.0f : (float)Math.exp(-d / sigmaSquare) / sqrtSigmaPi2;
            total += kernel[index];
            ++index;
            ++i;
        }
        i = 0;
        while (i < size) {
            int n = i++;
            kernel[n] = kernel[n] / total;
        }
        return kernel;
    }

    public Rectangle getPadding() {
        return new Rectangle(this.paddingTop, this.paddingRight, this.paddingBottom, this.paddingLeft);
    }

    public void setPadding(int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.parent.redraw();
    }

    public void setCornerRadius(int radius) {
        this.cornerSize = radius;
        this.parent.redraw();
    }

    public void setShadowVisible(boolean visible) {
        this.shadowEnabled = visible;
        this.parent.redraw();
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
        this.createShadow(this.parent.getDisplay());
        this.parent.redraw();
    }

    public void setOuterKeyline(Color color) {
        this.outerKeyline = color;
        if (color != null) {
            this.setActive(color.getRed() != 255 || color.getGreen() != 255 || color.getBlue() != 255);
        }
        this.parent.redraw();
    }

    public void setSelectedTabFill(Color color) {
        this.setSelectedTabFill(new Color[]{color}, new int[]{100});
    }

    public void setSelectedTabFill(Color[] colors, int[] percents) {
        this.selectedTabFillColors = colors;
        this.selectedTabFillPercents = percents;
        this.parent.redraw();
    }

    @Override
    public void setSelectedTabAreaColor(Color color) {
        this.setSelectedTabAreaColor(new Color[]{color}, new int[]{100});
    }

    @Override
    public void setSelectedTabAreaColor(Color[] colors, int[] percents) {
        this.selectedTabAreaColors = colors;
        this.selectedTabAreaPercents = percents;
        this.parent.redraw();
    }

    public void setUnselectedTabsColor(Color color) {
        this.setUnselectedTabsColor(new Color[]{color}, new int[]{100});
    }

    public void setUnselectedTabsColor(Color[] colors, int[] percents) {
        this.unselectedTabsColors = colors;
        this.unselectedTabsPercents = percents;
        this.parent.redraw();
    }

    @Override
    public void setUnselectedTabsBackgroundVisible(boolean visible) {
        this.unselectedTabsBackgroundVisible = visible;
        this.parent.redraw();
    }

    public void setUnselectedHotTabsColorBackground(Color color) {
        this.setHoverTabColor(new Color[]{color}, new int[]{100});
    }

    @Override
    public void setHoverTabColor(Color color) {
        this.setHoverTabColor(new Color[]{color}, new int[]{100});
    }

    @Override
    public void setHoverTabColor(Color[] colors, int[] percents) {
        this.hoverTabColors = colors;
        this.hoverTabPercents = percents;
        this.parent.redraw();
    }

    public void setTabOutline(Color color) {
        this.tabOutlineColor = color;
        this.parent.redraw();
    }

    public void setInnerKeyline(Color color) {
        this.innerKeyline = color;
        this.parent.redraw();
    }

    @Override
    public void setTextVisible(boolean visible) {
        this.textVisible = visible;
        this.parent.redraw();
    }

    @Override
    public void setImageVisible(boolean visible) {
        this.imageVisible = visible;
        this.parent.redraw();
    }

    @Override
    public void setOuterBorderVisible(boolean visible) {
        this.outerBorderVisible = visible;
        this.parent.redraw();
    }

    @Override
    public void setInnerBorderVisible(boolean visible) {
        this.innerBorderVisible = visible;
        this.parent.redraw();
    }

    public void setActiveToolbarGradient(Color[] color, int[] percents) {
        this.activeToolbar = color;
        this.activePercents = percents;
    }

    public void setInactiveToolbarGradient(Color[] color, int[] percents) {
        this.inactiveToolbar = color;
        this.inactivePercents = percents;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void setMaximizeImage(Image maxImage) {
        this.maxImage = maxImage;
    }

    @Override
    public void setMinimizeImage(Image minImage) {
        this.minImage = minImage;
    }

    @Override
    public void setCloseImage(Image closeImage) {
        this.closeImage = closeImage;
    }

    @Override
    public void setClsoeHoverImage(Image closeHoverImage) {
        this.closeHoverImage = closeHoverImage;
    }

    @Override
    public void setNoneRender(boolean nothingToRender) {
        this.nothingToRender = nothingToRender;
    }

    private void drawCustomBackground(GC gc, Rectangle bounds, int state) {
        boolean selected = (state & 2) != 0;
        Color defaultBackground = selected ? this.parent.getSelectionBackground() : this.parent.getBackground();
        boolean vertical = selected ? this.parentWrapper.isSelectionGradientVertical() : this.parentWrapper.isGradientVertical();
        Rectangle partHeaderBounds = bounds;
        if (this.unselectedTabsBackgroundVisible) {
            this.drawUnselectedTabBackground(gc, partHeaderBounds, state, vertical, defaultBackground);
        }
        this.drawTabAreaBackground(gc, partHeaderBounds, state, vertical, defaultBackground);
        int borderTop = this.isTabOnBottom() ? 1 : 1;
        int borderBottom = this.isTabOnBottom() ? 1 : 1;
        int bottomDropWidth = this.shadowEnabled ? 4 : 0;
        int sideDropWidth = this.shadowEnabled ? 3 : 0;
        int headerBorderBottom = this.outerBorderVisible ? 1 : 0;
        Rectangle underTabAreaBounds = new Rectangle(partHeaderBounds.x + this.paddingLeft + sideDropWidth, partHeaderBounds.y + partHeaderBounds.height + bottomDropWidth + this.paddingTop + headerBorderBottom, bounds.width - this.paddingLeft - this.paddingRight - 2 * sideDropWidth, this.parent.getBounds().height - partHeaderBounds.height - this.paddingTop - this.paddingBottom - headerBorderBottom - (this.cornerSize / 4 + borderBottom + borderTop) - bottomDropWidth * 2);
        this.drawUnderTabAreaBackground(gc, underTabAreaBounds, state, vertical, defaultBackground);
        this.drawChildrenBackground(partHeaderBounds);
    }

    private void drawUnderTabAreaBackground(GC gc, Rectangle tabAreaBounds, int state, boolean vertical, Color defaultBackground) {
        Color[] underTabAreaColors = new Color[]{gc.getDevice().getSystemColor(1)};
        int[] underTabAreaPercents = new int[]{100};
        this.rendererWrapper.drawBackground(gc, tabAreaBounds.x, tabAreaBounds.y, tabAreaBounds.width, tabAreaBounds.height, defaultBackground, underTabAreaColors, underTabAreaPercents, vertical);
    }

    private void drawUnselectedTabBackground(GC gc, Rectangle partHeaderBounds, int state, boolean vertical, Color defaultBackground) {
        if (this.unselectedTabsColors == null) {
            boolean selected = (state & 2) != 0;
            this.unselectedTabsColors = selected ? this.parentWrapper.getSelectionGradientColors() : this.parentWrapper.getGradientColors();
            int[] nArray = this.unselectedTabsPercents = selected ? this.parentWrapper.getSelectionGradientPercents() : this.parentWrapper.getGradientPercents();
        }
        if (this.unselectedTabsColors == null) {
            this.unselectedTabsColors = new Color[]{gc.getDevice().getSystemColor(1)};
            this.unselectedTabsPercents = new int[]{100};
        }
        this.rendererWrapper.drawBackground(gc, partHeaderBounds.x, partHeaderBounds.y, partHeaderBounds.width, partHeaderBounds.height, defaultBackground, this.unselectedTabsColors, this.unselectedTabsPercents, vertical);
    }

    private void drawTabAreaBackground(GC gc, Rectangle partHeaderBounds, int state, boolean vertical, Color defaultBackground) {
        Color[] colors = this.selectedTabAreaColors;
        int[] percents = this.selectedTabAreaPercents;
        if (colors != null && colors.length == 2) {
            colors = new Color[]{colors[1], colors[1]};
        }
        if (colors == null) {
            boolean selected = (state & 2) != 0;
            colors = selected ? this.parentWrapper.getSelectionGradientColors() : this.parentWrapper.getGradientColors();
            int[] nArray = percents = selected ? this.parentWrapper.getSelectionGradientPercents() : this.parentWrapper.getGradientPercents();
        }
        if (colors == null) {
            colors = new Color[]{gc.getDevice().getSystemColor(1)};
            percents = new int[]{100};
        }
        this.rendererWrapper.drawBackground(gc, partHeaderBounds.x, partHeaderBounds.y + partHeaderBounds.height, partHeaderBounds.width, this.parent.getBounds().height, defaultBackground, colors, percents, vertical);
    }

    private void drawChildrenBackground(Rectangle partHeaderBounds) {
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!CompositeElement.hasBackgroundOverriddenByCSS((Control)control) && this.containsToolbar(control)) {
                this.drawChildBackground((Composite)control, partHeaderBounds);
            }
            ++n2;
        }
    }

    private boolean containsToolbar(Control control) {
        if (control.getData(CONTAINS_TOOLBAR) != null) {
            return true;
        }
        if (control instanceof ToolBar) {
            control.setData(CONTAINS_TOOLBAR, (Object)true);
            return true;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof ToolBar) {
                    control.setData(CONTAINS_TOOLBAR, (Object)true);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void drawChildBackground(Composite composite, Rectangle partHeaderBounds) {
        boolean partOfHeader;
        Rectangle rec = composite.getBounds();
        Color background = null;
        boolean bl = partOfHeader = rec.y >= partHeaderBounds.y && rec.y < partHeaderBounds.height;
        if (!partOfHeader) {
            background = composite.getDisplay().getSystemColor(1);
        }
        CTabFolderElement.setBackgroundOverriddenDuringRenderering((Composite)composite, background);
    }

    private static class CTabFolderRendererWrapper
    extends ReflectionSupport<CTabFolderRenderer> {
        private Method drawBackgroundMethod;
        private Method drawCloseMethod;

        public CTabFolderRendererWrapper(CTabFolderRenderer instance) {
            super(instance);
        }

        public void drawBackground(GC gc, int x, int y, int width, int height, Color defaultBackground, Color[] colors, int[] percents, boolean vertical) {
            if (this.drawBackgroundMethod == null) {
                this.drawBackgroundMethod = this.getMethod("drawBackground", GC.class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Color.class, Image.class, Color[].class, int[].class, Boolean.TYPE);
            }
            Object[] objectArray = new Object[11];
            objectArray[0] = gc;
            objectArray[2] = x;
            objectArray[3] = y;
            objectArray[4] = width;
            objectArray[5] = height;
            objectArray[6] = defaultBackground;
            objectArray[8] = colors;
            objectArray[9] = percents;
            objectArray[10] = vertical;
            this.executeMethod(this.drawBackgroundMethod, objectArray);
        }

        public void drawClose(GC gc, Rectangle closeRect, int closeImageState) {
            if (this.drawCloseMethod == null) {
                this.drawCloseMethod = this.getMethod("drawClose", GC.class, Rectangle.class, Integer.TYPE);
            }
            this.executeMethod(this.drawCloseMethod, gc, closeRect, closeImageState);
        }
    }

    private static class CTabFolderWrapper
    extends ReflectionSupport<CTabFolder> {
        private Field selectionGradientVerticalField;
        private Field gradientVerticalField;
        private Field selectionGradientColorsField;
        private Field selectionGradientPercentsField;
        private Field gradientColorsField;
        private Field gradientPercentsField;
        private Field showCloseField;
        private Field fixedTabHeightField;
        private Method getRightItemEdgeMethod;

        public CTabFolderWrapper(CTabFolder instance) {
            super(instance);
        }

        public boolean isShowClose() {
            Boolean result;
            if (this.showCloseField == null) {
                this.showCloseField = this.getField("showClose");
            }
            return (result = (Boolean)this.getFieldValue(this.showCloseField)) != null ? result : true;
        }

        public boolean isSelectionGradientVertical() {
            Boolean result;
            if (this.selectionGradientVerticalField == null) {
                this.selectionGradientVerticalField = this.getField("selectionGradientVertical");
            }
            return (result = (Boolean)this.getFieldValue(this.selectionGradientVerticalField)) != null ? result : true;
        }

        public boolean isGradientVertical() {
            Boolean result;
            if (this.gradientVerticalField == null) {
                this.gradientVerticalField = this.getField("gradientVertical");
            }
            return (result = (Boolean)this.getFieldValue(this.gradientVerticalField)) != null ? result : true;
        }

        public Color[] getSelectionGradientColors() {
            if (this.selectionGradientColorsField == null) {
                this.selectionGradientColorsField = this.getField("selectionGradientColorsField");
            }
            return (Color[])this.getFieldValue(this.selectionGradientColorsField);
        }

        public int[] getSelectionGradientPercents() {
            if (this.selectionGradientPercentsField == null) {
                this.selectionGradientPercentsField = this.getField("selectionGradientPercents");
            }
            return (int[])this.getFieldValue(this.selectionGradientPercentsField);
        }

        public Color[] getGradientColors() {
            if (this.gradientColorsField == null) {
                this.gradientColorsField = this.getField("gradientColors");
            }
            return (Color[])this.getFieldValue(this.gradientColorsField);
        }

        public int[] getGradientPercents() {
            if (this.gradientPercentsField == null) {
                this.gradientPercentsField = this.getField("gradientPercents");
            }
            return (int[])this.getFieldValue(this.gradientPercentsField);
        }

        public int getRightItemEdge(GC gc) {
            if (this.getRightItemEdgeMethod == null) {
                this.getRightItemEdgeMethod = this.getMethod("getRightItemEdge", GC.class);
            }
            return (Integer)this.executeMethod(this.getRightItemEdgeMethod, gc);
        }

        public int getFixedTabHeight() {
            if (this.fixedTabHeightField == null) {
                this.fixedTabHeightField = this.getField("fixedTabHeight");
            }
            return (Integer)this.getFieldValue(this.fixedTabHeightField);
        }
    }

    private static class CTabItemWrapper
    extends ReflectionSupport<CTabItem> {
        private Field shortenedTextField;
        private Field shortenedTextWidthField;
        private Field closeRectField;
        private Field closeImageStateField;

        public CTabItemWrapper(CTabItem instance) {
            super(instance);
        }

        public String getShortenedText() {
            if (this.shortenedTextField == null) {
                this.shortenedTextField = this.getField("shortenedText");
            }
            return (String)this.getFieldValue(this.shortenedTextField);
        }

        public void setShortenedText(String value) {
            this.set("shortenedText", value);
        }

        public Integer getShortenedTextWidth() {
            if (this.shortenedTextWidthField == null) {
                this.shortenedTextWidthField = this.getField("shortenedTextWidth");
            }
            return (Integer)this.getFieldValue(this.shortenedTextWidthField);
        }

        public void setShortenedTextWidth(int value) {
            this.set("shortenedTextWidth", value);
        }

        public Rectangle getCloseRect() {
            if (this.closeRectField == null) {
                this.closeRectField = this.getField("closeRect");
            }
            return (Rectangle)this.getFieldValue(this.closeRectField);
        }

        public int getCloseImageState() {
            if (this.closeImageStateField == null) {
                this.closeImageStateField = this.getField("closeImageState");
            }
            return (Integer)this.getFieldValue(this.closeImageStateField);
        }
    }

    private static class ReflectionSupport<T> {
        private T instance;

        public ReflectionSupport(T instance) {
            this.instance = instance;
        }

        protected Object getFieldValue(Field field) {
            Object value = null;
            if (field != null) {
                boolean accessible = field.isAccessible();
                try {
                    try {
                        field.setAccessible(true);
                        value = field.get(this.instance);
                    }
                    catch (Exception exception) {
                        field.setAccessible(accessible);
                    }
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
            return value;
        }

        protected Field getField(String name) {
            Class<?> cls = this.instance.getClass();
            while (!cls.equals(Object.class)) {
                try {
                    return cls.getDeclaredField(name);
                }
                catch (Exception exception) {
                    cls = cls.getSuperclass();
                }
            }
            return null;
        }

        public Object set(String name, Object value) {
            try {
                Field field = this.getField(name);
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                field.set(this.instance, value);
                field.setAccessible(accessible);
                return value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected Object executeMethod(Method method, Object ... params) {
            Object value = null;
            if (method != null) {
                boolean accessible = method.isAccessible();
                try {
                    try {
                        method.setAccessible(true);
                        value = method.invoke(this.instance, params);
                    }
                    catch (Exception exception) {
                        method.setAccessible(accessible);
                    }
                }
                finally {
                    method.setAccessible(accessible);
                }
            }
            return value;
        }

        protected Method getMethod(String name, Class<?> ... params) {
            Class<?> cls = this.instance.getClass();
            while (!cls.equals(Object.class)) {
                try {
                    return cls.getDeclaredMethod(name, params);
                }
                catch (Exception exception) {
                    cls = cls.getSuperclass();
                }
            }
            return null;
        }
    }
}

