/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.xmind.ui.dialogs.Messages;
import org.xmind.ui.internal.e4models.ModelPart;
import org.xmind.ui.internal.e4models.ViewModelFolderRenderer;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class ViewModelPart
extends ModelPart {
    private Composite rightBar;
    private Composite menuBar;
    private boolean adjusting;
    private ToolBar viewMenuTB;
    private Label tipLabel;

    @Override
    protected void createContent(Composite parent) {
        CTabFolder ctf = new CTabFolder(parent, 2048);
        ctf.setRenderer((CTabFolderRenderer)new ViewModelFolderRenderer(ctf));
        ctf.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem ti = new CTabItem(ctf, 0);
        MPart partModel = this.getAdapter(MPart.class);
        ti.setText(this.getLabel((MUILabel)partModel, partModel.getLocalizedLabel()));
        ti.setToolTipText(this.getToolTip(partModel.getLocalizedTooltip()));
        ctf.setSelection(ti);
        Composite contentContainer = new Composite((Composite)ctf, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        contentContainer.setLayout((Layout)layout);
        ti.setControl((Control)contentContainer);
        Control content = this.doCreateContent(contentContainer);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addTopRight(ctf, true);
        this.adjustViewMenuBar(true);
    }

    protected Control doCreateContent(Composite parent) {
        return null;
    }

    protected String getLabel(MUILabel itemPart, String newName) {
        newName = newName == null ? "" : LegacyActionTools.escapeMnemonics((String)newName);
        if (itemPart instanceof MDirtyable && ((MDirtyable)itemPart).isDirty()) {
            newName = String.valueOf('*') + newName;
        }
        return newName;
    }

    protected String getToolTip(String newToolTip) {
        return newToolTip == null || newToolTip.length() == 0 ? null : LegacyActionTools.escapeMnemonics((String)newToolTip);
    }

    protected void addTopRight(CTabFolder ctf, boolean visibleOrEnable) {
        this.rightBar = new Composite((Composite)ctf, 0);
        this.rightBar.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#f4f4f4")));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.rightBar.setLayout((Layout)layout);
        this.createTipLabel(this.rightBar);
        this.createMenuBar(this.rightBar, visibleOrEnable);
        ctf.setTopRight((Control)this.rightBar, 131072);
    }

    private void createTipLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(16384, 4, false, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginRight = 5;
        composite.setLayout((Layout)layout);
        this.tipLabel = new Label(composite, 0);
        this.tipLabel.setBackground(composite.getBackground());
        GridData layoutData = new GridData(16384, 0x1000000, false, true);
        layoutData.verticalIndent = 3;
        this.tipLabel.setLayoutData((Object)layoutData);
        this.tipLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#a1a1a1")));
        this.tipLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight(this.tipLabel.getFont().getFontData(), -1))));
        composite.setVisible(false);
        ((GridData)composite.getLayoutData()).exclude = true;
    }

    private void createMenuBar(Composite parent, boolean visibleOrEnable) {
        this.menuBar = new Composite(parent, 0);
        this.menuBar.setBackground(parent.getBackground());
        this.menuBar.setLayoutData((Object)new GridData(16384, 4, false, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.menuBar.setLayout((Layout)gridLayout);
        this.viewMenuTB = new ToolBar(this.menuBar, 0x820000);
        this.viewMenuTB.setBackground(this.menuBar.getBackground());
        this.viewMenuTB.setLayoutData((Object)new GridData(0x1000000, 1024, false, true));
        this.viewMenuTB.setData((Object)"ViewMenu");
        ToolItem ti = new ToolItem(this.viewMenuTB, 8);
        ti.setToolTipText(Messages.ViewModelPart_MenuBar_toolTip);
        if (visibleOrEnable) {
            this.menuBar.setVisible(false);
        } else {
            this.viewMenuTB.setEnabled(false);
        }
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ViewModelPart.this.showViewMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ViewModelPart.this.showViewMenu((ToolItem)e.widget);
            }
        });
        this.viewMenuTB.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    ToolItem item;
                    Accessible accessible = (Accessible)e.getSource();
                    ToolBar toolBar = (ToolBar)accessible.getControl();
                    if (e.childID >= 0 && e.childID < toolBar.getItemCount() && (item = toolBar.getItem(e.childID)) != null) {
                        e.result = item.getToolTipText();
                    }
                }
            }
        });
    }

    protected void setTip(String tip) {
        this.tipLabel.setText(tip == null ? "" : tip);
        Composite tipComposite = this.tipLabel.getParent();
        tipComposite.setVisible(tip != null && !tip.equals(""));
        ((GridData)tipComposite.getLayoutData()).exclude = !tipComposite.getVisible();
        this.adjustRightBar();
    }

    private void adjustRightBar() {
        this.rightBar.setVisible(this.tipLabel.getParent().getVisible() || this.menuBar.getVisible());
        this.rightBar.pack(true);
    }

    protected void showViewMenu(ToolItem item) {
        MPart part = this.getAdapter(MPart.class);
        if (part == null) {
            return;
        }
        Control ctrl = (Control)part.getWidget();
        MMenu menuModel = this.getViewMenu(part);
        if (menuModel == null || !menuModel.isToBeRendered()) {
            return;
        }
        final Menu swtMenu = (Menu)((IPresentationEngine)part.getContext().get(IPresentationEngine.class)).createGui((MUIElement)menuModel, (Object)ctrl.getShell(), part.getContext());
        if (swtMenu == null) {
            return;
        }
        ctrl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!swtMenu.isDisposed()) {
                    swtMenu.dispose();
                }
            }
        });
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        swtMenu.setLocation(displayAt);
        swtMenu.setVisible(true);
        Display display = swtMenu.getDisplay();
        while (!swtMenu.isDisposed() && swtMenu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!swtMenu.isDisposed() && !(swtMenu.getData() instanceof MenuManager)) {
            swtMenu.dispose();
        }
    }

    protected void adjustViewMenuBar(boolean visibleOrEnable) {
        boolean needsMenu;
        if (this.adjusting) {
            return;
        }
        if (this.menuBar == null) {
            return;
        }
        this.adjusting = true;
        MPart part = this.getAdapter(MPart.class);
        MMenu viewMenu = this.getViewMenu(part);
        boolean bl = needsMenu = viewMenu != null && this.hasVisibleMenuItems(viewMenu, part);
        if (visibleOrEnable) {
            this.menuBar.setVisible(needsMenu);
            ((GridData)this.menuBar.getLayoutData()).exclude = !this.menuBar.getVisible();
        } else {
            this.viewMenuTB.setEnabled(needsMenu);
        }
        this.adjustRightBar();
        this.adjusting = false;
    }

    private boolean hasVisibleMenuItems(MMenu viewMenu, MPart part) {
        Menu menu;
        MenuManager manager;
        if (!viewMenu.isToBeRendered() || !viewMenu.isVisible()) {
            return false;
        }
        for (MMenuElement menuElement : viewMenu.getChildren()) {
            if (!menuElement.isToBeRendered() || !menuElement.isVisible()) continue;
            if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)menuElement) || OpaqueElementUtil.isOpaqueMenuSeparator((MUIElement)menuElement)) {
                IContributionItem item = (IContributionItem)OpaqueElementUtil.getOpaqueItem((MUIElement)menuElement);
                if (item == null || !item.isVisible()) continue;
                return true;
            }
            return true;
        }
        Object menuRenderer = viewMenu.getRenderer();
        if (menuRenderer instanceof MenuManagerRenderer && (manager = ((MenuManagerRenderer)menuRenderer).getManager(viewMenu)) != null && manager.isVisible()) {
            return true;
        }
        Control control = (Control)part.getWidget();
        if (control != null && (menu = (Menu)((IPresentationEngine)part.getContext().get(IPresentationEngine.class)).createGui((MUIElement)viewMenu, (Object)control.getShell(), part.getContext())) != null) {
            MenuManagerRenderer menuManagerRenderer;
            MenuManager manager2;
            menuRenderer = viewMenu.getRenderer();
            if (menuRenderer instanceof MenuManagerRenderer && (manager2 = (menuManagerRenderer = (MenuManagerRenderer)menuRenderer).getManager(viewMenu)) != null) {
                manager2.markDirty();
            }
            return menu.getItemCount() != 0;
        }
        return false;
    }

    protected MMenu getViewMenu(MPart part) {
        if (part == null || part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            boolean viewMenu = menu.getTags().contains("ViewMenu");
            if (!viewMenu) continue;
            return menu;
        }
        return null;
    }
}

