/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.image;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.image.IExportSourceProvider;
import org.xmind.gef.image.ImageExportUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerExportSourceProvider
implements IExportSourceProvider {
    private IGraphicalViewer viewer;
    private Insets margins;
    private IFigure[] contents = null;
    private Rectangle sourceArea = null;

    public ViewerExportSourceProvider(IGraphicalViewer viewer, Insets margins) {
        this.viewer = viewer;
        this.margins = margins;
    }

    public ViewerExportSourceProvider(IGraphicalViewer viewer, int allMargin) {
        this(viewer, new Insets(allMargin));
    }

    public ViewerExportSourceProvider(IGraphicalViewer viewer) {
        this(viewer, new Insets(0));
    }

    protected LightweightSystem getLightweightSystem() {
        if (this.viewer instanceof GraphicalViewer) {
            return ((GraphicalViewer)this.viewer).getLightweightSystem();
        }
        return this.viewer.getCanvas().getLightweightSystem();
    }

    public IGraphicalViewer getViewer() {
        return this.viewer;
    }

    @Override
    public IFigure[] getContents() {
        if (this.contents == null) {
            this.contents = this.collectContents();
        }
        return this.contents;
    }

    private IFigure[] collectContents() {
        ArrayList<IFigure> figures = new ArrayList<IFigure>(5);
        this.collectContents(figures);
        return figures.toArray(new IFigure[figures.size()]);
    }

    protected void collectContents(List<IFigure> figures) {
        figures.add(this.getDefaultFigure());
    }

    protected IFigure getDefaultFigure() {
        IFigure contents = this.getViewer().getCanvas().getViewport().getContents();
        if (contents != null) {
            return contents;
        }
        IFigure rootFigure = this.getLightweightSystem().getRootFigure();
        List children = rootFigure.getChildren();
        if (children.size() > 0) {
            return (IFigure)children.get(0);
        }
        return rootFigure;
    }

    @Override
    public Rectangle getSourceArea() {
        if (this.sourceArea == null) {
            this.sourceArea = this.calculateSourceArea(this.getContentsForCalculatingSourceArea());
        }
        return this.sourceArea;
    }

    protected IFigure[] getContentsForCalculatingSourceArea() {
        ArrayList<IFigure> figures = new ArrayList<IFigure>(5);
        this.collectContentsForCalculatingSourceArea(figures);
        return figures.toArray(new IFigure[figures.size()]);
    }

    protected void collectContentsForCalculatingSourceArea(List<IFigure> figures) {
        this.collectContents(figures);
    }

    protected Rectangle calculateSourceArea(IFigure[] contents) {
        return ImageExportUtils.calcBoundsUnion(contents);
    }

    @Override
    public Insets getMargins() {
        return this.margins;
    }
}

