/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiProvidesStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRequiresStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiUsesStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public final class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myRoot;
    private final NotNullLazyValue<List<PsiPackageAccessibilityStatement>> myExports;

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile root2, @NotNull String name2) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            LightJavaModule.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(2);
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myExports = NotNullLazyValue.atomicLazy(this::findExports);
        this.myRoot = root2;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, name2);
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        VirtualFile virtualFile2 = this.myRoot;
        if (virtualFile2 == null) {
            LightJavaModule.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        List<PsiRequiresStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        Iterable iterable = this.myExports.getValue();
        if (iterable == null) {
            LightJavaModule.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    private List<PsiPackageAccessibilityStatement> findExports() {
        final ArrayList<PsiPackageAccessibilityStatement> exports = new ArrayList<PsiPackageAccessibilityStatement>();
        VfsUtilCore.visitChildrenRecursively(this.myRoot, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
            private final JavaDirectoryService service;
            {
                super(arg0);
                this.service = JavaDirectoryService.getInstance();
            }

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                String packageName2;
                PsiPackage pkg;
                PsiDirectory directory;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory() && !LightJavaModule.this.myRoot.equals(file2) && (directory = LightJavaModule.this.getManager().findDirectory(file2)) != null && (pkg = this.service.getPackage(directory)) != null && !(packageName2 = pkg.getQualifiedName()).isEmpty() && !PsiUtil.isPackageEmpty(new PsiDirectory[]{directory}, packageName2)) {
                    exports.add(new LightPackageAccessibilityStatement(LightJavaModule.this.getManager(), packageName2));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$1", "visitFile"));
            }
        });
        return exports;
    }

    @Override
    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        List<PsiPackageAccessibilityStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        List<PsiUsesStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        List<PsiProvidesStatement> list2 = Collections.emptyList();
        if (list2 == null) {
            LightJavaModule.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        LightJavaModuleReferenceElement lightJavaModuleReferenceElement = this.myRefElement;
        if (lightJavaModuleReferenceElement == null) {
            LightJavaModule.$$$reportNull$$$0(9);
        }
        return lightJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myRefElement.getReferenceText();
        if (string2 == null) {
            LightJavaModule.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException("Cannot modify an automatic module '" + this.getName() + "'");
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = ObjectUtils.notNull(this.myManager.findDirectory(this.myRoot), super.getNavigationElement());
        if (psiElement == null) {
            LightJavaModule.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myRoot.equals(((LightJavaModule)obj).myRoot) && this.getManager() == ((LightJavaModule)obj).getManager();
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + this.getManager().hashCode();
    }

    @Override
    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @Nullable
    public static LightJavaModule findModule(@NotNull PsiManager manager, @NotNull VirtualFile root2) {
        PsiDirectory directory;
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(14);
        }
        if (root2 == null) {
            LightJavaModule.$$$reportNull$$$0(15);
        }
        if ((directory = manager.findDirectory(root2)) == null) {
            return null;
        }
        if (root2.isInLocalFileSystem()) {
            return (LightJavaModule)CachedValuesManager.getCachedValue(directory, () -> {
                PsiFile file2;
                VirtualFile manifest2 = root2.findFileByRelativePath("META-INF/MANIFEST.MF");
                if (manifest2 != null && (file2 = manager.findFile(manifest2)) != null) {
                    String name2 = LightJavaModule.claimedModuleName(manifest2);
                    LightJavaModule module2 = name2 != null ? new LightJavaModule(manager, root2, name2) : null;
                    return CachedValueProvider.Result.create(module2, file2);
                }
                return CachedValueProvider.Result.create(null, PsiModificationTracker.MODIFICATION_COUNT);
            });
        }
        return (LightJavaModule)CachedValuesManager.getCachedValue(directory, () -> {
            LightJavaModule module2 = new LightJavaModule(manager, root2, LightJavaModule.moduleName(root2));
            return CachedValueProvider.Result.create(module2, directory);
        });
    }

    @NotNull
    public static String moduleName(@NotNull VirtualFile jarRoot) {
        String claimed;
        VirtualFile manifest2;
        if (jarRoot == null) {
            LightJavaModule.$$$reportNull$$$0(16);
        }
        if ((manifest2 = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF")) != null && (claimed = LightJavaModule.claimedModuleName(manifest2)) != null) {
            String string2 = claimed;
            if (string2 == null) {
                LightJavaModule.$$$reportNull$$$0(17);
            }
            return string2;
        }
        return LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
    }

    @Nullable
    public static String claimedModuleName(@NotNull VirtualFile manifest2) {
        String string2;
        block9: {
            if (manifest2 == null) {
                LightJavaModule.$$$reportNull$$$0(18);
            }
            InputStream stream = manifest2.getInputStream();
            try {
                string2 = new Manifest(stream).getMainAttributes().getValue("Automatic-Module-Name");
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.getInstance(LightJavaModule.class).warn(manifest2.getPath(), e);
                    return null;
                }
            }
            stream.close();
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public static LightJavaModule create(@NotNull PsiManager manager, @NotNull VirtualFile root2, @NotNull String name2) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(19);
        }
        if (root2 == null) {
            LightJavaModule.$$$reportNull$$$0(20);
        }
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(21);
        }
        return new LightJavaModule(manager, root2, name2);
    }

    @NotNull
    public static String moduleName(@NotNull String name2) {
        Matcher m;
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(22);
        }
        if ((m = Patterns.VERSION.matcher(name2)).find()) {
            name2 = name2.substring(0, m.start());
        }
        name2 = Patterns.NON_NAME.matcher(name2).replaceAll(".");
        name2 = Patterns.DOT_SEQUENCE.matcher(name2).replaceAll(".");
        String string2 = name2 = StringUtil.trimLeading(StringUtil.trimTrailing(name2, '.'), '.');
        if (string2 == null) {
            LightJavaModule.$$$reportNull$$$0(23);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarRoot";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequires";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpens";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvides";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 17: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 16: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moduleName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "claimedModuleName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightPackageAccessibilityStatement
    extends LightElement
    implements PsiPackageAccessibilityStatement {
        private final String myPackageName;

        LightPackageAccessibilityStatement(@NotNull PsiManager manager, @NotNull String packageName2) {
            if (manager == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(0);
            }
            if (packageName2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(1);
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myPackageName = packageName2;
        }

        @Override
        @NotNull
        public PsiPackageAccessibilityStatement.Role getRole() {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.EXPORTS;
            if (role == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(2);
            }
            return role;
        }

        @Override
        @Nullable
        public PsiJavaCodeReferenceElement getPackageReference() {
            return null;
        }

        @Override
        @Nullable
        public String getPackageName() {
            return this.myPackageName;
        }

        @Override
        @NotNull
        public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
            List<PsiJavaModuleReferenceElement> list2 = Collections.emptyList();
            if (list2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<String> getModuleNames() {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Override
        public String toString() {
            return "PsiPackageAccessibilityStatement";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRole";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleReferences";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        private LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text2) {
            if (manager == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(1);
            }
            super(manager, JavaLanguage.INSTANCE);
            this.myText = text2;
        }

        @Override
        @NotNull
        public String getReferenceText() {
            String string2 = this.myText;
            if (string2 == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        public PsiJavaModuleReference getReference() {
            return null;
        }

        @Override
        public String toString() {
            return "PsiJavaModuleReference";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

