/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.TypedSource;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TypedSourceTransfer
extends ByteArrayTransfer {
    private static final TypedSourceTransfer fgInstance = new TypedSourceTransfer();
    private static final String TYPE_NAME = "typed-source-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)fgInstance)).hashCode();
    private static final int TYPEID = TypedSourceTransfer.registerType((String)TYPE_NAME);

    private TypedSourceTransfer() {
    }

    public static TypedSourceTransfer getInstance() {
        return fgInstance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof TypedSource[])) {
            return;
        }
        TypedSource[] sources = (TypedSource[])data;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(sources.length);
            for (int i = 0; i < sources.length; ++i) {
                TypedSourceTransfer.writeJavaElement(dataOut, sources[i]);
            }
            dataOut.close();
            out.close();
            super.javaToNative((Object)out.toByteArray(), transferData);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            TypedSource[] results = new TypedSource[count];
            for (int i = 0; i < count; ++i) {
                results[i] = TypedSourceTransfer.readJavaElement(in);
                Assert.isNotNull(results[i]);
            }
            in.close();
            return results;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static TypedSource readJavaElement(DataInputStream dataIn) throws IOException {
        int type = dataIn.readInt();
        String source = dataIn.readUTF();
        return TypedSource.create(source, type);
    }

    private static void writeJavaElement(DataOutputStream dataOut, TypedSource sourceReference) throws IOException {
        dataOut.writeInt(sourceReference.getType());
        dataOut.writeUTF(sourceReference.getSource());
    }
}

