/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFileNonPluginContentConsumer
extends ContentConsumer {
    private String path;
    private boolean closed = false;

    public SiteFileNonPluginContentConsumer(String featurePath) {
        this.path = featurePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to store in a closed SiteFileNonPluginContentConsumer", new Exception());
            return;
        }
        InputStream inStream = null;
        String featurePath = this.path;
        String contentKey = contentReference.getIdentifier();
        featurePath = featurePath + contentKey;
        try {
            try {
                inStream = contentReference.getInputStream();
                UpdateManagerUtils.copyToLocal(inStream, featurePath, null);
                UpdateManagerUtils.checkPermissions(contentReference, featurePath);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(Policy.bind("GlobalConsumer.ErrorCreatingFile", featurePath), e);
            }
            Object var8_6 = null;
            if (inStream == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        inStream.close();
        return;
    }

    public void close() {
        if (this.closed) {
            UpdateCore.warn("Attempt to close a closed SiteFileNonPluginContentConsumer", new Exception());
            return;
        }
        this.closed = true;
    }
}

