/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

class EventTable {
    int[] types;
    Listener[] listeners;
    int level;

    EventTable() {
    }

    public void hook(int eventType, Listener listener) {
        int index;
        if (this.types == null) {
            this.types = new int[4];
        }
        if (this.listeners == null) {
            this.listeners = new Listener[4];
        }
        int length = this.types.length;
        for (index = length - 1; index >= 0 && this.types[index] == 0; --index) {
        }
        if (++index == length) {
            if (this.level == 0) {
                int i;
                index = 0;
                for (i = 0; i < this.types.length; ++i) {
                    if (this.types[i] == 0) continue;
                    this.types[index] = this.types[i];
                    this.listeners[index] = this.listeners[i];
                    ++index;
                }
                for (i = index; i < this.types.length; ++i) {
                    this.types[i] = 0;
                    this.listeners[i] = null;
                }
            }
            if (index == length) {
                int[] newTypes = new int[length + 4];
                System.arraycopy(this.types, 0, newTypes, 0, length);
                this.types = newTypes;
                Listener[] newListeners = new Listener[length + 4];
                System.arraycopy(this.listeners, 0, newListeners, 0, length);
                this.listeners = newListeners;
            }
        }
        this.types[index] = eventType;
        this.listeners[index] = listener;
    }

    public boolean hooks(int eventType) {
        if (this.types == null) {
            return false;
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != eventType) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) {
        if (this.types == null) {
            return;
        }
        ++this.level;
        try {
            for (int i = 0; i < this.types.length; ++i) {
                Listener listener;
                if (event.type == 0) {
                    return;
                }
                if (this.types[i] != event.type || (listener = this.listeners[i]) == null) continue;
                listener.handleEvent(event);
            }
        }
        finally {
            --this.level;
        }
    }

    public int size() {
        if (this.types == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] == 0) continue;
            ++count;
        }
        return count;
    }

    void remove(int index) {
        if (this.level == 0) {
            int end = this.types.length - 1;
            System.arraycopy(this.types, index + 1, this.types, index, end - index);
            System.arraycopy(this.listeners, index + 1, this.listeners, index, end - index);
            index = end;
        }
        this.types[index] = 0;
        this.listeners[index] = null;
    }

    public void unhook(int eventType, Listener listener) {
        if (this.types == null) {
            return;
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != eventType || this.listeners[i] != listener) continue;
            this.remove(i);
            return;
        }
    }

    public void unhook(int eventType, SWTEventListener listener) {
        if (this.types == null) {
            return;
        }
        for (int i = 0; i < this.types.length; ++i) {
            TypedListener typedListener;
            if (this.types[i] != eventType || !(this.listeners[i] instanceof TypedListener) || (typedListener = (TypedListener)this.listeners[i]).getEventListener() != listener) continue;
            this.remove(i);
            return;
        }
    }
}

