/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.Queue;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

public class CharsetDeltaJob
extends Job
implements IContentTypeManager.IContentTypeChangeListener {
    private ThreadLocal disabled = new ThreadLocal();
    private final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    private Queue work = new Queue();
    private Workspace workspace;

    public CharsetDeltaJob(Workspace workspace) {
        super(Policy.bind("resources.charsetBroadcasting"));
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(ICharsetListenerFilter filter) {
        Queue queue = this.work;
        synchronized (queue) {
            this.work.add(filter);
        }
        this.schedule();
    }

    public void charsetPreferencesChanged(final IProject project) {
        if (this.isDisabled()) {
            return;
        }
        ICharsetListenerFilter filter = new ICharsetListenerFilter(){

            public IPath getRoot() {
                return project.getFullPath();
            }

            public boolean isAffected(ResourceInfo info, IPathRequestor requestor) {
                return true;
            }
        };
        this.addToQueue(filter);
    }

    public void contentTypeChanged(final IContentTypeManager.ContentTypeChangeEvent event) {
        ICharsetListenerFilter filter = new ICharsetListenerFilter(){

            public IPath getRoot() {
                return Path.ROOT;
            }

            public boolean isAffected(ResourceInfo info, IPathRequestor requestor) {
                if (info.getType() != 1) {
                    return false;
                }
                return event.getContentType().isAssociatedWith(requestor.requestName());
            }
        };
        this.addToQueue(filter);
    }

    private boolean isDisabled() {
        return this.disabled.get() != null;
    }

    private void processNextEvent(final ICharsetListenerFilter filter, IProgressMonitor monitor) throws CoreException {
        IElementContentVisitor visitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree tree, IPathRequestor requestor, Object elementContents) {
                ResourceInfo info = (ResourceInfo)elementContents;
                if (!filter.isAffected(info, requestor)) {
                    return true;
                }
                info = CharsetDeltaJob.this.workspace.getResourceInfo(requestor.requestPath(), false, true);
                if (info == null) {
                    return false;
                }
                info.incrementCharsetGenerationCount();
                return true;
            }
        };
        try {
            new ElementTreeIterator(this.workspace.getElementTree(), filter.getRoot()).iterate(visitor);
        }
        catch (WrappedRuntimeException e) {
            throw (CoreException)e.getTargetException();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICharsetListenerFilter removeFromQueue() {
        Queue queue = this.work;
        synchronized (queue) {
            return (ICharsetListenerFilter)this.work.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.charsetBroadcasting");
            monitor.beginTask(message, Policy.totalWork);
            try {
                try {
                    ICharsetListenerFilter next;
                    this.workspace.prepareOperation(null, monitor);
                    this.workspace.beginOperation(true);
                    while (this.systemBundle.getState() != 16 && (next = this.removeFromQueue()) != null) {
                        this.processNextEvent(next, monitor);
                    }
                    Object var6_7 = null;
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    Object var6_8 = null;
                    this.workspace.endOperation(null, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                    monitor.done();
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.workspace.endOperation(null, true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
        }
        catch (CoreException sig) {
            IStatus iStatus = sig.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
        this.workspace.endOperation(null, true, Policy.subMonitorFor(monitor, Policy.buildWork));
        monitor.worked(Policy.opWork);
        return Status.OK_STATUS;
    }

    public void setDisabled(boolean disabled) {
        this.disabled.set(disabled ? Boolean.TRUE : null);
    }

    public void shutdown() {
        Platform.getContentTypeManager().removeContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
    }

    public void startup() {
        Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
    }

    static interface ICharsetListenerFilter {
        public IPath getRoot();

        public boolean isAffected(ResourceInfo var1, IPathRequestor var2);
    }
}

