/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeaturePropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class URLElementPropertySource
extends FeaturePropertySource {
    private Vector descriptors;
    private static final String P_URL = "url";
    public static final String KEY_TYPE = "FeatureEditor.URLProp.type";
    public static final String KEY_SITE_TYPE = "FeatureEditor.URLProp.siteType";
    public static final String KEY_LABEL = "FeatureEditor.URLProp.label";
    public static final String KEY_URL = "FeatureEditor.URLProp.URL";
    private static final String P_TYPE = "type";
    private static final String P_LABEL = "label";
    private static final String P_SITE_TYPE = "siteType";
    private static final String[] elementTypes = new String[]{null, PDEPlugin.getResourceString("FeatureEditor.URLProp.type.update"), PDEPlugin.getResourceString("FeatureEditor.URLProp.type.discovery")};
    private static final String[] siteTypes = new String[]{"update", "web"};

    public URLElementPropertySource(IFeatureURLElement element) {
        super((IFeatureObject)element);
    }

    public IFeatureURLElement getElement() {
        return (IFeatureURLElement)this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new Vector();
            PropertyDescriptor desc = new PropertyDescriptor((Object)P_TYPE, PDEPlugin.getResourceString(KEY_TYPE));
            this.descriptors.addElement(desc);
            desc = this.createTextPropertyDescriptor(P_LABEL, PDEPlugin.getResourceString(KEY_LABEL));
            this.descriptors.addElement(desc);
            desc = this.createTextPropertyDescriptor(P_URL, PDEPlugin.getResourceString(KEY_URL));
            this.descriptors.addElement(desc);
            desc = this.createChoicePropertyDescriptor(P_SITE_TYPE, PDEPlugin.getResourceString(KEY_SITE_TYPE), siteTypes);
            this.descriptors.addElement(desc);
        }
        return this.toDescriptorArray(this.descriptors);
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(P_TYPE)) {
            return elementTypes[this.getElement().getElementType()];
        }
        if (name.equals(P_LABEL)) {
            return this.getElement().getLabel();
        }
        if (name.equals(P_URL)) {
            return this.getElement().getURL().toString();
        }
        if (name.equals(P_SITE_TYPE)) {
            return new Integer(this.getElement().getSiteType());
        }
        return null;
    }

    public void setElement(IFeatureURLElement newElement) {
        this.object = newElement;
    }

    public void setPropertyValue(Object name, Object value) {
        String svalue = value.toString();
        String realValue = svalue == null | svalue.length() == 0 ? null : svalue;
        try {
            if (name.equals(P_URL)) {
                try {
                    URL url = null;
                    if (realValue != null) {
                        url = new URL(realValue);
                    }
                    this.getElement().setURL(url);
                }
                catch (MalformedURLException e) {}
            } else if (name.equals(P_LABEL)) {
                this.getElement().setLabel(realValue);
            } else if (name.equals(P_SITE_TYPE)) {
                Integer ivalue = (Integer)value;
                this.getElement().setSiteType(ivalue.intValue());
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

