/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BreakpointHitCountAction
extends ObjectActionDelegate {
    private static final String INITIAL_VALUE = "1";

    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Iterator itr = selection.iterator();
        if (!itr.hasNext()) {
            return;
        }
        while (itr.hasNext()) {
            IJavaBreakpoint breakpoint = (IJavaBreakpoint)itr.next();
            try {
                int oldHitCount = breakpoint.getHitCount();
                int newHitCount = this.hitCountDialog(breakpoint);
                if (newHitCount == -1) continue;
                if (oldHitCount == newHitCount && newHitCount == 0) {
                    return;
                }
                breakpoint.setHitCount(newHitCount);
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.errorDialog(ActionMessages.getString("BreakpointHitCountAction.Exception_occurred_attempting_to_set_hit_count_1"), ce);
            }
        }
    }

    protected int hitCountDialog(IJavaBreakpoint breakpoint) {
        String title = ActionMessages.getString("BreakpointHitCountAction.Set_Breakpoint_Hit_Count_2");
        String message = ActionMessages.getString("BreakpointHitCountAction.&Enter_the_new_hit_count_for_the_breakpoint__3");
        IInputValidator validator = new IInputValidator(){
            int hitCount = -1;

            public String isValid(String value) {
                try {
                    this.hitCount = Integer.valueOf(value.trim());
                }
                catch (NumberFormatException nfe) {
                    this.hitCount = -1;
                }
                if (this.hitCount < 1) {
                    return ActionMessages.getString("BreakpointHitCountAction.Value_must_be_positive_integer");
                }
                return null;
            }
        };
        int currentHitCount = 0;
        try {
            currentHitCount = breakpoint.getHitCount();
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        String initialValue = currentHitCount > 0 ? Integer.toString(currentHitCount) : INITIAL_VALUE;
        Shell activeShell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        HitCountDialog dialog = new HitCountDialog(activeShell, title, message, initialValue, validator);
        if (dialog.open() != 0) {
            return -1;
        }
        if (dialog.isHitCountEnabled()) {
            return Integer.parseInt(dialog.getValue().trim());
        }
        return 0;
    }

    class HitCountDialog
    extends InputDialog {
        private boolean fHitCountEnabled;

        protected HitCountDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Button checkbox = new Button(area, 32);
            GridData data = new GridData(768);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            checkbox.setLayoutData((Object)data);
            checkbox.setFont(parent.getFont());
            checkbox.setText(ActionMessages.getString("BreakpointHitCountAction.Enable_Hit_Count_1"));
            checkbox.setSelection(true);
            this.fHitCountEnabled = true;
            checkbox.addSelectionListener(new SelectionListener(this, checkbox){
                private final /* synthetic */ Button val$checkbox;
                private final /* synthetic */ HitCountDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$checkbox = val$checkbox;
                }

                public void widgetSelected(SelectionEvent e) {
                    HitCountDialog.access$002(this.this$1, this.val$checkbox.getSelection());
                    HitCountDialog.access$100(this.this$1).setEnabled(HitCountDialog.access$000(this.this$1));
                    if (HitCountDialog.access$000(this.this$1)) {
                        HitCountDialog.access$200(this.this$1);
                    } else {
                        this.this$1.setErrorMessage(null);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return area;
        }

        protected boolean isHitCountEnabled() {
            return this.fHitCountEnabled;
        }

        static /* synthetic */ boolean access$002(HitCountDialog x0, boolean x1) {
            x0.fHitCountEnabled = x1;
            return x0.fHitCountEnabled;
        }

        static /* synthetic */ boolean access$000(HitCountDialog x0) {
            return x0.fHitCountEnabled;
        }

        static /* synthetic */ Text access$100(HitCountDialog x0) {
            return x0.getText();
        }

        static /* synthetic */ void access$200(HitCountDialog x0) {
            x0.validateInput();
        }
    }
}

