/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

class TextViewerHoverManager
extends AbstractHoverInformationControlManager
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    public static final int WIDGET_PRIORITY = 0;
    private TextViewer fTextViewer;
    private Thread fThread;
    private ITextListener fStopper;
    private Object fMutex = new Object();
    private volatile ITextHover fTextHover;
    private boolean fProcessMouseHoverEvent = true;
    private MouseMoveListener fMouseMoveListener;
    private IViewportListener fViewportListener;

    public TextViewerHoverManager(TextViewer textViewer, IInformationControlCreator creator) {
        super(creator);
        this.fTextViewer = textViewer;
        this.fStopper = new ITextListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void textChanged(TextEvent event) {
                Object object = TextViewerHoverManager.this.fMutex;
                synchronized (object) {
                    if (TextViewerHoverManager.this.fThread != null) {
                        TextViewerHoverManager.this.fThread.interrupt();
                        TextViewerHoverManager.this.fThread = null;
                    }
                }
            }
        };
        this.fViewportListener = new IViewportListener(){

            public void viewportChanged(int verticalOffset) {
                TextViewerHoverManager.this.fProcessMouseHoverEvent = false;
            }
        };
        this.fTextViewer.addViewportListener(this.fViewportListener);
        this.fMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                TextViewerHoverManager.this.fProcessMouseHoverEvent = true;
            }
        };
        this.fTextViewer.getTextWidget().addMouseMoveListener(this.fMouseMoveListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeInformation() {
        if (!this.fProcessMouseHoverEvent) {
            this.setInformation(null, null);
            return;
        }
        Point location = this.getHoverEventLocation();
        int offset = this.computeOffsetAtLocation(location.x, location.y);
        if (offset == -1) {
            this.setInformation(null, null);
            return;
        }
        final ITextHover hover = this.fTextViewer.getTextHover(offset, this.getHoverEventStateMask());
        if (hover == null) {
            this.setInformation(null, null);
            return;
        }
        final IRegion region = hover.getHoverRegion(this.fTextViewer, offset);
        if (region == null) {
            this.setInformation(null, null);
            return;
        }
        final Rectangle area = this.computeArea(region);
        if (area == null || area.isEmpty()) {
            this.setInformation(null, null);
            return;
        }
        if (this.fThread != null) {
            this.setInformation(null, null);
            return;
        }
        this.fThread = new Thread("Text Viewer Hover Presenter"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean hasFinished = false;
                try {
                    if (TextViewerHoverManager.this.fThread != null) {
                        String information;
                        try {
                            information = hover.getHoverInfo(TextViewerHoverManager.this.fTextViewer, region);
                        }
                        catch (ArrayIndexOutOfBoundsException x) {
                            information = null;
                        }
                        if (hover instanceof ITextHoverExtension) {
                            TextViewerHoverManager.this.setCustomInformationControlCreator(((ITextHoverExtension)((Object)hover)).getHoverControlCreator());
                        } else {
                            TextViewerHoverManager.this.setCustomInformationControlCreator(null);
                        }
                        TextViewerHoverManager.this.setInformation(information, area);
                        if (information != null && area != null) {
                            TextViewerHoverManager.this.fTextHover = hover;
                        }
                    } else {
                        TextViewerHoverManager.this.setInformation(null, null);
                    }
                    hasFinished = true;
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    Object object = TextViewerHoverManager.this.fMutex;
                    synchronized (object) {
                        if (TextViewerHoverManager.this.fTextViewer != null) {
                            TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                        }
                        TextViewerHoverManager.this.fThread = null;
                        if (!hasFinished) {
                            TextViewerHoverManager.this.setInformation(null, null);
                        }
                    }
                    throw throwable;
                }
                Object object = TextViewerHoverManager.this.fMutex;
                synchronized (object) {
                    if (TextViewerHoverManager.this.fTextViewer != null) {
                        TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                    }
                    TextViewerHoverManager.this.fThread = null;
                    if (!hasFinished) {
                        TextViewerHoverManager.this.setInformation(null, null);
                    }
                }
            }
        };
        this.fThread.setDaemon(true);
        this.fThread.setPriority(1);
        Object object = this.fMutex;
        synchronized (object) {
            this.fTextViewer.addTextListener(this.fStopper);
            this.fThread.start();
        }
    }

    protected void presentInformation() {
        if (this.fTextViewer == null) {
            return;
        }
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Display display = textWidget.getDisplay();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                public void run() {
                    TextViewerHoverManager.this.doPresentInformation();
                }
            });
        }
    }

    protected void doPresentInformation() {
        super.presentInformation();
    }

    private int computeOffsetAtLocation(int x, int y) {
        try {
            StyledText styledText = this.fTextViewer.getTextWidget();
            int widgetOffset = styledText.getOffsetAtLocation(new Point(x, y));
            if (this.fTextViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fTextViewer);
                return extension.widgetOffset2ModelOffset(widgetOffset);
            }
            return widgetOffset + this.fTextViewer._getVisibleRegionOffset();
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    private Rectangle computeArea(IRegion region) {
        IRegion widgetRegion = this.modelRange2WidgetRange(region);
        int start = widgetRegion.getOffset();
        int end = widgetRegion.getOffset() + widgetRegion.getLength();
        StyledText styledText = this.fTextViewer.getTextWidget();
        Point upperLeft = styledText.getLocationAtOffset(start);
        Point lowerRight = new Point(upperLeft.x, upperLeft.y);
        for (int i = start + 1; i < end; ++i) {
            Point p = styledText.getLocationAtOffset(i);
            if (upperLeft.x > p.x) {
                upperLeft.x = p.x;
            }
            if (upperLeft.y > p.y) {
                upperLeft.y = p.y;
            }
            if (lowerRight.x < p.x) {
                lowerRight.x = p.x;
            }
            if (lowerRight.y >= p.y) continue;
            lowerRight.y = p.y;
        }
        lowerRight.x += this.fTextViewer.getAverageCharWidth();
        lowerRight.y += styledText.getLineHeight();
        int width = lowerRight.x - upperLeft.x;
        int height = lowerRight.y - upperLeft.y;
        return new Rectangle(upperLeft.x, upperLeft.y, width, height);
    }

    private IRegion modelRange2WidgetRange(IRegion region) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fTextViewer);
            return extension.modelRange2WidgetRange(region);
        }
        IRegion visibleRegion = this.fTextViewer.getVisibleRegion();
        int start = region.getOffset() - visibleRegion.getOffset();
        int end = start + region.getLength();
        if (end > visibleRegion.getLength()) {
            end = visibleRegion.getLength();
        }
        return new Region(start, end - start);
    }

    protected void showInformationControl(Rectangle subjectArea) {
        if (this.fTextViewer != null && this.fTextViewer.requestWidgetToken(this, 0)) {
            super.showInformationControl(subjectArea);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideInformationControl() {
        try {
            this.fTextHover = null;
            super.hideInformationControl();
            Object var2_1 = null;
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
            Object var2_1 = null;
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
            throw throwable;
        }
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        this.fTextHover = null;
        super.hideInformationControl();
        return true;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        if (priority > 0) {
            this.fTextHover = null;
            super.hideInformationControl();
            return true;
        }
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        return false;
    }

    protected ITextHover getCurrentTextHover() {
        return this.fTextHover;
    }

    public void dispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeViewportListener(this.fViewportListener);
            this.fViewportListener = null;
            StyledText st = this.fTextViewer.getTextWidget();
            if (st != null && !st.isDisposed()) {
                st.removeMouseMoveListener(this.fMouseMoveListener);
            }
            this.fMouseMoveListener = null;
        }
        super.dispose();
    }
}

