/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.wizards.GlobalSynchronizeWizard;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.Priority;

public class GlobalRefreshAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate,
ISynchronizeParticipantListener {
    public static final String NO_DEFAULT_PARTICPANT = "none";
    private Menu fMenu;
    private Action synchronizeAction = new Action(Policy.bind("GlobalRefreshAction.4")){

        public void run() {
            GlobalSynchronizeWizard wizard = new GlobalSynchronizeWizard();
            WizardDialog dialog = new WizardDialog(GlobalRefreshAction.this.window.getShell(), (IWizard)wizard);
            dialog.open();
        }
    };
    private IWorkbenchWindow window;
    private IAction actionProxy;
    private HandlerSubmission syncAll;
    private HandlerSubmission syncLatest;

    public GlobalRefreshAction() {
        this.synchronizeAction.setImageDescriptor(TeamImages.getImageDescriptor("eview16/synch_synch.gif"));
        ActionHandler handler = new ActionHandler((IAction)this.synchronizeAction);
        this.syncAll = new HandlerSubmission(null, null, null, "org.eclipse.team.ui.synchronizeAll", (IHandler)handler, Priority.MEDIUM);
        PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(this.syncAll);
        handler = new ActionHandler((IAction)this);
        this.syncLatest = new HandlerSubmission(null, null, null, "org.eclipse.team.ui.synchronizeLast", (IHandler)handler, Priority.MEDIUM);
        PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(this.syncLatest);
        this.setMenuCreator(this);
        TeamUI.getSynchronizeManager().addSynchronizeParticipantListener(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
        PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmission(this.syncAll);
        this.syncAll.getHandler().dispose();
        PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmission(this.syncLatest);
        this.syncLatest.getHandler().dispose();
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ISynchronizeParticipantReference[] participants = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        for (int i = 0; i < participants.length; ++i) {
            ISynchronizeParticipantReference description = participants[i];
            RefreshParticipantAction action = new RefreshParticipantAction(i + 1, description);
            this.addActionToMenu(this.fMenu, action);
        }
        if (participants.length > 0) {
            this.addMenuSeparator();
        }
        this.addActionToMenu(this.fMenu, this.synchronizeAction);
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    protected void addMenuSeparator() {
        new MenuItem(this.fMenu, 2);
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run() {
        String id = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.sychronizing_default_participant");
        String secondaryId = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.sychronizing_default_participant_sec_id");
        GlobalSynchronizeWizard wizard = new GlobalSynchronizeWizard();
        ISynchronizeParticipantReference participant = TeamUI.getSynchronizeManager().get(id, secondaryId);
        if (participant != null) {
            this.run(participant);
        } else {
            this.synchronizeAction.run();
        }
    }

    public void run(IAction action) {
        this.run();
        this.actionProxy = action;
        this.updateTooltipText();
    }

    private void run(ISynchronizeParticipantReference participant) {
        try {
            ISynchronizeParticipant p = participant.getParticipant();
            p.run(null);
            this.updateTooltipText();
        }
        catch (TeamException e) {
            Utils.handle(e);
        }
    }

    public void participantsAdded(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                GlobalRefreshAction.this.updateTooltipText();
            }
        });
    }

    public void participantsRemoved(ISynchronizeParticipant[] consoles) {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (GlobalRefreshAction.this.fMenu != null) {
                    GlobalRefreshAction.this.fMenu.dispose();
                }
                GlobalRefreshAction.this.updateTooltipText();
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.actionProxy = action;
    }

    protected void updateTooltipText() {
        if (this.actionProxy != null) {
            ISynchronizeParticipantReference ref;
            String id = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.sychronizing_default_participant");
            String secondaryId = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.sychronizing_default_participant_sec_id");
            if (!id.equals(NO_DEFAULT_PARTICPANT) && (ref = TeamUI.getSynchronizeManager().get(id, secondaryId)) != null) {
                this.actionProxy.setToolTipText(Policy.bind("GlobalRefreshAction.5", ref.getDisplayName()));
                return;
            }
            this.actionProxy.setToolTipText(Policy.bind("GlobalRefreshAction.4"));
        }
    }

    class RefreshParticipantAction
    extends Action {
        private ISynchronizeParticipantReference participant;

        public void run() {
            TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant", this.participant.getId());
            TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant_sec_id", this.participant.getSecondaryId());
            GlobalRefreshAction.this.run(this.participant);
        }

        public RefreshParticipantAction(int prefix, ISynchronizeParticipantReference participant) {
            super("&" + prefix + " " + Utils.shortenText(100, participant.getDisplayName()));
            this.participant = participant;
            this.setImageDescriptor(participant.getDescriptor().getImageDescriptor());
        }
    }
}

