/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroIdElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroAnchor;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroInclude;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractIntroContainer
extends AbstractBaseIntroElement {
    protected Vector children;
    protected boolean loaded = false;
    protected boolean resolved = false;
    protected Element element;

    AbstractIntroContainer(IConfigurationElement element) {
        super(element);
    }

    AbstractIntroContainer(Element element, Bundle bundle) {
        super(element, bundle);
        this.element = element;
    }

    public AbstractIntroElement[] getChildren() {
        if (!this.loaded) {
            this.loadChildren();
        }
        if (!this.loaded) {
            return new AbstractIntroElement[0];
        }
        if (!this.resolved) {
            this.resolveChildren();
        }
        AbstractIntroElement[] childrenElements = (AbstractIntroElement[])this.convertToModelArray(this.children, 16383);
        return childrenElements;
    }

    public Object[] getChildrenOfType(int elementMask) {
        AbstractIntroElement[] childrenElements = this.getChildren();
        Vector<AbstractIntroElement> typedChildren = new Vector<AbstractIntroElement>();
        for (int i = 0; i < childrenElements.length; ++i) {
            AbstractIntroElement element = childrenElements[i];
            if (!element.isOfType(elementMask)) continue;
            typedChildren.addElement(element);
        }
        return this.convertToModelArray(typedChildren, elementMask);
    }

    private Object[] convertToModelArray(Vector vector, int elementMask) {
        int size = vector.size();
        AbstractIntroElement[] src = null;
        switch (elementMask) {
            case 16: {
                src = new IntroGroup[size];
                break;
            }
            case 64: {
                src = new IntroLink[size];
                break;
            }
            case 512: {
                src = new IntroText[size];
                break;
            }
            case 128: {
                src = new IntroImage[size];
                break;
            }
            case 32: {
                src = new IntroHTML[size];
                break;
            }
            case 256: {
                src = new IntroInclude[size];
                break;
            }
            case 8: {
                src = new IntroPage[size];
                break;
            }
            case 12: {
                src = new AbstractIntroPage[size];
                break;
            }
            case 29: {
                src = new AbstractIntroContainer[size];
                break;
            }
            case 2048: {
                src = new IntroHead[size];
                break;
            }
            case 4096: {
                src = new IntroPageTitle[size];
                break;
            }
            default: {
                src = new AbstractIntroElement[size];
            }
        }
        if (src == null) {
            return new Object[0];
        }
        vector.copyInto(src);
        return src;
    }

    protected void loadChildren() {
        this.children = new Vector();
        NodeList nodeList = this.element.getChildNodes();
        Vector<Node> vector = new Vector<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            vector.add(node);
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        this.insertElementsBefore((Element[])filteredElements, this.getBundle(), this.children.size());
        this.loaded = true;
        this.element = null;
    }

    protected void insertElementsBefore(Element[] childElements, Bundle bundle, int index) {
        for (int i = 0; i < childElements.length; ++i) {
            Element childElement = childElements[i];
            AbstractIntroElement child = this.getModelChild(childElement, bundle);
            if (child == null) continue;
            child.setParent(this);
            this.children.add(index, child);
            ++index;
        }
    }

    protected void insertElementsBefore(Element[] childElements, Bundle bundle, AbstractIntroElement child) {
        int childLocation = this.children.indexOf(child);
        if (childLocation == -1) {
            return;
        }
        this.insertElementsBefore(childElements, bundle, childLocation);
    }

    protected AbstractIntroElement getModelChild(Element childElement, Bundle bundle) {
        AbstractIntroElement child = null;
        if (childElement.getNodeName().equalsIgnoreCase("group")) {
            child = new IntroGroup(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("link")) {
            child = new IntroLink(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("text")) {
            child = new IntroText(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("img")) {
            child = new IntroImage(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("html")) {
            child = new IntroHTML(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("include")) {
            child = new IntroInclude(childElement, bundle);
        } else if (childElement.getNodeName().equalsIgnoreCase("anchor")) {
            child = new IntroAnchor(childElement, bundle);
        }
        return child;
    }

    protected void resolveChildren() {
        for (int i = 0; i < this.children.size(); ++i) {
            AbstractIntroElement child = (AbstractIntroElement)this.children.elementAt(i);
            if (child.getType() != 256) continue;
            this.resolveInclude((IntroInclude)child);
        }
        this.resolved = true;
    }

    private void resolveInclude(IntroInclude include) {
        AbstractIntroElement target = this.findIncludeTarget(include);
        if (target == null) {
            return;
        }
        if (target.isOfType(4848)) {
            this.insertTarget(include, target);
        }
    }

    private AbstractIntroElement findIncludeTarget(IntroInclude include) {
        String path = include.getPath();
        IntroModelRoot targetModelRoot = (IntroModelRoot)this.getParentPage().getParent();
        String targetConfigID = include.getConfigId();
        if (targetConfigID != null) {
            targetModelRoot = ExtensionPointManager.getInst().getModel(targetConfigID);
        }
        if (targetModelRoot == null) {
            return null;
        }
        AbstractIntroElement target = this.findTarget(targetModelRoot, path);
        return target;
    }

    public AbstractIntroElement findTarget(IntroModelRoot model, String path) {
        String[] pathSegments = path.split("/");
        if (model == null) {
            return null;
        }
        AbstractIntroElement target = model.findChild(pathSegments[0]);
        if (target == null) {
            return null;
        }
        for (int i = 1; i < pathSegments.length; ++i) {
            if (!target.isOfType(29)) {
                return null;
            }
            String pathSegment = pathSegments[i];
            if ((target = ((AbstractIntroContainer)target).findChild(pathSegment)) != null) continue;
            return null;
        }
        return target;
    }

    public AbstractIntroElement findChild(String elementId) {
        return this.findChild(elementId, 13053);
    }

    public AbstractIntroElement findChild(String elementId, int elementMask) {
        if (!this.loaded) {
            this.loadChildren();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            AbstractIntroIdElement child;
            AbstractIntroElement aChild = (AbstractIntroElement)this.children.elementAt(i);
            if (!aChild.isOfType(13053) || (child = (AbstractIntroIdElement)aChild).getId() == null || !child.getId().equals(elementId) || !child.isOfType(elementMask)) continue;
            return child;
        }
        return null;
    }

    private void insertTarget(IntroInclude include, AbstractIntroElement target) {
        int includeLocation = this.children.indexOf(include);
        if (includeLocation == -1) {
            return;
        }
        this.children.remove(includeLocation);
        this.handleIncludeStyleInheritence(include, target);
        AbstractIntroElement clonedTarget = null;
        try {
            clonedTarget = (AbstractIntroElement)target.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log.error("Failed to clone Intro model node.", ex);
            return;
        }
        clonedTarget.setParent(this);
        this.children.insertElementAt(clonedTarget, includeLocation);
    }

    private void handleIncludeStyleInheritence(IntroInclude include, AbstractIntroElement target) {
        if (!include.getMergeStyle()) {
            return;
        }
        if (target.getParent().getType() == 1 || target.getParentPage().equals(include.getParentPage())) {
            return;
        }
        String style = target.getParentPage().getStyle();
        if (style != null) {
            this.getParentPage().addStyle(style);
        }
        if ((style = target.getParentPage().getAltStyle()) != null) {
            Bundle bundle = target.getBundle();
            this.getParentPage().addAltStyle(style, bundle);
        }
        this.getParentPage().addStyles(target.getParentPage().getStyles());
        this.getParentPage().addAltStyles(target.getParentPage().getAltStyles());
    }

    protected AbstractIntroElement cloneTarget(AbstractIntroElement targer) {
        return null;
    }

    public int getType() {
        return 29;
    }

    protected boolean isLoaded() {
        return this.loaded;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractIntroContainer clone = (AbstractIntroContainer)super.clone();
        clone.children = new Vector();
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                AbstractIntroElement cloneChild = (AbstractIntroElement)((AbstractIntroElement)this.children.elementAt(i)).clone();
                cloneChild.setParent(clone);
                clone.children.add(i, cloneChild);
            }
        }
        return clone;
    }
}

