/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class ClasspathUtilCore {
    public static void setClasspath(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        Vector<IClasspathEntry> result = new Vector<IClasspathEntry>();
        monitor.beginTask("", 3);
        ClasspathUtilCore.addSourceAndLibraries(model, result);
        monitor.worked(1);
        result.add(ClasspathUtilCore.createContainerEntry());
        monitor.worked(1);
        result.add(ClasspathUtilCore.createJREEntry());
        monitor.worked(1);
        IClasspathEntry[] entries = result.toArray(new IClasspathEntry[result.size()]);
        IJavaProject javaProject = JavaCore.create((IProject)model.getUnderlyingResource().getProject());
        IJavaModelStatus validation = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])entries, (IPath)javaProject.getOutputLocation());
        if (!validation.isOK()) {
            PDECore.logErrorMessage(validation.getMessage());
            throw new CoreException((IStatus)validation);
        }
        javaProject.setRawClasspath(entries, monitor);
        monitor.done();
    }

    private static void computePluginEntries(IPluginModelBase model, Vector result, IProgressMonitor monitor) {
        try {
            HashSet alreadyAdded = new HashSet();
            if (model.isFragmentModel()) {
                ClasspathUtilCore.addParentPlugin((IFragment)model.getPluginBase(), result, alreadyAdded);
            }
            IPluginImport[] dependencies = model.getPluginBase().getImports();
            for (int i = 0; i < dependencies.length; ++i) {
                IPluginImport dependency = dependencies[i];
                IPlugin plugin = PDECore.getDefault().findPlugin(dependency.getId(), dependency.getVersion(), dependency.getMatch());
                if (plugin != null) {
                    ClasspathUtilCore.addDependency(plugin, dependency.isReexported(), result, alreadyAdded);
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            ClasspathUtilCore.addExtraClasspathEntries(model, result);
            ClasspathUtilCore.addImplicitDependencies(model.getPluginBase().getId(), model.getPluginBase().getSchemaVersion(), result, alreadyAdded);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private static void addExtraClasspathEntries(IPluginModelBase model, Vector result) throws CoreException {
        IBuildEntry entry;
        IBuild build = ClasspathUtilCore.getBuild(model);
        IBuildEntry iBuildEntry = entry = build == null ? null : build.getEntry("jars.extra.classpath");
        if (entry == null) {
            return;
        }
        String[] tokens = entry.getTokens();
        for (int i = 0; i < tokens.length; ++i) {
            IResource resource;
            String device = new Path(tokens[i]).getDevice();
            Path path = null;
            if (device == null) {
                path = new Path(model.getUnderlyingResource().getProject().getName());
                path = path.append(tokens[i]);
            } else if (device.equals("platform:") && (path = new Path(tokens[i])).segmentCount() > 1 && path.segment(0).equals("plugin")) {
                path = path.setDevice(null);
                path = path.removeFirstSegments(1);
            }
            if (path == null || (resource = PDECore.getWorkspace().getRoot().findMember((IPath)path)) == null || !(resource instanceof IFile)) continue;
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)resource.getFullPath(), null, null);
            IProject project = resource.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                IClasspathEntry[] entries = jProject.getRawClasspath();
                for (int j = 0; j < entries.length; ++j) {
                    if (entries[j].getEntryKind() != 1 || entries[j].getContentKind() != 2 || !entries[j].getPath().equals(resource.getFullPath())) continue;
                    newEntry = JavaCore.newLibraryEntry((IPath)entries[j].getPath(), (IPath)entries[j].getSourceAttachmentPath(), (IPath)entries[j].getSourceAttachmentRootPath());
                    break;
                }
            }
            if (result.contains(newEntry)) continue;
            result.add(newEntry);
        }
    }

    public static IClasspathEntry[] computePluginEntries(IPluginModelBase model) {
        Vector result = new Vector();
        ClasspathUtilCore.computePluginEntries(model, result, null);
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    private static void addDependency(IPlugin plugin, boolean isExported, Vector result, HashSet alreadyAdded) throws CoreException {
        if (!alreadyAdded.add(plugin)) {
            return;
        }
        IResource resource = plugin.getModel().getUnderlyingResource();
        if (resource != null) {
            IClasspathEntry entry;
            IProject project = resource.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature") && !result.contains(entry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)isExported))) {
                result.add(entry);
            }
            return;
        }
        IPluginLibrary[] libraries = plugin.getLibraries();
        for (int i = 0; i < libraries.length; ++i) {
            IClasspathEntry entry;
            if ("resource".equals(libraries[i].getType()) || !libraries[i].isExported() || (entry = ClasspathUtilCore.createLibraryEntry(libraries[i], isExported)) == null || result.contains(entry)) continue;
            result.add(entry);
        }
        IPluginImport[] imports = plugin.getImports();
        for (int i = 0; i < imports.length; ++i) {
            IPlugin importedPlugin;
            IPluginImport dependency = imports[i];
            if (!dependency.isReexported() || (importedPlugin = PDECore.getDefault().findPlugin(dependency.getId(), dependency.getVersion(), dependency.getMatch())) == null) continue;
            ClasspathUtilCore.addDependency(importedPlugin, isExported, result, alreadyAdded);
        }
    }

    private static boolean isOSGiRuntime() {
        return PDECore.getDefault().getModelManager().isOSGiRuntime();
    }

    protected static void addImplicitDependencies(String id, String schemaVersion, Vector result, HashSet alreadyAdded) throws CoreException {
        if (ClasspathUtilCore.isOSGiRuntime() && schemaVersion != null || id.equals("org.eclipse.core.boot") || id.equals("org.apache.xerces") || id.startsWith("org.eclipse.swt")) {
            return;
        }
        if (schemaVersion == null && ClasspathUtilCore.isOSGiRuntime()) {
            IPlugin plugin;
            if (!id.equals("org.eclipse.core.runtime") && (plugin = PDECore.getDefault().findPlugin("org.eclipse.core.runtime.compatibility")) != null) {
                ClasspathUtilCore.addDependency(plugin, false, result, alreadyAdded);
            }
        } else {
            IPlugin plugin = PDECore.getDefault().findPlugin("org.eclipse.core.boot");
            if (plugin != null) {
                ClasspathUtilCore.addDependency(plugin, false, result, alreadyAdded);
            }
            if (!id.equals("org.eclipse.core.runtime") && (plugin = PDECore.getDefault().findPlugin("org.eclipse.core.runtime")) != null) {
                ClasspathUtilCore.addDependency(plugin, false, result, alreadyAdded);
            }
        }
    }

    public static IClasspathEntry createJREEntry() {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
    }

    public static void addLibraries(IPluginModelBase model, boolean unconditionallyExport, Vector result) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        for (int i = 0; i < libraries.length; ++i) {
            IClasspathEntry entry = ClasspathUtilCore.createLibraryEntry(libraries[i], unconditionallyExport);
            if (entry == null || result.contains(entry)) continue;
            result.add(entry);
        }
    }

    private static void addParentPlugin(IFragment fragment, Vector result, HashSet alreadyAdded) throws CoreException {
        IPlugin parent = PDECore.getDefault().findPlugin(fragment.getPluginId(), fragment.getPluginVersion(), fragment.getRule());
        if (parent != null) {
            ClasspathUtilCore.addDependency(parent, false, result, alreadyAdded);
            IPluginImport[] imports = parent.getImports();
            for (int i = 0; i < imports.length; ++i) {
                IPlugin plugin;
                if (imports[i].isReexported() || (plugin = PDECore.getDefault().findPlugin(imports[i].getId(), imports[i].getVersion(), imports[i].getMatch())) == null) continue;
                ClasspathUtilCore.addDependency(plugin, false, result, alreadyAdded);
            }
        }
    }

    private static void addSourceAndLibraries(IPluginModelBase model, Vector result) throws CoreException {
        IPath path;
        IProject project = model.getUnderlyingResource().getProject();
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        IBuild build = ClasspathUtilCore.getBuild(model);
        for (int i = 0; i < libraries.length; ++i) {
            IBuildEntry buildEntry;
            IPluginLibrary library = libraries[i];
            if ("resource".equals(library.getType())) continue;
            IBuildEntry iBuildEntry = buildEntry = build == null ? null : build.getEntry("source." + library.getName());
            if (buildEntry != null) {
                String[] folders = buildEntry.getTokens();
                for (int k = 0; k < folders.length; ++k) {
                    path = project.getFullPath().append(folders[k]);
                    if (project.findMember(folders[k]) != null) {
                        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path);
                        if (result.contains(entry)) continue;
                        result.add(entry);
                        continue;
                    }
                    ClasspathUtilCore.addSourceFolder(folders[k], project, result);
                }
                continue;
            }
            IClasspathEntry entry = ClasspathUtilCore.createLibraryEntry(library, library.isExported());
            if (entry == null || result.contains(entry)) continue;
            result.add(entry);
        }
        IClasspathEntry[] entries = JavaCore.create((IProject)project).getRawClasspath();
        for (int i = 0; i < entries.length; ++i) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() != 3 || result.contains(entry)) continue;
            boolean doAdd = true;
            for (int j = 0; j < result.size(); ++j) {
                path = ((IClasspathEntry)result.get(j)).getPath();
                if (!path.isPrefixOf(entry.getPath()) && !entry.getPath().isPrefixOf(path)) continue;
                doAdd = false;
                break;
            }
            if (!doAdd) continue;
            result.add(entry);
        }
    }

    protected static void addSourceFolder(String name, IProject project, Vector result) throws CoreException {
        CoreUtility.createFolder(project.getFolder(name), true, true, null);
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)project.getFullPath().append(name));
        if (!result.contains(entry)) {
            result.add(entry);
        }
    }

    public static IClasspathEntry createContainerEntry() {
        return JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
    }

    private static IClasspathEntry createLibraryEntry(IPluginLibrary library, boolean exported) {
        try {
            String name = library.getName();
            String expandedName = ClasspathUtilCore.expandLibraryName(name);
            IPluginModelBase model = library.getPluginModel();
            IPath path = ClasspathUtilCore.getPath(model, expandedName);
            if (path == null) {
                if (model.isFragmentModel() || !ClasspathUtilCore.containsVariables(name)) {
                    return null;
                }
                model = ClasspathUtilCore.resolveLibraryInFragments(library, expandedName);
                if (model == null) {
                    return null;
                }
                path = ClasspathUtilCore.getPath(model, expandedName);
            }
            return JavaCore.newLibraryEntry((IPath)path, (IPath)ClasspathUtilCore.getSourceAnnotation(model, expandedName), null, (boolean)exported);
        }
        catch (CoreException e) {
            return null;
        }
    }

    public static boolean containsVariables(String name) {
        return name.indexOf("$os$") != -1 || name.indexOf("$ws$") != -1 || name.indexOf("$nl$") != -1 || name.indexOf("$arch$") != -1;
    }

    public static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.indexOf("$ws$") != -1) {
            source = source.replaceAll("\\$ws\\$", "ws/" + TargetPlatform.getWS());
        }
        if (source.indexOf("$os$") != -1) {
            source = source.replaceAll("\\$os\\$", "os/" + TargetPlatform.getOS());
        }
        if (source.indexOf("$nl$") != -1) {
            source = source.replaceAll("\\$nl\\$", "nl/" + TargetPlatform.getNL());
        }
        if (source.indexOf("$arch$") != -1) {
            source = source.replaceAll("\\$arch\\$", "arch/" + TargetPlatform.getOSArch());
        }
        return source;
    }

    protected static IBuild getBuild(IPluginModelBase model) throws CoreException {
        IProject project;
        IFile buildFile;
        IBuildModel buildModel = model.getBuildModel();
        if (buildModel == null && (buildFile = (project = model.getUnderlyingResource().getProject()).getFile("build.properties")).exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel != null ? buildModel.getBuild() : null;
    }

    private static IPath getSourceAnnotation(IPluginModelBase model, String libraryName) throws CoreException {
        String zipName;
        IPath path = null;
        int dot = libraryName.lastIndexOf(46);
        if (dot != -1 && (path = ClasspathUtilCore.getPath(model, zipName = libraryName.substring(0, dot) + "src.zip")) == null) {
            SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
            path = manager.findPath(model.getPluginBase(), (IPath)new Path(zipName));
        }
        return path;
    }

    private static IPluginModelBase resolveLibraryInFragments(IPluginLibrary library, String libraryName) {
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(library.getPluginBase().getId(), library.getPluginBase().getVersion());
        for (int i = 0; i < fragments.length; ++i) {
            ModelEntry entry;
            IPluginModelBase model;
            IPath path = ClasspathUtilCore.getPath(fragments[i].getPluginModel(), libraryName);
            if (path != null) {
                return fragments[i].getPluginModel();
            }
            if (fragments[i].getModel().getUnderlyingResource() == null || (model = (entry = PDECore.getDefault().getModelManager().findEntry(fragments[i].getId())).getExternalModel()) == null || !(model instanceof IFragmentModel) || (path = ClasspathUtilCore.getPath(model, libraryName)) == null) continue;
            return model;
        }
        return null;
    }

    private static IPath getPath(IPluginModelBase model, String libraryName) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IResource jarFile = resource.getProject().findMember(libraryName);
            if (jarFile != null) {
                return jarFile.getFullPath();
            }
        } else {
            File file = new File(model.getInstallLocation(), libraryName);
            if (file.exists()) {
                return new Path(file.getAbsolutePath());
            }
        }
        return null;
    }
}

