/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.FeatureStatus;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationValidator;

public class OperationValidator
implements IOperationValidator {
    private static final String KEY_ROOT_MESSAGE = "ActivityConstraints.rootMessage";
    private static final String KEY_ROOT_MESSAGE_INIT = "ActivityConstraints.rootMessageInitial";
    private static final String KEY_CHILD_MESSAGE = "ActivityConstraints.childMessage";
    private static final String KEY_PLATFORM = "ActivityConstraints.platform";
    private static final String KEY_PRIMARY = "ActivityConstraints.primary";
    private static final String KEY_OS = "ActivityConstraints.os";
    private static final String KEY_WS = "ActivityConstraints.ws";
    private static final String KEY_ARCH = "ActivityConstraints.arch";
    private static final String KEY_PREREQ = "ActivityConstraints.prereq";
    private static final String KEY_PREREQ_PLUGIN = "ActivityConstaints.prereq.plugin";
    private static final String KEY_PREREQ_FEATURE = "ActivityConstaints.prereq.feature";
    private static final String KEY_PREREQ_PERFECT = "ActivityConstraints.prereqPerfect";
    private static final String KEY_PREREQ_EQUIVALENT = "ActivityConstraints.prereqEquivalent";
    private static final String KEY_PREREQ_COMPATIBLE = "ActivityConstraints.prereqCompatible";
    private static final String KEY_PREREQ_GREATER = "ActivityConstraints.prereqGreaterOrEqual";
    private static final String KEY_OPTIONAL_CHILD = "ActivityConstraints.optionalChild";
    private static final String KEY_CYCLE = "ActivityConstraints.cycle";
    private static final String KEY_CONFLICT = "ActivityConstraints.conflict";
    private static final String KEY_EXCLUSIVE = "ActivityConstraints.exclusive";
    private static final String KEY_NO_LICENSE = "ActivityConstraints.noLicense";

    public IStatus validatePlatformConfigValid() {
        ArrayList status = new ArrayList(1);
        OperationValidator.checkPlatformWasModified(status);
        if (status.size() > 0) {
            return OperationValidator.createMultiStatus(KEY_ROOT_MESSAGE, status, 4);
        }
        return null;
    }

    public IStatus validatePendingInstall(IFeature oldFeature, IFeature newFeature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateInstall(oldFeature, newFeature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingUnconfig(IFeature feature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateUnconfigure(feature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingConfig(IFeature feature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateConfigure(feature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingReplaceVersion(IFeature feature, IFeature anotherFeature) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateReplaceVersion(feature, anotherFeature, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingRevert(IInstallConfiguration config) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateRevert(config, status);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validatePendingChanges(IInstallFeatureOperation[] jobs) {
        ArrayList beforeStatus = new ArrayList();
        OperationValidator.validateInitialState(beforeStatus);
        OperationValidator.checkPlatformWasModified(beforeStatus);
        ArrayList status = new ArrayList();
        OperationValidator.validatePendingChanges(jobs, status, beforeStatus);
        return OperationValidator.createCombinedReportStatus(beforeStatus, status);
    }

    public IStatus validateCurrentState() {
        ArrayList status = new ArrayList();
        OperationValidator.checkPlatformWasModified(status);
        OperationValidator.validateInitialState(status);
        if (status.size() > 0) {
            return OperationValidator.createMultiStatus(KEY_ROOT_MESSAGE, status, 4);
        }
        return null;
    }

    private static void validateInitialState(ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateUnconfigure(IFeature feature, ArrayList status) {
        try {
            OperationValidator.checkSiteReadOnly(feature, status);
            ArrayList features = OperationValidator.computeFeatures();
            features = OperationValidator.computeFeaturesAfterOperation(features, null, feature);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateConfigure(IFeature feature, ArrayList status) {
        try {
            OperationValidator.checkSiteReadOnly(feature, status);
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkOptionalChildConfiguring(feature, status);
            OperationValidator.checkForCycles(feature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, feature, null);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateReplaceVersion(IFeature feature, IFeature anotherFeature, ArrayList status) {
        try {
            OperationValidator.checkSiteReadOnly(feature, status);
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkForCycles(feature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, anotherFeature, feature);
            OperationValidator.checkConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateInstall(IFeature oldFeature, IFeature newFeature, ArrayList status) {
        try {
            OperationValidator.checkSiteReadOnly(oldFeature, status);
            ArrayList features = OperationValidator.computeFeatures();
            OperationValidator.checkForCycles(newFeature, null, features);
            features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
            OperationValidator.checkConstraints(features, status);
            OperationValidator.checkLicense(newFeature, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validateRevert(IInstallConfiguration config, ArrayList status) {
        try {
            ArrayList features = OperationValidator.computeFeaturesAfterRevert(config);
            OperationValidator.checkConstraints(features, status);
            OperationValidator.checkRevertConstraints(features, status);
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void validatePendingChanges(IInstallFeatureOperation[] jobs, ArrayList status, ArrayList beforeStatus) {
        try {
            IFeature oldFeature;
            IFeature newFeature;
            IInstallFeatureOperation job;
            int i;
            ArrayList features;
            ArrayList savedFeatures = features = OperationValidator.computeFeatures();
            int nexclusives = 0;
            ArrayList tmpStatus = new ArrayList();
            for (i = 0; i < jobs.length; ++i) {
                job = jobs[i];
                newFeature = job.getFeature();
                oldFeature = job.getOldFeature();
                OperationValidator.checkLicense(newFeature, status);
                if (jobs.length > 1 && newFeature.isExclusive()) {
                    ++nexclusives;
                    status.add(OperationValidator.createStatus(newFeature, 4, Policy.bind(KEY_EXCLUSIVE)));
                    continue;
                }
                OperationValidator.checkForCycles(newFeature, null, features);
                features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
            }
            if (nexclusives > 0) {
                return;
            }
            OperationValidator.checkConstraints(features, tmpStatus);
            if (tmpStatus.size() == 0) {
                return;
            }
            features = savedFeatures;
            for (i = 0; i < jobs.length; ++i) {
                job = jobs[i];
                newFeature = job.getFeature();
                oldFeature = job.getOldFeature();
                features = OperationValidator.computeFeaturesAfterOperation(features, newFeature, oldFeature);
                OperationValidator.checkConstraints(features, status);
                if (status.size() <= 0 || OperationValidator.isBetterStatus(beforeStatus, status)) continue;
                IStatus conflict = OperationValidator.createStatus(newFeature, 0, Policy.bind(KEY_CONFLICT));
                status.add(0, conflict);
                return;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private static void checkPlatformWasModified(ArrayList status) {
        try {
            IPlatformConfiguration platformConfig = ConfiguratorUtils.getCurrentPlatformConfiguration();
            long currentTimeStamp = platformConfig.getChangeStamp();
            if (platformConfig instanceof PlatformConfiguration) {
                currentTimeStamp = ((PlatformConfiguration)platformConfig).getConfiguration().lastModified();
            }
            URL platformXML = platformConfig.getConfigurationLocation();
            long actualTimeStamp = currentTimeStamp;
            if ("file".equals(platformXML.getProtocol())) {
                actualTimeStamp = new File(platformXML.getFile()).lastModified();
            } else {
                URLConnection connection = platformXML.openConnection();
                actualTimeStamp = connection.getLastModified();
            }
            if (currentTimeStamp != actualTimeStamp) {
                status.add(OperationValidator.createStatus(null, 0, Policy.bind("ActivityConstraints.platformModified")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void checkSiteReadOnly(IFeature feature, ArrayList status) {
        if (feature == null) {
            return;
        }
        IConfiguredSite csite = feature.getSite().getCurrentConfiguredSite();
        if (csite != null && !csite.isUpdatable()) {
            status.add(OperationValidator.createStatus(feature, 0, Policy.bind("ActivityConstraints.readOnly", csite.getSite().getURL().toExternalForm())));
        }
    }

    private static ArrayList computeFeatures() throws CoreException {
        return OperationValidator.computeFeatures(true);
    }

    private static ArrayList computeFeatures(boolean configuredOnly) throws CoreException {
        ArrayList<IFeature> features = new ArrayList<IFeature>();
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.getCurrentConfiguration();
        IConfiguredSite[] csites = config.getConfiguredSites();
        for (int i = 0; i < csites.length; ++i) {
            IConfiguredSite csite = csites[i];
            IFeatureReference[] crefs = configuredOnly ? csite.getConfiguredFeatures() : csite.getSite().getFeatureReferences();
            for (int j = 0; j < crefs.length; ++j) {
                IFeatureReference cref = crefs[j];
                IFeature cfeature = cref.getFeature(null);
                features.add(cfeature);
            }
        }
        return features;
    }

    private static ArrayList computeFeatureSubtree(IFeature top, IFeature feature, ArrayList features, boolean tolerateMissingChildren, ArrayList configuredFeatures, ArrayList visitedFeatures) throws CoreException {
        if (top == null) {
            return features;
        }
        if (feature == null) {
            feature = top;
        }
        if (features == null) {
            features = new ArrayList();
        }
        if (visitedFeatures == null) {
            visitedFeatures = new ArrayList<IFeature>();
        }
        if (visitedFeatures.contains(feature)) {
            IStatus status = OperationValidator.createStatus(top, 8, Policy.bind(KEY_CYCLE));
            throw new CoreException(status);
        }
        visitedFeatures.add(feature);
        if (!features.contains(feature)) {
            features.add(feature);
        }
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        for (int i = 0; i < children.length; ++i) {
            try {
                IFeature child = children[i].getFeature(null);
                features = OperationValidator.computeFeatureSubtree(top, child, features, tolerateMissingChildren, null, visitedFeatures);
                continue;
            }
            catch (CoreException e) {
                if (children[i].isOptional() || tolerateMissingChildren) continue;
                throw e;
            }
        }
        visitedFeatures.remove(feature);
        return features;
    }

    private static void checkLicense(IFeature feature, ArrayList status) {
        String license;
        IURLEntry licenseEntry = feature.getLicense();
        if (licenseEntry != null && (license = licenseEntry.getAnnotation()) != null && license.trim().length() > 0) {
            return;
        }
        status.add(OperationValidator.createStatus(feature, 0, Policy.bind(KEY_NO_LICENSE)));
    }

    private static ArrayList computeFeaturesAfterOperation(ArrayList features, IFeature add, IFeature remove) throws CoreException {
        ArrayList addTree = OperationValidator.computeFeatureSubtree(add, null, null, false, features, null);
        ArrayList removeTree = OperationValidator.computeFeatureSubtree(remove, null, null, true, null, null);
        if (remove != null) {
            OperationValidator.contributePatchesFor(removeTree, features, removeTree);
        }
        if (remove != null) {
            features.removeAll(removeTree);
        }
        if (add != null) {
            features.addAll(addTree);
        }
        return features;
    }

    private static void contributePatchesFor(ArrayList removeTree, ArrayList features, ArrayList result) throws CoreException {
        for (int i = 0; i < removeTree.size(); ++i) {
            IFeature feature = (IFeature)removeTree.get(i);
            OperationValidator.contributePatchesFor(feature, features, result);
        }
    }

    private static void contributePatchesFor(IFeature feature, ArrayList features, ArrayList result) throws CoreException {
        for (int i = 0; i < features.size(); ++i) {
            IFeature candidate = (IFeature)features.get(i);
            if (!UpdateUtils.isPatch(feature, candidate)) continue;
            ArrayList removeTree = OperationValidator.computeFeatureSubtree(candidate, null, null, true, null, null);
            result.addAll(removeTree);
        }
    }

    private static ArrayList computeFeaturesAfterRevert(IInstallConfiguration config) throws CoreException {
        ArrayList<IFeature> list = new ArrayList<IFeature>();
        IConfiguredSite[] csites = config.getConfiguredSites();
        for (int i = 0; i < csites.length; ++i) {
            IConfiguredSite csite = csites[i];
            IFeatureReference[] features = csite.getConfiguredFeatures();
            for (int j = 0; j < features.length; ++j) {
                list.add(features[j].getFeature(null));
            }
        }
        return list;
    }

    private static ArrayList computePluginsForFeatures(ArrayList features) throws CoreException {
        if (features == null) {
            return new ArrayList();
        }
        HashMap<VersionedIdentifier, IPluginEntry> plugins = new HashMap<VersionedIdentifier, IPluginEntry>();
        for (int i = 0; i < features.size(); ++i) {
            IFeature feature = (IFeature)features.get(i);
            IPluginEntry[] entries = feature.getPluginEntries();
            for (int j = 0; j < entries.length; ++j) {
                IPluginEntry entry = entries[j];
                plugins.put(entry.getVersionedIdentifier(), entry);
            }
        }
        ArrayList result = new ArrayList();
        result.addAll(plugins.values());
        return result;
    }

    private static void checkForCycles(IFeature feature, ArrayList candidates, ArrayList configuredFeatures) throws CoreException {
        if (feature == null) {
            return;
        }
        if (configuredFeatures == null) {
            configuredFeatures = new ArrayList();
        }
        if (candidates == null) {
            candidates = new ArrayList<IFeature>();
        }
        if (candidates.contains(feature)) {
            String msg = Policy.bind(KEY_CYCLE, new String[]{feature.getLabel(), feature.getVersionedIdentifier().toString()});
            IStatus status = OperationValidator.createStatus(feature, 8, msg);
            throw new CoreException(status);
        }
        candidates.add(feature);
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        for (int i = 0; i < children.length; ++i) {
            try {
                IFeature child = children[i].getFeature(null);
                OperationValidator.checkForCycles(child, candidates, configuredFeatures);
                continue;
            }
            catch (CoreException e) {
                if (children[i].isOptional()) continue;
                throw e;
            }
        }
        candidates.remove(feature);
    }

    private static void checkConstraints(ArrayList features, ArrayList status) throws CoreException {
        if (features == null) {
            return;
        }
        ArrayList plugins = OperationValidator.computePluginsForFeatures(features);
        OperationValidator.checkEnvironment(features, status);
        OperationValidator.checkPlatformFeature(features, plugins, status);
        OperationValidator.checkPrimaryFeature(features, status);
        OperationValidator.checkPrereqs(features, plugins, status);
    }

    private static void checkEnvironment(ArrayList features, ArrayList status) {
        String os = Platform.getOS();
        String ws = Platform.getWS();
        String arch = Platform.getOSArch();
        for (int i = 0; i < features.size(); ++i) {
            IStatus s;
            IFeature feature = (IFeature)features.get(i);
            ArrayList fos = OperationValidator.createList(feature.getOS());
            ArrayList fws = OperationValidator.createList(feature.getWS());
            ArrayList farch = OperationValidator.createList(feature.getOSArch());
            if (fos.size() > 0 && !fos.contains(os)) {
                s = OperationValidator.createStatus(feature, 32, Policy.bind(KEY_OS));
                if (status.contains(s)) continue;
                status.add(s);
                continue;
            }
            if (fws.size() > 0 && !fws.contains(ws)) {
                s = OperationValidator.createStatus(feature, 32, Policy.bind(KEY_WS));
                if (status.contains(s)) continue;
                status.add(s);
                continue;
            }
            if (farch.size() <= 0 || farch.contains(arch) || status.contains(s = OperationValidator.createStatus(feature, 32, Policy.bind(KEY_ARCH)))) continue;
            status.add(s);
        }
    }

    private static void checkPlatformFeature(ArrayList features, ArrayList plugins, ArrayList status) {
        String[] bootstrapPlugins = ConfiguratorUtils.getCurrentPlatformConfiguration().getBootstrapPluginIdentifiers();
        for (int i = 0; i < bootstrapPlugins.length; ++i) {
            boolean found = false;
            for (int j = 0; j < plugins.size(); ++j) {
                IPluginEntry plugin = (IPluginEntry)plugins.get(j);
                if (!bootstrapPlugins[i].equals(plugin.getVersionedIdentifier().getIdentifier())) continue;
                found = true;
                break;
            }
            if (found) continue;
            IStatus s = OperationValidator.createStatus(null, 0, Policy.bind(KEY_PLATFORM));
            if (!status.contains(s)) {
                status.add(s);
            }
            return;
        }
    }

    private static void checkPrimaryFeature(ArrayList features, ArrayList status) {
        String featureId = ConfiguratorUtils.getCurrentPlatformConfiguration().getPrimaryFeatureIdentifier();
        if (featureId == null) {
            return;
        }
        for (int i = 0; i < features.size(); ++i) {
            IFeature feature = (IFeature)features.get(i);
            if (!featureId.equals(feature.getVersionedIdentifier().getIdentifier())) continue;
            return;
        }
        IStatus s = OperationValidator.createStatus(null, 0, Policy.bind(KEY_PRIMARY));
        if (!status.contains(s)) {
            status.add(s);
        }
    }

    private static void checkPrereqs(ArrayList features, ArrayList plugins, ArrayList status) {
        for (int i = 0; i < features.size(); ++i) {
            IFeature feature = (IFeature)features.get(i);
            IImport[] imports = feature.getImports();
            for (int j = 0; j < imports.length; ++j) {
                IStatus s;
                IImport iimport = imports[j];
                VersionedIdentifier iid = iimport.getVersionedIdentifier();
                String id = iid.getIdentifier();
                PluginVersionIdentifier version = iid.getVersion();
                boolean featurePrereq = iimport.getKind() == 1;
                boolean ignoreVersion = version.getMajorComponent() == 0 && version.getMinorComponent() == 0 && version.getServiceComponent() == 0;
                int rule = iimport.getRule();
                if (rule == 0) {
                    rule = 3;
                }
                boolean found = false;
                ArrayList candidates = featurePrereq ? features : plugins;
                for (int k = 0; k < candidates.size(); ++k) {
                    VersionedIdentifier cid;
                    if (featurePrereq) {
                        IFeature candidate = (IFeature)candidates.get(k);
                        if (feature.equals(candidate)) continue;
                        cid = candidate.getVersionedIdentifier();
                    } else {
                        IPluginEntry plugin = (IPluginEntry)candidates.get(k);
                        cid = plugin.getVersionedIdentifier();
                    }
                    PluginVersionIdentifier cversion = cid.getVersion();
                    if (id.equals(cid.getIdentifier())) {
                        if (ignoreVersion) {
                            found = true;
                        } else if (rule == 1 && cversion.isPerfect(version)) {
                            found = true;
                        } else if (rule == 2 && cversion.isEquivalentTo(version)) {
                            found = true;
                        } else if (rule == 3 && cversion.isCompatibleWith(version)) {
                            found = true;
                        } else if (rule == 4 && cversion.isGreaterOrEqualTo(version)) {
                            found = true;
                        }
                    }
                    if (found) break;
                }
                if (found) continue;
                String target = featurePrereq ? Policy.bind(KEY_PREREQ_FEATURE) : Policy.bind(KEY_PREREQ_PLUGIN);
                int errorCode = featurePrereq ? 1 : 2;
                String msg = Policy.bind(KEY_PREREQ, new String[]{target, id});
                if (!ignoreVersion) {
                    if (rule == 1) {
                        msg = Policy.bind(KEY_PREREQ_PERFECT, new String[]{target, id, version.toString()});
                    } else if (rule == 2) {
                        msg = Policy.bind(KEY_PREREQ_EQUIVALENT, new String[]{target, id, version.toString()});
                    } else if (rule == 3) {
                        msg = Policy.bind(KEY_PREREQ_COMPATIBLE, new String[]{target, id, version.toString()});
                    } else if (rule == 4) {
                        msg = Policy.bind(KEY_PREREQ_GREATER, new String[]{target, id, version.toString()});
                    }
                }
                if (status.contains(s = OperationValidator.createStatus(feature, errorCode, msg))) continue;
                status.add(s);
            }
        }
    }

    private static void checkRevertConstraints(ArrayList features, ArrayList status) {
        for (int i = 0; i < features.size(); ++i) {
            IFeature feature = (IFeature)features.get(i);
            try {
                OperationValidator.computeFeatureSubtree(feature, null, null, false, null, null);
                continue;
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
    }

    private static void checkOptionalChildConfiguring(IFeature feature, ArrayList status) throws CoreException {
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.getCurrentConfiguration();
        IConfiguredSite[] csites = config.getConfiguredSites();
        boolean included = false;
        for (int i = 0; i < csites.length; ++i) {
            IConfiguredSite csite = csites[i];
            ISiteFeatureReference[] crefs = csite.getSite().getFeatureReferences();
            for (int j = 0; j < crefs.length; ++j) {
                ISiteFeatureReference cref = crefs[j];
                IFeature cfeature = null;
                cfeature = cref.getFeature(null);
                if (!OperationValidator.isParent(cfeature, feature, true)) continue;
                included = true;
                if (!csite.isConfigured(cfeature)) continue;
                return;
            }
        }
        if (included) {
            String msg = Policy.bind(KEY_OPTIONAL_CHILD);
            status.add(OperationValidator.createStatus(feature, 16, msg));
        }
    }

    private static boolean isParent(IFeature candidate, IFeature feature, boolean optionalOnly) throws CoreException {
        IIncludedFeatureReference[] refs = candidate.getIncludedFeatureReferences();
        for (int i = 0; i < refs.length; ++i) {
            PluginVersionIdentifier cversion;
            PluginVersionIdentifier fversion;
            IIncludedFeatureReference child = refs[i];
            VersionedIdentifier fvid = feature.getVersionedIdentifier();
            VersionedIdentifier cvid = child.getVersionedIdentifier();
            if (!fvid.getIdentifier().equals(cvid.getIdentifier()) || !(fversion = fvid.getVersion()).equals((Object)(cversion = cvid.getVersion()))) continue;
            return !optionalOnly || child.isOptional();
        }
        return false;
    }

    private static IStatus createMultiStatus(String rootKey, ArrayList children, int code) {
        IStatus[] carray = children.toArray(new IStatus[children.size()]);
        String message = Policy.bind(rootKey);
        return new MultiStatus(UpdateCore.getPlugin().getBundle().getSymbolicName(), code, carray, message, null);
    }

    private static IStatus createStatus(IFeature feature, int errorCode, String message) {
        String fullMessage;
        if (feature == null) {
            fullMessage = message;
        } else {
            PluginVersionIdentifier version = feature.getVersionedIdentifier().getVersion();
            fullMessage = Policy.bind(KEY_CHILD_MESSAGE, new String[]{feature.getLabel(), version.toString(), message});
        }
        return new FeatureStatus(feature, 4, UpdateCore.getPlugin().getBundle().getSymbolicName(), errorCode, fullMessage, null);
    }

    private static IStatus createCombinedReportStatus(ArrayList beforeStatus, ArrayList status) {
        if (beforeStatus.size() == 0) {
            if (status.size() == 0) {
                return null;
            }
            return OperationValidator.createMultiStatus(KEY_ROOT_MESSAGE, status, 4);
        }
        if (status.size() == 0) {
            return null;
        }
        if (OperationValidator.isBetterStatus(beforeStatus, status)) {
            return OperationValidator.createMultiStatus("ActivityConstraints.warning", beforeStatus, 2);
        }
        ArrayList<IStatus> combined = new ArrayList<IStatus>();
        combined.add(OperationValidator.createMultiStatus("ActivityConstraints.beforeMessage", beforeStatus, 4));
        combined.add(OperationValidator.createMultiStatus("ActivityConstraints.afterMessage", status, 4));
        return OperationValidator.createMultiStatus(KEY_ROOT_MESSAGE_INIT, combined, 4);
    }

    private static ArrayList createList(String commaSeparatedList) {
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedList != null) {
            StringTokenizer t = new StringTokenizer(commaSeparatedList.trim(), ",");
            while (t.hasMoreTokens()) {
                String token = t.nextToken().trim();
                if (token.equals("")) continue;
                list.add(token);
            }
        }
        return list;
    }

    private static boolean isBetterStatus(ArrayList beforeStatus, ArrayList status) {
        if (status == null || status.size() == 0) {
            return true;
        }
        if (beforeStatus == null || beforeStatus.size() == 0) {
            return false;
        }
        if (beforeStatus.size() < status.size()) {
            return false;
        }
        for (int i = 0; i < status.size(); ++i) {
            IStatus s = (IStatus)status.get(i);
            if (!(s instanceof FeatureStatus)) {
                return false;
            }
            FeatureStatus fs = (FeatureStatus)s;
            boolean found = false;
            for (int j = 0; !found && j < beforeStatus.size(); ++j) {
                if (!fs.equals(beforeStatus.get(j))) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

