/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.ISelectionPolicy;

public class Eclipse21SelectionPolicy
implements ISelectionPolicy {
    public Set selectMultiple(ElementSet elementSet) {
        Set<Object> selected = new HashSet();
        Iterator requiringIter = elementSet.getRequiring().iterator();
        while (requiringIter.hasNext()) {
            ElementSet requiringNode = (ElementSet)requiringIter.next();
            Set requiringNodeSelectedVersions = requiringNode.getSelected();
            Iterator requiringVersionsIter = requiringNodeSelectedVersions.iterator();
            while (requiringVersionsIter.hasNext()) {
                Element requiringSelectedVersion = (Element)requiringVersionsIter.next();
                Dependency requiringSelectedVersionDependency = requiringSelectedVersion.getDependency(elementSet.getId());
                if (requiringSelectedVersionDependency == null) continue;
                Element bestVersion = null;
                Iterator satisfiedIter = elementSet.getSatisfied().iterator();
                while (satisfiedIter.hasNext()) {
                    boolean betterThanBest;
                    Element satisfiedVersion = (Element)satisfiedIter.next();
                    boolean satisfiesDependency = requiringSelectedVersionDependency.getMatchRule().isSatisfied(requiringSelectedVersionDependency.getUserObject(), satisfiedVersion.getVersionId());
                    if (!satisfiesDependency || !(betterThanBest = bestVersion == null || elementSet.getSystem().compare(satisfiedVersion.getVersionId(), bestVersion.getVersionId()) > 0)) continue;
                    bestVersion = satisfiedVersion;
                }
                if (bestVersion == null) continue;
                selected.add(bestVersion);
            }
        }
        if (selected.isEmpty()) {
            Element bestVersion = null;
            Iterator satisfiedIter = elementSet.getSatisfied().iterator();
            while (satisfiedIter.hasNext()) {
                Element satisfiedVersion = (Element)satisfiedIter.next();
                boolean betterThanBest = bestVersion == null || elementSet.getSystem().compare(satisfiedVersion.getVersionId(), bestVersion.getVersionId()) > 0;
                if (!betterThanBest) continue;
                bestVersion = satisfiedVersion;
            }
            selected = Collections.singleton(bestVersion);
        }
        return selected;
    }

    public Element selectSingle(ElementSet elementSet) {
        if (elementSet.getRequiring().isEmpty()) {
            Element highest = null;
            Iterator satisfiedIter = elementSet.getSatisfied().iterator();
            while (satisfiedIter.hasNext()) {
                Element satisfiedVersion = (Element)satisfiedIter.next();
                if (highest != null && elementSet.getSystem().compare(satisfiedVersion.getVersionId(), highest.getVersionId()) <= 0) continue;
                highest = satisfiedVersion;
            }
            return highest;
        }
        Element highest = null;
        int highestStatus = 0;
        Iterator satisfiedIter = elementSet.getSatisfied().iterator();
        while (satisfiedIter.hasNext()) {
            boolean higherThanHighest;
            boolean satisfiesAllMandatory = true;
            boolean satisfiesAll = true;
            boolean isRequired = false;
            Element satisfiedVersion = (Element)satisfiedIter.next();
            Iterator requiringIter = elementSet.getRequiring().iterator();
            while (requiringIter.hasNext()) {
                ElementSet requiringNode = (ElementSet)requiringIter.next();
                Set requiringNodeSelectedVersions = requiringNode.getSelected();
                Iterator requiringVersionsIter = requiringNodeSelectedVersions.iterator();
                while (requiringVersionsIter.hasNext()) {
                    Element requiringSelectedVersion = (Element)requiringVersionsIter.next();
                    Dependency requiringSelectedVersionDep = requiringSelectedVersion.getDependency(elementSet.getId());
                    if (requiringSelectedVersionDep == null) continue;
                    boolean satisfiesDependency = requiringSelectedVersionDep.getMatchRule().isSatisfied(requiringSelectedVersionDep.getUserObject(), satisfiedVersion.getVersionId());
                    isRequired |= satisfiesDependency;
                    satisfiesAll &= satisfiesDependency;
                    satisfiesAllMandatory &= satisfiesDependency | requiringSelectedVersionDep.isOptional();
                }
            }
            int status = satisfiesAll ? 3 : (satisfiesAllMandatory ? 2 : (isRequired ? 1 : 0));
            boolean bl = higherThanHighest = highest == null || elementSet.getSystem().compare(satisfiedVersion.getVersionId(), highest.getVersionId()) > 0;
            if (status <= highestStatus && (status != highestStatus || !higherThanHighest)) continue;
            highest = satisfiedVersion;
            highestStatus = status;
        }
        return highest;
    }
}

